/*
 * Decompiled with CFR 0.152.
 */
package caeruleusTait.world.preview;

import caeruleusTait.world.preview.WorldPreview;
import caeruleusTait.world.preview.backend.sampler.ChunkSampler;
import caeruleusTait.world.preview.backend.sampler.FullQuartSampler;
import caeruleusTait.world.preview.backend.sampler.QuarterQuartSampler;
import caeruleusTait.world.preview.backend.sampler.SingleQuartSampler;
import java.util.function.IntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class RenderSettings {
    private BlockPos center = new BlockPos(0, 0, 0);
    private int quartExpand = 1;
    private int quartStride = 1;
    public SamplerType samplerType = SamplerType.AUTO;
    public ResourceLocation dimension = null;
    public boolean hideAllStructures = false;
    public transient RenderMode mode = RenderMode.BIOMES;
    public transient RenderMode lastNoise = RenderMode.NOISE_TEMPERATURE;

    public BlockPos center() {
        return this.center;
    }

    public void setCenter(BlockPos center) {
        this.center = center;
    }

    public void resetCenter() {
        this.center = new BlockPos(0, WorldPreview.get().workManager().yMax(), 0);
    }

    public void incrementY() {
        int nextY = Math.min(this.center.m_123342_() + 8, WorldPreview.get().workManager().yMax()) / 8 * 8;
        this.center = new BlockPos(this.center.m_123341_(), nextY, this.center.m_123343_());
    }

    public void decrementY() {
        int nextY = Math.max(this.center.m_123342_() - 8, WorldPreview.get().workManager().yMin()) / 8 * 8;
        this.center = new BlockPos(this.center.m_123341_(), nextY, this.center.m_123343_());
    }

    public int quartExpand() {
        return this.quartExpand;
    }

    public int quartStride() {
        return this.quartStride;
    }

    public int pixelsPerChunk() {
        return 4 * this.quartExpand / this.quartStride;
    }

    public void setPixelsPerChunk(int blocksPerChunk) {
        switch (blocksPerChunk) {
            case 16: {
                this.quartExpand = 4;
                this.quartStride = 1;
                break;
            }
            case 8: {
                this.quartExpand = 2;
                this.quartStride = 1;
                break;
            }
            case 4: {
                this.quartExpand = 1;
                this.quartStride = 1;
                break;
            }
            case 2: {
                this.quartExpand = 1;
                this.quartStride = 2;
                break;
            }
            case 1: {
                this.quartExpand = 1;
                this.quartStride = 4;
                break;
            }
            default: {
                throw new RuntimeException("Invalid blocksPerChunk=" + blocksPerChunk);
            }
        }
    }

    public static enum SamplerType {
        AUTO(x -> switch (x) {
            case 1 -> new FullQuartSampler();
            case 2 -> new QuarterQuartSampler();
            case 4 -> new SingleQuartSampler();
            default -> throw new RuntimeException("Unsupported quart stride: " + x);
        }),
        FULL(x -> new FullQuartSampler()),
        QUARTER(x -> new QuarterQuartSampler()),
        SINGLE(x -> new SingleQuartSampler());

        private final IntFunction<ChunkSampler> samplerFactory;

        private SamplerType(IntFunction<ChunkSampler> samplerFactory) {
            this.samplerFactory = samplerFactory;
        }

        public ChunkSampler create(int quartStride) {
            return this.samplerFactory.apply(quartStride);
        }
    }

    public static enum RenderMode {
        BIOMES(0L, true),
        HEIGHTMAP(2L, false),
        INTERSECTIONS(3L, true),
        NOISE_TEMPERATURE(9L, true),
        NOISE_HUMIDITY(10L, true),
        NOISE_CONTINENTALNESS(11L, true),
        NOISE_EROSION(12L, true),
        NOISE_DEPTH(13L, true),
        NOISE_WEIRDNESS(14L, true),
        NOISE_PEAKS_AND_VALLEYS(14L, true);

        public final long flag;
        public final boolean useY;

        private RenderMode(long flag, boolean useY) {
            this.flag = flag;
            this.useY = useY;
        }

        public boolean isNoise() {
            return this.name().startsWith("NOISE");
        }

        public Component toComponent() {
            return Component.m_237113_((String)this.name().replace("NOISE_", ""));
        }
    }
}

