/*
 * Decompiled with CFR 0.152.
 */
package net.reversteam.concatenationcore.procedures;

import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class RightclickedProcedure {
    private static final WeakHashMap<UUID, Long> cooldowns = new WeakHashMap();
    private static final int COOLDOWN_TICKS = 20;
    private static final int XP_PER_ORB = 18;
    private static final int MAX_ORBS = 192;

    public static void execute(Player player, Level world, ItemStack itemstack, InteractionHand hand) {
        int orbCount;
        if (player == null || itemstack == null || world == null || hand == null) {
            return;
        }
        UUID id = player.m_20148_();
        long time = world.m_46467_();
        if (!world.m_5776_()) {
            long last = cooldowns.getOrDefault(id, -99999L);
            if (time - last < 20L) {
                player.m_36335_().m_41524_(itemstack.m_41720_(), 20);
                return;
            }
            cooldowns.put(id, time);
        }
        player.m_36335_().m_41524_(itemstack.m_41720_(), 20);
        int totalXP = RightclickedProcedure.getTotalExperience(player);
        int possibleOrbsFromXP = totalXP / 18;
        if (possibleOrbsFromXP < 1) {
            if (!world.m_5776_()) {
                player.m_213846_((Component)Component.m_237113_((String)"You do not have enough experience."));
            }
            return;
        }
        int maxDurability = itemstack.m_41776_();
        int remainingDur = maxDurability - itemstack.m_41773_();
        if (remainingDur <= 0) {
            if (!world.m_5776_()) {
                player.m_213846_((Component)Component.m_237113_((String)"Shrike cannot handle anymore."));
            }
            return;
        }
        boolean sneaking = player.m_6144_();
        if (sneaking) {
            orbCount = 1;
        } else {
            orbCount = Math.min(possibleOrbsFromXP, remainingDur);
            orbCount = Math.min(orbCount, 192);
        }
        if (orbCount <= 0) {
            return;
        }
        int xpToRemove = orbCount * 18;
        float damage = Math.max(1.0f, (float)xpToRemove * 0.0075f);
        if (!world.m_5776_()) {
            player.m_6469_(world.m_269111_().m_269425_(), damage);
            player.m_6756_(-xpToRemove);
            Item orbItem = (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation("concatenationcore:experience_orb"));
            for (int i = 0; i < orbCount; ++i) {
                player.m_36176_(new ItemStack((ItemLike)orbItem), false);
            }
            itemstack.m_41622_(orbCount, (LivingEntity)player, p -> p.m_21190_(hand));
        }
    }

    private static int getTotalExperience(Player player) {
        int level = player.f_36078_;
        float progress = player.f_36080_;
        int total = 0;
        for (int i = 0; i < level; ++i) {
            total += RightclickedProcedure.xpNeededForLevel(i);
        }
        return total += Math.round((float)RightclickedProcedure.xpNeededForLevel(level) * progress);
    }

    private static int xpNeededForLevel(int level) {
        if (level >= 30) {
            return 112 + (level - 30) * 9;
        }
        if (level >= 15) {
            return 37 + (level - 15) * 5;
        }
        return 7 + level * 2;
    }
}

