/*
 * Decompiled with CFR 0.152.
 */
package net.reversteam.concatenationcore.procedures;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.DustColorTransitionOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class KestrelRRightclickedProcedure {
    private static final double NORMAL_DISTANCE = 10.0;
    private static final double SNEAK_DISTANCE = 5.0;
    private static final double XP_PER_BLOCK = 0.0;
    private static final int COOLDOWN_TICKS = 20;
    private static final int MAX_CHAIN_TARGETS = 3;
    private static final double CHAIN_RADIUS = 6.0;

    public static void execute(Player player, Level world, ItemStack itemstack, InteractionHand hand) {
        double teleportDistance;
        if (player == null || world == null || itemstack == null || hand == null) {
            return;
        }
        if (world.m_5776_()) {
            return;
        }
        double d = teleportDistance = player.m_6047_() ? 5.0 : 10.0;
        if (player.f_36078_ > 30 && !player.m_6047_()) {
            teleportDistance = 15.0;
        }
        Vec3 look = player.m_20154_().m_82541_();
        Vec3 startPos = player.m_20182_();
        Vec3 destPos = startPos.m_82549_(look.m_82490_(teleportDistance));
        int xpCost = (int)(teleportDistance * 0.0);
        if (player.f_36079_ < xpCost) {
            player.m_36335_().m_41524_(itemstack.m_41720_(), 20);
            return;
        }
        Vec3 safeDest = KestrelRRightclickedProcedure.findSafeTeleportPos(world, startPos, destPos);
        double actualDistance = safeDest.m_82554_(startPos);
        int actualXpCost = (int)(actualDistance * 0.0);
        player.m_6021_(safeDest.f_82479_, safeDest.f_82480_, safeDest.f_82481_);
        KestrelRRightclickedProcedure.playParticles(world, startPos);
        KestrelRRightclickedProcedure.playAfterimageTrail(world, startPos, safeDest);
        KestrelRRightclickedProcedure.playParticles(world, safeDest);
        world.m_6263_(null, startPos.f_82479_, startPos.f_82480_, startPos.f_82481_, SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
        world.m_6263_(null, safeDest.f_82479_, safeDest.f_82480_, safeDest.f_82481_, SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
        if (KestrelRRightclickedProcedure.playerTeleportedThroughMobs(world, player, startPos, safeDest)) {
            List nearbyMobs = world.m_45976_(LivingEntity.class, player.m_20191_().m_82400_(2.0)).stream().filter(e -> e != player).collect(Collectors.toList());
            for (LivingEntity mob : nearbyMobs) {
                KestrelRRightclickedProcedure.strikeLightning(world, mob, 6.0f);
            }
        }
        player.m_36335_().m_41524_(itemstack.m_41720_(), 20);
        itemstack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
        player.m_6756_(-actualXpCost);
    }

    private static Vec3 findSafeTeleportPos(Level world, Vec3 startPos, Vec3 destPos) {
        Vec3 direction = destPos.m_82546_(startPos).m_82541_();
        double maxDist = startPos.m_82554_(destPos);
        for (double dist = 0.0; dist <= maxDist; dist += 0.5) {
            Vec3 check = startPos.m_82549_(direction.m_82490_(dist));
            BlockPos pos = BlockPos.m_274446_((Position)check);
            if (world.m_8055_(pos).m_60795_() && world.m_8055_(pos.m_7494_()).m_60795_()) continue;
            return startPos.m_82549_(direction.m_82490_(dist - 0.5));
        }
        return destPos;
    }

    private static boolean playerTeleportedThroughMobs(Level world, Player player, Vec3 startPos, Vec3 endPos) {
        Vec3 direction = endPos.m_82546_(startPos).m_82541_();
        double distance = startPos.m_82554_(endPos);
        for (double d = 0.0; d <= distance; d += 0.5) {
            Vec3 checkPos = startPos.m_82549_(direction.m_82490_(d));
            AABB box = new AABB(BlockPos.m_274446_((Position)checkPos)).m_82400_(1.0);
            List mobs = world.m_45976_(LivingEntity.class, box).stream().filter(e -> e != player).collect(Collectors.toList());
            if (mobs.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private static void playParticles(Level world, Vec3 pos) {
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123760_, pos.f_82479_, pos.f_82480_ + 1.0, pos.f_82481_, 30, 0.5, 1.0, 0.5, 0.02);
            serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123796_, pos.f_82479_, pos.f_82480_ + 1.0, pos.f_82481_, 10, 0.3, 0.5, 0.3, 0.01);
        }
    }

    private static void playAfterimageTrail(Level world, Vec3 start, Vec3 end) {
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            int steps = 12;
            for (int i = 1; i < steps; ++i) {
                double factor = (double)i / (double)steps;
                Vec3 point = start.m_82549_(end.m_82546_(start).m_82490_(factor));
                serverWorld.m_8767_((ParticleOptions)new DustColorTransitionOptions(new Vector3f(0.4f, 0.1f, 0.9f), new Vector3f(1.0f, 1.0f, 1.0f), 1.0f), point.f_82479_, point.f_82480_ + 1.0, point.f_82481_, 6, 0.1, 0.1, 0.1, 0.01);
                serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123810_, point.f_82479_, point.f_82480_ + 1.0, point.f_82481_, 4, 0.05, 0.05, 0.05, 0.005);
            }
        }
    }

    private static void strikeLightning(Level world, LivingEntity target, float damage) {
        LightningBolt bolt = (LightningBolt)EntityType.f_20465_.m_20615_(world);
        if (bolt != null) {
            bolt.m_6027_(target.m_20185_(), target.m_20186_(), target.m_20189_());
            bolt.m_20874_(false);
            world.m_7967_((Entity)bolt);
            target.m_6469_(world.m_269111_().m_269548_(), damage);
            if (world instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)world;
                serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123797_, target.m_20185_(), target.m_20186_(), target.m_20189_(), 10, 0.3, 0.3, 0.3, 0.02);
            }
        }
    }
}

