/*
 * Decompiled with CFR 0.152.
 */
package net.reversteam.concatenationcore.procedures;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.reversteam.concatenationcore.init.ConcatenationcoreModBlocks;

public class HydraulicTreeFellerOnTickUpdateProcedure {
    private static final int COOLDOWN_TICKS = 200;

    public static void execute(LevelAccessor world, double x, double y, double z) {
        if (!(world instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)world;
        BlockPos pos = BlockPos.m_274561_((double)x, (double)y, (double)z);
        BlockEntity be = level.m_7702_(pos);
        if (be == null) {
            return;
        }
        if (!HydraulicTreeFellerOnTickUpdateProcedure.hasActiveBoiler((LevelAccessor)level, pos)) {
            return;
        }
        CompoundTag tag = be.getPersistentData();
        int cooldown = tag.m_128451_("treeCooldown");
        if (cooldown > 0) {
            tag.m_128405_("treeCooldown", cooldown - 1);
            be.m_6596_();
            return;
        }
        be.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
            Item patt2858$temp;
            BlockPos treeStart;
            if (!(handler instanceof IItemHandlerModifiable)) {
                return;
            }
            IItemHandlerModifiable inv = (IItemHandlerModifiable)handler;
            HydraulicTreeFellerOnTickUpdateProcedure.tryPushUp((LevelAccessor)level, pos, inv);
            if (HydraulicTreeFellerOnTickUpdateProcedure.isFull(inv, 1) || HydraulicTreeFellerOnTickUpdateProcedure.isFull(inv, 2) || HydraulicTreeFellerOnTickUpdateProcedure.isFull(inv, 3)) {
                return;
            }
            BlockState selfState = level.m_8055_(pos);
            Direction facing = (Direction)selfState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
            BlockPos front = pos.m_121945_(facing);
            BlockPos back = pos.m_121945_(facing.m_122424_());
            Object object = HydraulicTreeFellerOnTickUpdateProcedure.isLog((LevelAccessor)level, front) ? front : (treeStart = HydraulicTreeFellerOnTickUpdateProcedure.isLog((LevelAccessor)level, back) ? back : null);
            if (treeStart == null) {
                return;
            }
            HashSet<BlockPos> treeBlocks = new HashSet<BlockPos>();
            HydraulicTreeFellerOnTickUpdateProcedure.collectTree((LevelAccessor)level, treeStart, treeBlocks);
            int logCount = 0;
            for (BlockPos p : treeBlocks) {
                BlockState logState = level.m_8055_(p);
                if (logState.m_204336_(BlockTags.f_13106_)) {
                    ++logCount;
                }
                for (ItemStack drop : Block.m_49869_((BlockState)logState, (ServerLevel)level, (BlockPos)p, null)) {
                    HydraulicTreeFellerOnTickUpdateProcedure.insertIntoOutputs(inv, drop);
                }
                level.m_7471_(p, false);
            }
            if (logCount > 0) {
                HydraulicTreeFellerOnTickUpdateProcedure.insertIntoOutputs(inv, new ItemStack((ItemLike)Items.f_42398_, logCount * 2));
            }
            tag.m_128405_("treeCooldown", 200);
            ItemStack sapling = inv.getStackInSlot(0);
            ItemStack boneMeal = inv.getStackInSlot(4);
            if (!sapling.m_41619_() && (patt2858$temp = sapling.m_41720_()) instanceof BlockItem) {
                BlockItem bi = (BlockItem)patt2858$temp;
                if (boneMeal.m_41720_() == Items.f_42499_) {
                    BlockPos plantPos = front;
                    BlockPos soilPos = plantPos.m_7495_();
                    if (level.m_46859_(plantPos) && bi.m_40614_().m_49966_().m_60710_((LevelReader)level, plantPos) && level.m_8055_(soilPos).m_204336_(BlockTags.f_144274_)) {
                        level.m_7731_(plantPos, bi.m_40614_().m_49966_(), 3);
                        sapling.m_41774_(1);
                        boneMeal.m_41774_(1);
                        inv.setStackInSlot(0, sapling);
                        inv.setStackInSlot(4, boneMeal);
                    }
                }
            }
        });
        be.m_6596_();
    }

    private static boolean hasActiveBoiler(LevelAccessor world, BlockPos pos) {
        for (Direction d : Direction.values()) {
            if (world.m_8055_(pos.m_121945_(d)).m_60734_() != ConcatenationcoreModBlocks.BOILER_ACTIVE.get()) continue;
            return true;
        }
        return false;
    }

    private static boolean isLog(LevelAccessor world, BlockPos pos) {
        return world.m_8055_(pos).m_204336_(BlockTags.f_13106_);
    }

    private static void collectTree(LevelAccessor world, BlockPos start, Set<BlockPos> out) {
        if (out.contains(start)) {
            return;
        }
        if (!world.m_8055_(start).m_204336_(BlockTags.f_13106_)) {
            return;
        }
        out.add(start);
        for (Direction d : Direction.values()) {
            HydraulicTreeFellerOnTickUpdateProcedure.collectTree(world, start.m_121945_(d), out);
        }
    }

    private static boolean isFull(IItemHandlerModifiable inv, int slot) {
        ItemStack s = inv.getStackInSlot(slot);
        return !s.m_41619_() && s.m_41613_() >= 64;
    }

    private static void insertIntoOutputs(IItemHandlerModifiable inv, ItemStack stack) {
        if (stack.m_41619_()) {
            return;
        }
        for (int slot = 1; slot <= 3; ++slot) {
            if (!(stack = ItemHandlerHelper.insertItem((IItemHandler)inv, (ItemStack)stack, (boolean)false)).m_41619_()) continue;
            return;
        }
    }

    private static void tryPushUp(LevelAccessor world, BlockPos pos, IItemHandlerModifiable inv) {
        BlockEntity above = world.m_7702_(pos.m_7494_());
        if (above == null) {
            return;
        }
        above.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(target -> {
            for (int i = 1; i <= 3; ++i) {
                ItemStack stack = inv.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                ItemStack remainder = ItemHandlerHelper.insertItem((IItemHandler)target, (ItemStack)stack, (boolean)false);
                inv.setStackInSlot(i, remainder);
            }
        });
    }
}

