/*
 * Decompiled with CFR 0.152.
 */
package net.reversteam.concatenationcore.procedures;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.reversteam.concatenationcore.init.ConcatenationcoreModBlocks;
import net.reversteam.concatenationcore.init.ConcatenationcoreModItems;

public class HydraulicCrusherOnTickUpdateProcedure {
    private static final int PROCESS_TIME = 100;

    public static void execute(LevelAccessor world, double x, double y, double z) {
        BlockPos pos = BlockPos.m_274561_((double)x, (double)y, (double)z);
        BlockEntity be = world.m_7702_(pos);
        if (be == null) {
            return;
        }
        boolean hasActiveBoiler = false;
        for (BlockPos offset : new BlockPos[]{pos.m_122012_(), pos.m_122019_(), pos.m_122029_(), pos.m_122024_(), pos.m_7494_(), pos.m_7495_()}) {
            if (world.m_8055_(offset).m_60734_() != ConcatenationcoreModBlocks.BOILER_ACTIVE.get()) continue;
            hasActiveBoiler = true;
            break;
        }
        if (!hasActiveBoiler) {
            be.getPersistentData().m_128405_("crusherProgress", 0);
            be.m_6596_();
            return;
        }
        be.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(cap -> {
            if (!(cap instanceof IItemHandlerModifiable)) {
                return;
            }
            IItemHandlerModifiable inv = (IItemHandlerModifiable)cap;
            ItemStack input = inv.getStackInSlot(0);
            if (input.m_41619_()) {
                be.getPersistentData().m_128405_("crusherProgress", 0);
                be.m_6596_();
                return;
            }
            ItemStack primaryResult = ItemStack.f_41583_;
            boolean probabilistic = false;
            if (input.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("concatenation", "crusher_input/iron")))) {
                primaryResult = new ItemStack((ItemLike)ConcatenationcoreModItems.CRUSHED_IRON.get(), 2);
            } else if (input.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("concatenation", "crusher_input/zinc")))) {
                primaryResult = new ItemStack((ItemLike)ConcatenationcoreModItems.CRUSHED_ZINC.get(), 2);
            } else if (input.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("concatenation", "crusher_input/tin")))) {
                primaryResult = new ItemStack((ItemLike)ConcatenationcoreModItems.CRUSHED_TIN.get(), 2);
            } else if (input.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("concatenation", "crusher_input/copper")))) {
                primaryResult = new ItemStack((ItemLike)ConcatenationcoreModItems.CRUSHED_COPPER.get(), 2);
            } else if (input.m_150930_(Items.f_42692_)) {
                primaryResult = new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation("thermal", "quartz_dust")), 1);
            } else if (input.m_150930_((Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation("ae2", "certus_quartz_crystal")))) {
                primaryResult = new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation("ae2", "certus_quartz_dust")), 1);
            } else if (input.m_150930_((Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation("perdition", "compacted_marmor")))) {
                probabilistic = true;
            } else {
                be.getPersistentData().m_128405_("crusherProgress", 0);
                be.m_6596_();
                return;
            }
            int progress = be.getPersistentData().m_128451_("crusherProgress") + 1;
            be.getPersistentData().m_128405_("crusherProgress", progress);
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                level.m_8767_((ParticleOptions)ParticleTypes.f_123762_, x + 0.5, y + 1.0, z + 0.5, 2, 0.15, 0.15, 0.15, 0.01);
            }
            if (progress < 100) {
                be.m_6596_();
                return;
            }
            RandomSource random = RandomSource.m_216327_();
            if (!probabilistic) {
                HydraulicCrusherOnTickUpdateProcedure.insert(inv, 1, primaryResult);
            } else {
                if (random.m_188501_() < 0.01f) {
                    HydraulicCrusherOnTickUpdateProcedure.insert(inv, 1, new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation("thermal", "diamond_dust"))));
                }
                if (random.m_188501_() < 0.1f) {
                    HydraulicCrusherOnTickUpdateProcedure.insert(inv, 2, new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation("thermal", "apatite_dust"))));
                }
                if (random.m_188501_() < 0.01f) {
                    HydraulicCrusherOnTickUpdateProcedure.insert(inv, 3, new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation("thermal", "silver_dust"))));
                }
            }
            input.m_41774_(1);
            inv.setStackInSlot(0, input);
            be.getPersistentData().m_128405_("crusherProgress", 0);
            be.m_6596_();
        });
    }

    private static void insert(IItemHandlerModifiable inv, int slot, ItemStack stack) {
        ItemStack existing = inv.getStackInSlot(slot);
        if (existing.m_41619_()) {
            inv.setStackInSlot(slot, stack.m_41777_());
        } else if (ItemStack.m_41656_((ItemStack)existing, (ItemStack)stack) && existing.m_41613_() + stack.m_41613_() <= existing.m_41741_()) {
            existing.m_41769_(stack.m_41613_());
            inv.setStackInSlot(slot, existing);
        }
    }
}

