/*
 * Decompiled with CFR 0.152.
 */
package net.reversteam.concatenationcore.procedures;

import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.reversteam.concatenationcore.init.ConcatenationcoreModBlocks;
import net.reversteam.concatenationcore.init.ConcatenationcoreModFluids;

public class HeaterOnTickUpdateProcedure {
    public static void execute(LevelAccessor world, double x, double y, double z) {
        boolean canProduce;
        BlockPos heaterPos = BlockPos.m_274561_((double)x, (double)y, (double)z);
        BlockPos thermaePos = heaterPos.m_7494_();
        BlockEntity heaterBE = world.m_7702_(heaterPos);
        if (heaterBE == null) {
            return;
        }
        BlockEntity thermaeBE = world.m_7702_(thermaePos);
        int lava = heaterBE.getCapability(ForgeCapabilities.FLUID_HANDLER).map(h -> h.getFluidInTank(0).getAmount()).orElse(0);
        CompoundTag tag = heaterBE.getPersistentData();
        int progress = tag.m_128451_("progress");
        boolean active = lava >= 100;
        tag.m_128379_("active", active);
        if (!active || thermaeBE == null) {
            tag.m_128405_("progress", progress);
            HeaterOnTickUpdateProcedure.swapState(world, heaterPos, active);
            return;
        }
        ItemStack inputStack = thermaeBE.getCapability(ForgeCapabilities.ITEM_HANDLER).map(h -> h.getStackInSlot(0)).orElse(ItemStack.f_41583_);
        boolean validZinc = !inputStack.m_41619_() && inputStack.m_41613_() >= 18 && inputStack.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("concatenation", "thermae_input/zinc")));
        int thermaeFluid = thermaeBE.getCapability(ForgeCapabilities.FLUID_HANDLER).map(h -> h.getFluidInTank(0).getAmount()).orElse(0);
        boolean bl = canProduce = validZinc && lava >= 100 && thermaeFluid <= 1000;
        if (canProduce) {
            ++progress;
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                level.m_8767_((ParticleOptions)ParticleTypes.f_123744_, x + 0.5, y + 0.4, z + 0.5, 4, 0.2, 0.1, 0.2, 0.0);
            }
            if (progress >= 100) {
                heaterBE.getCapability(ForgeCapabilities.FLUID_HANDLER).ifPresent(h -> h.drain(100, IFluidHandler.FluidAction.EXECUTE));
                thermaeBE.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(h -> h.extractItem(0, 9, false));
                thermaeBE.getCapability(ForgeCapabilities.FLUID_HANDLER).ifPresent(h -> h.fill(new FluidStack((Fluid)ConcatenationcoreModFluids.LIQUID_GALVANIZED_IRON.get(), 1000), IFluidHandler.FluidAction.EXECUTE));
                progress = 0;
            }
        }
        tag.m_128405_("progress", progress);
        HeaterOnTickUpdateProcedure.swapState(world, heaterPos, active);
    }

    private static void swapState(LevelAccessor world, BlockPos pos, boolean active) {
        BlockEntity newBE;
        BlockState oldState = world.m_8055_(pos);
        BlockState newState = active ? ((Block)ConcatenationcoreModBlocks.HEATER_ACTIVE.get()).m_49966_() : ((Block)ConcatenationcoreModBlocks.HEATER.get()).m_49966_();
        for (Map.Entry entry : oldState.m_61148_().entrySet()) {
            Property property = newState.m_60734_().m_49965_().m_61081_(((Property)entry.getKey()).m_61708_());
            if (property == null) continue;
            try {
                newState = (BlockState)newState.m_61124_(property, (Comparable)entry.getValue());
            }
            catch (Exception exception) {}
        }
        BlockEntity oldBE = world.m_7702_(pos);
        CompoundTag tag = null;
        if (oldBE != null) {
            tag = oldBE.m_187480_();
            oldBE.m_7651_();
        }
        world.m_7731_(pos, newState, 3);
        if (tag != null && (newBE = world.m_7702_(pos)) != null) {
            newBE.m_142466_(tag);
        }
    }
}

