/*
 * Decompiled with CFR 0.152.
 */
package net.reversteam.concatenationcore.procedures;

import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.reversteam.concatenationcore.init.ConcatenationcoreModBlocks;

public class CoalGeneratorOnTickUpdateProcedure {
    private static final int RF_PRODUCED_PER_TICK = 30;
    private static final int MAX_RF_OUTPUT_PER_TICK = 60;
    private static final int BLOCK_SWAP_DELAY = 3;
    private static final int BURN_SPEED_MULTIPLIER = 12;

    public static void execute(LevelAccessor world, double x, double y, double z) {
        int burnTime;
        if (!(world instanceof Level)) {
            return;
        }
        Level level = (Level)world;
        BlockPos pos = BlockPos.m_274561_((double)x, (double)y, (double)z);
        BlockEntity be = level.m_7702_(pos);
        if (be == null) {
            return;
        }
        BlockState currentState = level.m_8055_(pos);
        int pendingSwap = be.getPersistentData().m_128451_("pendingActiveTick");
        if (pendingSwap > 0) {
            be.getPersistentData().m_128405_("pendingActiveTick", --pendingSwap);
            if (pendingSwap == 0) {
                boolean swapToActive = be.getPersistentData().m_128471_("swapToActive");
                BlockState target = swapToActive ? ((Block)ConcatenationcoreModBlocks.COAL_GENERATOR_ACTIVE.get()).m_49966_() : ((Block)ConcatenationcoreModBlocks.COAL_GENERATOR.get()).m_49966_();
                CoalGeneratorOnTickUpdateProcedure.swapBlock((LevelAccessor)level, pos, target);
                currentState = level.m_8055_(pos);
            }
        }
        if ((burnTime = be.getPersistentData().m_128451_("burnTime")) > 0) {
            if ((burnTime -= 12) < 0) {
                burnTime = 0;
            }
            be.getPersistentData().m_128405_("burnTime", burnTime);
            if (currentState.m_60734_() != ConcatenationcoreModBlocks.COAL_GENERATOR_ACTIVE.get() && pendingSwap <= 0) {
                be.getPersistentData().m_128405_("pendingActiveTick", 3);
                be.getPersistentData().m_128379_("swapToActive", true);
            }
            be.getCapability(ForgeCapabilities.ENERGY, null).ifPresent(storage -> storage.receiveEnergy(30, false));
        }
        be.getCapability(ForgeCapabilities.ENERGY, null).ifPresent(source -> {
            int remaining = 60;
            for (Direction dir : Direction.values()) {
                int accepted;
                int extractable;
                IEnergyStorage target;
                LazyOptional targetCap;
                if (remaining <= 0) break;
                BlockEntity targetBE = level.m_7702_(pos.m_121945_(dir));
                if (targetBE == null || !(targetCap = targetBE.getCapability(ForgeCapabilities.ENERGY, dir.m_122424_())).isPresent() || (target = (IEnergyStorage)targetCap.orElse(null)) == null || !target.canReceive() || (extractable = source.extractEnergy(remaining, true)) <= 0 || (accepted = target.receiveEnergy(extractable, false)) <= 0) continue;
                source.extractEnergy(accepted, false);
                remaining -= accepted;
            }
        });
        if (burnTime <= 0) {
            be.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(cap -> {
                if (!(cap instanceof IItemHandlerModifiable)) {
                    return;
                }
                IItemHandlerModifiable inv = (IItemHandlerModifiable)cap;
                ItemStack fuel = inv.getStackInSlot(0);
                if (fuel.m_41619_()) {
                    return;
                }
                int fuelBurnTime = ForgeHooks.getBurnTime((ItemStack)fuel, null);
                if (fuelBurnTime <= 0) {
                    return;
                }
                fuel.m_41774_(1);
                inv.setStackInSlot(0, fuel);
                be.getPersistentData().m_128405_("burnTime", fuelBurnTime);
                be.getPersistentData().m_128405_("pendingActiveTick", 3);
                be.getPersistentData().m_128379_("swapToActive", true);
            });
        }
        if (burnTime <= 0 && currentState.m_60734_() == ConcatenationcoreModBlocks.COAL_GENERATOR_ACTIVE.get() && pendingSwap <= 0) {
            be.getPersistentData().m_128405_("pendingActiveTick", 3);
            be.getPersistentData().m_128379_("swapToActive", false);
        }
        be.m_6596_();
    }

    private static void swapBlock(LevelAccessor world, BlockPos pos, BlockState newState) {
        BlockEntity newBE;
        CompoundTag tag;
        BlockState oldState = world.m_8055_(pos);
        for (Map.Entry entry : oldState.m_61148_().entrySet()) {
            Property prop = newState.m_60734_().m_49965_().m_61081_(((Property)entry.getKey()).m_61708_());
            if (prop == null) continue;
            try {
                newState = (BlockState)newState.m_61124_(prop, (Comparable)entry.getValue());
            }
            catch (Exception exception) {}
        }
        BlockEntity oldBE = world.m_7702_(pos);
        CompoundTag compoundTag = tag = oldBE != null ? oldBE.m_187480_() : null;
        if (oldBE != null) {
            oldBE.m_7651_();
        }
        world.m_7731_(pos, newState, 3);
        if (tag != null && (newBE = world.m_7702_(pos)) != null) {
            newBE.m_142466_(tag);
        }
    }
}

