/*
 * Decompiled with CFR 0.152.
 */
package net.reversteam.concatenationcore.procedures;

import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.reversteam.concatenationcore.init.ConcatenationcoreModBlocks;

public class BoilerOnTickUpdateProcedure {
    private static final int ACTIVE_TICKS = 1200;
    private static final int WATER_COST = 200;
    private static final int ITEM_COST = 1;

    public static void execute(LevelAccessor world, double x, double y, double z) {
        boolean canRun;
        BlockPos pos = BlockPos.m_274561_((double)x, (double)y, (double)z);
        BlockEntity be = world.m_7702_(pos);
        if (be == null) {
            return;
        }
        int waterAmount = be.getCapability(ForgeCapabilities.FLUID_HANDLER).map(h -> h.getFluidInTank(0).getAmount()).orElse(0);
        ItemStack item = be.getCapability(ForgeCapabilities.ITEM_HANDLER).map(h -> h.getStackInSlot(0)).orElse(ItemStack.f_41583_);
        CompoundTag tag = be.getPersistentData();
        int progress = tag.m_128451_("activeTicks");
        boolean active = tag.m_128471_("isActive");
        boolean bl = canRun = waterAmount >= 200 && !item.m_41619_() && item.m_41613_() >= 1;
        if (canRun) {
            ++progress;
            tag.m_128379_("isActive", true);
            if (!active) {
                be.getCapability(ForgeCapabilities.FLUID_HANDLER).ifPresent(h -> h.drain(200, IFluidHandler.FluidAction.EXECUTE));
                be.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(h -> {
                    if (h instanceof IItemHandlerModifiable) {
                        IItemHandlerModifiable inv = (IItemHandlerModifiable)h;
                        ItemStack stack = inv.getStackInSlot(0);
                        stack.m_41774_(1);
                        inv.setStackInSlot(0, stack);
                    }
                });
            }
            active = true;
            if (world instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)world;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, x + 0.5, y + 1.0, z + 0.5, 2, 0.2, 0.2, 0.2, 0.01);
            }
            if (progress >= 1200) {
                progress = 0;
                active = false;
                tag.m_128379_("isActive", false);
            }
        } else {
            active = false;
            progress = 0;
        }
        tag.m_128405_("activeTicks", progress);
        tag.m_128379_("isActive", active);
        be.m_6596_();
        BlockState targetState = active ? ((Block)ConcatenationcoreModBlocks.BOILER_ACTIVE.get()).m_49966_() : ((Block)ConcatenationcoreModBlocks.BOILER.get()).m_49966_();
        BlockState currentState = world.m_8055_(pos);
        if (currentState.m_60734_() != targetState.m_60734_()) {
            BoilerOnTickUpdateProcedure.swapBlock(world, pos, targetState);
        }
    }

    private static void swapBlock(LevelAccessor world, BlockPos pos, BlockState newState) {
        BlockEntity newBE;
        BlockState oldState = world.m_8055_(pos);
        for (Map.Entry entry : oldState.m_61148_().entrySet()) {
            Property property = newState.m_60734_().m_49965_().m_61081_(((Property)entry.getKey()).m_61708_());
            if (property == null) continue;
            newState = BoilerOnTickUpdateProcedure.copyProperty(newState, property, (Comparable)entry.getValue());
        }
        BlockEntity oldBE = world.m_7702_(pos);
        CompoundTag tag = null;
        if (oldBE != null) {
            tag = oldBE.m_187480_();
            oldBE.m_7651_();
        }
        world.m_7731_(pos, newState, 3);
        if (tag != null && (newBE = world.m_7702_(pos)) != null) {
            try {
                newBE.m_142466_(tag);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static <T extends Comparable<T>> BlockState copyProperty(BlockState state, Property<T> property, Comparable<?> value) {
        try {
            return (BlockState)state.m_61124_(property, value);
        }
        catch (Exception e) {
            return state;
        }
    }
}

