/*
 * Decompiled with CFR 0.152.
 */
package net.reversteam.concatenationcore.command;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.reversteam.concatenationcore.init.ConcatenationcoreModItems;

@Mod.EventBusSubscriber
public class ConcatCommand {
    private static final String NBT_KEY = "transmute_used";
    private static final int PLAYTIME_LIMIT = 144000;

    @SubscribeEvent
    public static void registerCommand(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)"concat").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"switch").then(Commands.m_82127_((String)"hierophant").executes(ctx -> ConcatCommand.execute((CommandSourceStack)ctx.getSource(), "the_hierophant")))).then(Commands.m_82127_((String)"hermit").executes(ctx -> ConcatCommand.execute((CommandSourceStack)ctx.getSource(), "the_hermit")))).then(Commands.m_82127_((String)"magician").executes(ctx -> ConcatCommand.execute((CommandSourceStack)ctx.getSource(), "the_magician")))).then(Commands.m_82127_((String)"temperance").executes(ctx -> ConcatCommand.execute((CommandSourceStack)ctx.getSource(), "temperance")))));
    }

    private static int execute(CommandSourceStack source, String choice) {
        String message;
        ItemStack result;
        boolean removed;
        Entity entity = source.m_81373_();
        if (!(entity instanceof ServerPlayer)) {
            source.m_81352_((Component)Component.m_237113_((String)"This command can only be run by a player."));
            return 0;
        }
        ServerPlayer player = (ServerPlayer)entity;
        int playtime = player.m_8951_().m_13015_(Stats.f_12988_.m_12902_((Object)Stats.f_144255_));
        if (playtime > 144000) {
            player.m_213846_((Component)Component.m_237113_((String)"\u00a74You have played for over 2 hours and cannot switch starting pathways anymore."));
            return 0;
        }
        CompoundTag data = player.getPersistentData();
        CompoundTag persistTag = data.m_128469_("PlayerPersisted");
        if (persistTag.m_128471_(NBT_KEY)) {
            player.m_213846_((Component)Component.m_237113_((String)"\u00a74You have already switched pathways!"));
            return 0;
        }
        boolean bl = removed = player.m_150109_().m_36022_(stack -> stack.m_150930_((Item)ConcatenationcoreModItems.PATHWAY_CHOOSER.get()) || stack.m_150930_((Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation("tarotcards", "the_hierophant"))) || stack.m_150930_((Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation("tarotcards", "the_hermit"))) || stack.m_150930_((Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation("tarotcards", "the_magician"))) || stack.m_150930_((Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation("tarotcards", "temperance"))), 1, (Container)player.f_36095_.m_39730_()) > 0;
        if (!removed) {
            player.m_213846_((Component)Component.m_237113_((String)"\u00a74You cannot switch pathways!"));
            return 0;
        }
        switch (choice) {
            case "the_hierophant": {
                result = new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation("tarotcards", "the_hierophant")));
                message = "\u00a7aYou have received the Hierophant card!";
                break;
            }
            case "the_hermit": {
                result = new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation("tarotcards", "the_hermit")));
                message = "\u00a7aYou have received the Hermit card!";
                break;
            }
            case "the_magician": {
                result = new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation("tarotcards", "the_magician")));
                message = "\u00a7aYou have received the Magician card!";
                break;
            }
            case "temperance": {
                result = new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation("tarotcards", "temperance")));
                message = "\u00a7aYou have received the Temperance card!";
                break;
            }
            default: {
                player.m_213846_((Component)Component.m_237113_((String)"\u00a7cInvalid choice."));
                return 0;
            }
        }
        player.m_36356_(result);
        persistTag.m_128379_(NBT_KEY, true);
        data.m_128365_("PlayerPersisted", (Tag)persistTag);
        player.m_213846_((Component)Component.m_237113_((String)message));
        return 1;
    }
}

