/*
 * Decompiled with CFR 0.152.
 */
package uppers.blocks;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.stats.Stats;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import uppers.Uppers;
import uppers.tiles.IUpper;
import uppers.tiles.UpperBlockEntity;

public class UpperBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final BooleanProperty ENABLED = BlockStateProperties.f_61431_;
    private static final VoxelShape INPUT_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0);
    private static final VoxelShape MIDDLE_SHAPE = Block.m_49796_((double)4.0, (double)6.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
    private static final VoxelShape INPUT_MIDDLE_SHAPE = Shapes.m_83110_((VoxelShape)MIDDLE_SHAPE, (VoxelShape)INPUT_SHAPE);
    private static final VoxelShape field_196326_A = Shapes.m_83113_((VoxelShape)INPUT_MIDDLE_SHAPE, (VoxelShape)IUpper.INSIDE_BOWL_SHAPE, (BooleanOp)BooleanOp.f_82685_);
    private static final VoxelShape DOWN_SHAPE = Shapes.m_83110_((VoxelShape)field_196326_A, (VoxelShape)Block.m_49796_((double)6.0, (double)12.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0));
    private static final VoxelShape EAST_SHAPE = Shapes.m_83110_((VoxelShape)field_196326_A, (VoxelShape)Block.m_49796_((double)12.0, (double)8.0, (double)6.0, (double)16.0, (double)12.0, (double)10.0));
    private static final VoxelShape NORTH_SHAPE = Shapes.m_83110_((VoxelShape)field_196326_A, (VoxelShape)Block.m_49796_((double)6.0, (double)8.0, (double)0.0, (double)10.0, (double)12.0, (double)4.0));
    private static final VoxelShape SOUTH_SHAPE = Shapes.m_83110_((VoxelShape)field_196326_A, (VoxelShape)Block.m_49796_((double)6.0, (double)8.0, (double)12.0, (double)10.0, (double)12.0, (double)16.0));
    private static final VoxelShape WEST_SHAPE = Shapes.m_83110_((VoxelShape)field_196326_A, (VoxelShape)Block.m_49796_((double)0.0, (double)8.0, (double)6.0, (double)4.0, (double)12.0, (double)10.0));
    private static final VoxelShape DOWN_RAYTRACE_SHAPE = IUpper.INSIDE_BOWL_SHAPE;
    private static final VoxelShape EAST_RAYTRACE_SHAPE = Shapes.m_83110_((VoxelShape)IUpper.INSIDE_BOWL_SHAPE, (VoxelShape)Block.m_49796_((double)12.0, (double)6.0, (double)6.0, (double)16.0, (double)8.0, (double)10.0));
    private static final VoxelShape NORTH_RAYTRACE_SHAPE = Shapes.m_83110_((VoxelShape)IUpper.INSIDE_BOWL_SHAPE, (VoxelShape)Block.m_49796_((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)8.0, (double)4.0));
    private static final VoxelShape SOUTH_RAYTRACE_SHAPE = Shapes.m_83110_((VoxelShape)IUpper.INSIDE_BOWL_SHAPE, (VoxelShape)Block.m_49796_((double)6.0, (double)6.0, (double)12.0, (double)10.0, (double)8.0, (double)16.0));
    private static final VoxelShape WEST_RAYTRACE_SHAPE = Shapes.m_83110_((VoxelShape)IUpper.INSIDE_BOWL_SHAPE, (VoxelShape)Block.m_49796_((double)0.0, (double)6.0, (double)6.0, (double)4.0, (double)8.0, (double)10.0));

    public UpperBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.UP)).m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(true)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.m_61143_((Property)FACING)) {
            case UP: {
                return DOWN_SHAPE;
            }
            case DOWN: {
                return DOWN_SHAPE;
            }
            case NORTH: {
                return NORTH_SHAPE;
            }
            case SOUTH: {
                return SOUTH_SHAPE;
            }
            case WEST: {
                return WEST_SHAPE;
            }
            case EAST: {
                return EAST_SHAPE;
            }
        }
        return field_196326_A;
    }

    public VoxelShape m_6079_(BlockState state, BlockGetter level, BlockPos pos) {
        switch ((Direction)state.m_61143_((Property)FACING)) {
            case UP: {
                return DOWN_RAYTRACE_SHAPE;
            }
            case DOWN: {
                return DOWN_RAYTRACE_SHAPE;
            }
            case NORTH: {
                return NORTH_RAYTRACE_SHAPE;
            }
            case SOUTH: {
                return SOUTH_RAYTRACE_SHAPE;
            }
            case WEST: {
                return WEST_RAYTRACE_SHAPE;
            }
            case EAST: {
                return EAST_RAYTRACE_SHAPE;
            }
        }
        return IUpper.INSIDE_BOWL_SHAPE;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_43719_().m_122424_();
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)(direction.m_122434_() == Direction.Axis.Y ? Direction.UP : direction))).m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(true));
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new UpperBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return level.f_46443_ ? null : UpperBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)Uppers.UPPER_TILE.get()), UpperBlockEntity::pushItemsTick);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntity tileentity;
        if (stack.m_41788_() && (tileentity = level.m_7702_(pos)) instanceof UpperBlockEntity) {
            ((UpperBlockEntity)tileentity).m_58638_(stack.m_41786_());
        }
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!oldState.m_60713_(state.m_60734_())) {
            this.checkPoweredState(level, pos, state);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity tileentity = level.m_7702_(pos);
        if (tileentity instanceof UpperBlockEntity) {
            player.m_5893_((MenuProvider)((UpperBlockEntity)tileentity));
            player.m_36220_(Stats.f_12957_);
        }
        return InteractionResult.CONSUME;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        this.checkPoweredState(level, pos, state);
    }

    private void checkPoweredState(Level level, BlockPos pos, BlockState state) {
        boolean flag;
        boolean bl = flag = !level.m_276867_(pos);
        if (flag != (Boolean)state.m_61143_((Property)ENABLED)) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(flag)), 4);
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity tileentity = level.m_7702_(pos);
            if (tileentity instanceof UpperBlockEntity) {
                Containers.m_19002_((Level)level, (BlockPos)pos, (Container)((UpperBlockEntity)tileentity));
                level.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level level, BlockPos pos) {
        return AbstractContainerMenu.m_38918_((BlockEntity)level.m_7702_(pos));
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, ENABLED});
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        BlockEntity tileentity = level.m_7702_(pos);
        if (tileentity instanceof UpperBlockEntity) {
            UpperBlockEntity.entityInside(level, pos, state, entity, (UpperBlockEntity)tileentity);
        }
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }
}

