/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.storage.rendering.types;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import org.jetbrains.annotations.NotNull;

public class BoxPreviewData {
    @NotNull
    private final BlockPos pos1;
    @NotNull
    private final BlockPos pos2;
    @NotNull
    private Optional<BlockPos> anchor;
    private long expireTime = Long.MAX_VALUE;

    public BoxPreviewData(@NotNull BlockPos pos1, @NotNull BlockPos pos2, @NotNull Optional<BlockPos> anchor) {
        this.pos1 = pos1;
        this.pos2 = pos2;
        this.anchor = anchor;
    }

    public BlockPos getPos1() {
        return this.pos1;
    }

    public BlockPos getPos2() {
        return this.pos2;
    }

    public Optional<BlockPos> getAnchor() {
        return this.anchor;
    }

    public void setAnchor(Optional<BlockPos> anchor) {
        this.anchor = anchor;
    }

    public boolean isExpired() {
        return System.currentTimeMillis() - this.expireTime > 0L;
    }

    public void setExpireTime(int seconds) {
        this.expireTime = System.currentTimeMillis() + (long)(seconds * 1000);
    }
}

