/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.placement;

import com.ldtteam.structurize.placement.IBlueprintIterator;
import com.ldtteam.structurize.placement.structure.IStructureHandler;
import com.ldtteam.structurize.util.BlockUtils;
import com.ldtteam.structurize.util.BlueprintPositionInfo;
import java.util.Collections;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraftforge.common.util.TriPredicate;

public abstract class AbstractBlueprintIterator
implements IBlueprintIterator {
    public static final BlockPos NULL_POS = new BlockPos(-1, -1, -1);
    protected final BlockPos.MutableBlockPos progressPos = new BlockPos.MutableBlockPos(-1, -1, -1);
    protected final BlockPos.MutableBlockPos prevProgressPos = new BlockPos.MutableBlockPos(-1, -1, -1);
    protected final BlockPos size;
    private final IStructureHandler structureHandler;
    private boolean includeEntities;
    private boolean isRemoving;

    public AbstractBlueprintIterator(IStructureHandler structureHandler) {
        this(structureHandler, new BlockPos((int)structureHandler.getBluePrint().getSizeX(), (int)structureHandler.getBluePrint().getSizeY(), (int)structureHandler.getBluePrint().getSizeZ()));
    }

    public AbstractBlueprintIterator(IStructureHandler structureHandler, BlockPos size) {
        this.structureHandler = structureHandler;
        this.size = size;
    }

    @Override
    public Result increment(TriPredicate<BlueprintPositionInfo, BlockPos, IStructureHandler> skipCondition) {
        return this.iterateWithCondition(skipCondition, this::increment);
    }

    @Override
    public Result decrement(TriPredicate<BlueprintPositionInfo, BlockPos, IStructureHandler> skipCondition) {
        return this.iterateWithCondition(skipCondition, this::decrement);
    }

    private Result iterateWithCondition(TriPredicate<BlueprintPositionInfo, BlockPos, IStructureHandler> skipCondition, Supplier<Result> function) {
        int count = 0;
        do {
            if (function.get() == Result.AT_END) {
                return Result.AT_END;
            }
            BlockPos progressPos = this.getProgressPos();
            IStructureHandler structureHandler = this.getStructureHandler();
            BlockPos worldPos = structureHandler.getProgressPosInWorld(progressPos);
            BlueprintPositionInfo info = this.getBluePrintPositionInfo(progressPos);
            if (skipCondition.test((Object)info, (Object)worldPos, (Object)structureHandler)) continue;
            if (!this.isRemoving()) {
                if (BlockUtils.areBlockStatesEqual(info.getBlockInfo().getState(), structureHandler.getWorld().m_8055_(worldPos), structureHandler::replaceWithSolidBlock, structureHandler.fancyPlacement(), structureHandler::shouldBlocksBeConsideredEqual, info.getBlockInfo().getTileEntityData(), info.getBlockInfo().getTileEntityData() == null ? null : structureHandler.getWorld().m_7702_(worldPos)) && info.getEntities().length == 0) {
                    structureHandler.triggerSuccess(progressPos, Collections.emptyList(), false);
                    continue;
                }
            }
            return Result.NEW_BLOCK;
        } while (count++ < this.structureHandler.getMaxBlocksCheckedPerCall());
        return Result.CONFIG_LIMIT;
    }

    @Override
    public void setProgressPos(BlockPos localPosition) {
        this.prevProgressPos.m_122190_((Vec3i)this.progressPos);
        if (localPosition.equals((Object)NULL_POS)) {
            this.progressPos.m_122190_((Vec3i)localPosition);
        } else {
            this.progressPos.m_122178_(localPosition.m_123341_() % this.size.m_123341_(), localPosition.m_123342_() % this.size.m_123342_(), localPosition.m_123343_() % this.size.m_123343_());
        }
    }

    @Override
    public BlueprintPositionInfo getBluePrintPositionInfo(BlockPos localPos) {
        return this.structureHandler.getBluePrint().getBluePrintPositionInfo(localPos, this.includeEntities);
    }

    @Override
    public void includeEntities() {
        this.includeEntities = true;
    }

    @Override
    public boolean hasEntities() {
        return this.includeEntities;
    }

    @Override
    public void setRemoving() {
        this.isRemoving = true;
    }

    @Override
    public boolean isRemoving() {
        return this.isRemoving;
    }

    @Override
    public void reset() {
        this.prevProgressPos.m_122190_((Vec3i)NULL_POS);
        this.progressPos.m_122190_((Vec3i)NULL_POS);
        this.includeEntities = false;
        this.isRemoving = false;
    }

    @Override
    public BlockPos getSize() {
        return this.size;
    }

    @Override
    public BlockPos getProgressPos() {
        return this.progressPos.m_7949_();
    }

    @Override
    public BlockPos getPrevProgressPos() {
        return this.prevProgressPos.m_7949_();
    }

    protected IStructureHandler getStructureHandler() {
        return this.structureHandler;
    }

    public static enum Result {
        NEW_BLOCK,
        AT_END,
        CONFIG_LIMIT;

    }
}

