/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.operations;

import com.ldtteam.structurize.Network;
import com.ldtteam.structurize.Structurize;
import com.ldtteam.structurize.network.messages.UpdateClientRender;
import com.ldtteam.structurize.operations.BaseOperation;
import com.ldtteam.structurize.util.ChangeStorage;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;

public abstract class AreaOperation
extends BaseOperation {
    protected final Player player;
    protected BlockPos.MutableBlockPos startPos = new BlockPos.MutableBlockPos();
    protected BlockPos.MutableBlockPos endPos = new BlockPos.MutableBlockPos();
    private List<BlockPos> workPosList = new ArrayList<BlockPos>();
    private int currentListIndex = 0;

    protected AreaOperation(Component storageText, Player player, BlockPos startPos, BlockPos endPos) {
        super(new ChangeStorage(storageText, player != null ? player.m_20148_() : UUID.randomUUID()));
        this.player = player;
        this.startPos = new BlockPos.MutableBlockPos(Math.min(startPos.m_123341_(), endPos.m_123341_()), Math.min(startPos.m_123342_(), endPos.m_123342_()), Math.min(startPos.m_123343_(), endPos.m_123343_()));
        this.endPos = new BlockPos.MutableBlockPos(Math.max(startPos.m_123341_(), endPos.m_123341_()), Math.max(startPos.m_123342_(), endPos.m_123342_()), Math.max(startPos.m_123343_(), endPos.m_123343_()));
        for (int x = startPos.m_123341_(); x <= endPos.m_123341_(); ++x) {
            for (int z = startPos.m_123343_(); z <= endPos.m_123343_(); ++z) {
                for (int y = startPos.m_123342_(); y <= endPos.m_123342_(); ++y) {
                    this.workPosList.add(new BlockPos(x, y, z));
                }
            }
        }
    }

    protected AreaOperation(Component storageText, Player player, List<BlockPos> workPosList) {
        super(new ChangeStorage(storageText, player != null ? player.m_20148_() : UUID.randomUUID()));
        this.player = player;
        this.workPosList = workPosList;
    }

    @Override
    public final boolean apply(ServerLevel world) {
        if (this.player != null && this.player.m_9236_().m_46472_() != world.m_46472_()) {
            return false;
        }
        int count = 0;
        int i = this.currentListIndex;
        while (i < this.workPosList.size()) {
            BlockPos currentPos = this.workPosList.get(i);
            this.currentListIndex = i++;
            this.apply(world, currentPos);
            this.startPos.m_122178_(Math.min(this.startPos.m_123341_(), currentPos.m_123341_()), Math.min(this.startPos.m_123342_(), currentPos.m_123342_()), Math.min(this.startPos.m_123343_(), currentPos.m_123343_()));
            this.endPos.m_122178_(Math.max(this.endPos.m_123341_(), currentPos.m_123341_()), Math.max(this.endPos.m_123342_(), currentPos.m_123342_()), Math.max(this.endPos.m_123343_(), currentPos.m_123343_()));
            if (++count < (Integer)Structurize.getConfig().getServer().maxOperationsPerTick.get()) continue;
            return false;
        }
        Network.getNetwork().sendToEveryone(new UpdateClientRender((BlockPos)this.startPos, (BlockPos)this.endPos));
        return true;
    }

    protected abstract void apply(ServerLevel var1, BlockPos var2);
}

