/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.blueprints.v1;

import com.ldtteam.structurize.blueprints.v1.DataVersion;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixerUpper;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import net.minecraft.SharedConstants;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.util.datafix.fixes.References;

public class DataFixerUtils {
    public static boolean isVanillaDF = DataFixers.m_14512_() instanceof DataFixerUpper;

    private DataFixerUtils() {
    }

    public static CompoundTag runDataFixer(CompoundTag dataIn, DSL.TypeReference dataType, DataVersion startVersion) {
        return DataFixerUtils.runDataFixer(dataIn, dataType, startVersion.getDataVersion(), SharedConstants.m_183709_().m_183476_().m_193006_());
    }

    public static CompoundTag runDataFixer(CompoundTag dataIn, DSL.TypeReference dataType, int startVersion) {
        return DataFixerUtils.runDataFixer(dataIn, dataType, startVersion, SharedConstants.m_183709_().m_183476_().m_193006_());
    }

    public static CompoundTag runDataFixer(CompoundTag dataIn, DSL.TypeReference dataType, DataVersion startVersion, DataVersion endVersion) {
        return DataFixerUtils.runDataFixer(dataIn, dataType, startVersion.getDataVersion(), endVersion.getDataVersion());
    }

    public static CompoundTag runDataFixer(CompoundTag dataIn, DSL.TypeReference dataType, int startVersion, int endVersion) {
        return DataFixerUtils.runDataFixer(dataIn, dataType, startVersion, endVersion, startVersion <= DataVersion.pre1466.getDataVersion() && DataVersion.post1466.getDataVersion() <= endVersion && dataType == References.f_16781_);
    }

    public static CompoundTag runDataFixer(CompoundTag dataIn, DSL.TypeReference dataType, int startVersion, int endVersion, boolean debugNonBlockstate) {
        return startVersion == endVersion ? dataIn : (debugNonBlockstate && dataType != References.f_16783_ ? DataFixerUtils.runDataFixerCascade(dataIn, dataType, startVersion, endVersion) : (CompoundTag)DataFixers.m_14512_().update(dataType, new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)dataIn), startVersion, endVersion).getValue());
    }

    public static CompoundTag runDataFixerCascade(CompoundTag dataIn, DSL.TypeReference dataType, int startVersion, int endVersion) {
        CompoundTag fixedNbt = dataIn;
        DataVersion currentVersion = DataVersion.findFromDataVersion(startVersion);
        while (currentVersion.getDataVersion() < endVersion) {
            fixedNbt = (CompoundTag)DataFixers.m_14512_().update(dataType, new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)fixedNbt), currentVersion.getDataVersion(), currentVersion.getSuccessor().getDataVersion()).getValue();
            if ((currentVersion = currentVersion.getSuccessor()) != DataVersion.pre1466 || dataType != References.f_16781_) continue;
            currentVersion = DataVersion.post1466;
        }
        return fixedNbt;
    }
}

