/*
 * Decompiled with CFR 0.152.
 */
package com.tagnumelite.projecteintegration.addons;

import com.smashingmods.alchemistry.common.recipe.atomizer.AtomizerRecipe;
import com.smashingmods.alchemistry.common.recipe.combiner.CombinerRecipe;
import com.smashingmods.alchemistry.common.recipe.compactor.CompactorRecipe;
import com.smashingmods.alchemistry.common.recipe.fission.FissionRecipe;
import com.smashingmods.alchemistry.common.recipe.fusion.FusionRecipe;
import com.smashingmods.alchemistry.common.recipe.liquifier.LiquifierRecipe;
import com.smashingmods.alchemistry.registry.RecipeRegistry;
import com.smashingmods.alchemylib.api.item.IngredientStack;
import com.tagnumelite.projecteintegration.PEIntegration;
import com.tagnumelite.projecteintegration.api.recipe.ARecipeTypeMapper;
import com.tagnumelite.projecteintegration.api.recipe.nss.NSSInput;
import com.tagnumelite.projecteintegration.api.recipe.nss.NSSOutput;
import java.util.ArrayList;
import java.util.List;
import moze_intel.projecte.api.mapper.recipe.RecipeTypeMapper;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import moze_intel.projecte.emc.IngredientMap;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class AlchemistryAddon {
    public static final String MODID = "alchemistry";

    @Contract(pure=true)
    @NotNull
    public static String NAME(String name) {
        return "Alchemistry" + name + "Mapper";
    }

    @RecipeTypeMapper(requiredMods={"alchemistry"}, priority=1)
    public static class AlchemistryLiquifierMapper
    extends ARecipeTypeMapper<LiquifierRecipe> {
        @Override
        public String getName() {
            return AlchemistryAddon.NAME("Liquifier");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == RecipeRegistry.LIQUIFIER_TYPE.get();
        }

        @Override
        public NSSOutput getOutput(LiquifierRecipe recipe) {
            return new NSSOutput(recipe.getOutput());
        }
    }

    @RecipeTypeMapper(requiredMods={"alchemistry"}, priority=1)
    public static class AlchemistryFusionMapper
    extends ARecipeTypeMapper<FusionRecipe> {
        @Override
        public String getName() {
            return AlchemistryAddon.NAME("Fusion");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == RecipeRegistry.FUSION_TYPE.get();
        }
    }

    @RecipeTypeMapper(requiredMods={"alchemistry"}, priority=1)
    public static class AlchemistryFissionMapper
    extends ARecipeTypeMapper<FissionRecipe> {
        @Override
        public String getName() {
            return AlchemistryAddon.NAME("Fission");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == RecipeRegistry.FISSION_TYPE.get();
        }

        @Override
        public NSSOutput getOutput(FissionRecipe recipe) {
            return this.mapOutputs(recipe.getOutput1(), recipe.getOutput2());
        }
    }

    @RecipeTypeMapper(requiredMods={"alchemistry"}, priority=1)
    public static class AlchemistryCompactorMapper
    extends ARecipeTypeMapper<CompactorRecipe> {
        @Override
        public String getName() {
            return AlchemistryAddon.NAME("Compactor");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == RecipeRegistry.COMPACTOR_TYPE.get();
        }

        @Override
        public NSSInput getInput(CompactorRecipe recipe) {
            ArrayList<Tuple<NormalizedSimpleStack, List<IngredientMap<NormalizedSimpleStack>>>> fakeGroupMap = new ArrayList<Tuple<NormalizedSimpleStack, List<IngredientMap<NormalizedSimpleStack>>>>();
            IngredientMap ingredientMap = new IngredientMap();
            IngredientStack ingredient = recipe.getInput();
            if (!this.convertIngredient(ingredient.getCount(), ingredient.getIngredient(), (IngredientMap<NormalizedSimpleStack>)ingredientMap, fakeGroupMap)) {
                return new NSSInput((IngredientMap<NormalizedSimpleStack>)ingredientMap, fakeGroupMap, false);
            }
            return new NSSInput((IngredientMap<NormalizedSimpleStack>)ingredientMap, fakeGroupMap, true);
        }
    }

    @RecipeTypeMapper(requiredMods={"alchemistry"}, priority=1)
    public static class AlchemistryCombinerMapper
    extends ARecipeTypeMapper<CombinerRecipe> {
        @Override
        public String getName() {
            return AlchemistryAddon.NAME("Combiner");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == RecipeRegistry.COMBINER_TYPE.get();
        }

        @Override
        public NSSInput getInput(CombinerRecipe recipe) {
            List ingredients = recipe.getInput();
            if (ingredients.isEmpty()) {
                PEIntegration.debugLog("Recipe ({}) contains no inputs: {}", this.recipeID, ingredients);
                return null;
            }
            ArrayList<Tuple<NormalizedSimpleStack, List<IngredientMap<NormalizedSimpleStack>>>> fakeGroupMap = new ArrayList<Tuple<NormalizedSimpleStack, List<IngredientMap<NormalizedSimpleStack>>>>();
            IngredientMap ingredientMap = new IngredientMap();
            for (IngredientStack ingredient : ingredients) {
                if (this.convertIngredient(ingredient.getCount(), ingredient.getIngredient(), (IngredientMap<NormalizedSimpleStack>)ingredientMap, fakeGroupMap)) continue;
                return new NSSInput((IngredientMap<NormalizedSimpleStack>)ingredientMap, fakeGroupMap, false);
            }
            return new NSSInput((IngredientMap<NormalizedSimpleStack>)ingredientMap, fakeGroupMap, true);
        }
    }

    @RecipeTypeMapper(requiredMods={"alchemistry"}, priority=1)
    public static class AlchemistryAtomizerMapper
    extends ARecipeTypeMapper<AtomizerRecipe> {
        @Override
        public String getName() {
            return AlchemistryAddon.NAME("Atomizer");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == RecipeRegistry.ATOMIZER_TYPE.get();
        }

        @Override
        public NSSInput getInput(AtomizerRecipe recipe) {
            return NSSInput.createFluid(recipe.getInput());
        }
    }
}

