/*
 * Decompiled with CFR 0.152.
 */
package me.decce.ixeris.forge.transformers.glfw_state_caching;

import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import me.decce.ixeris.core.Ixeris;
import me.decce.ixeris.core.glfw.state_caching.GlfwCacheManager;
import me.decce.ixeris.core.glfw.state_caching.global.GlfwKeyNameCache;
import me.decce.ixeris.core.glfw.state_caching.global.GlfwMonitorCache;
import me.decce.ixeris.core.glfw.state_caching.global.GlfwStandardCursorCache;
import me.decce.ixeris.core.glfw.state_caching.util.BufferHelper;
import me.decce.ixeris.core.glfw.state_caching.window.GlfwCursorPosCache;
import me.decce.ixeris.core.glfw.state_caching.window.GlfwFramebufferSizeCache;
import me.decce.ixeris.core.glfw.state_caching.window.GlfwInputModeCache;
import me.decce.ixeris.core.glfw.state_caching.window.GlfwKeyCache;
import me.decce.ixeris.core.glfw.state_caching.window.GlfwMouseButtonCache;
import me.decce.ixeris.core.glfw.state_caching.window.GlfwWindowAttribCache;
import me.decce.ixeris.core.glfw.state_caching.window.GlfwWindowContentScaleCache;
import me.decce.ixeris.core.glfw.state_caching.window.GlfwWindowSizeCache;
import me.decce.ixeris.core.shadow.classtransform.InjectionCallback;
import me.decce.ixeris.core.shadow.classtransform.annotations.CInline;
import me.decce.ixeris.core.shadow.classtransform.annotations.CTarget;
import me.decce.ixeris.core.shadow.classtransform.annotations.CTransformer;
import me.decce.ixeris.core.shadow.classtransform.annotations.injection.CInject;
import me.decce.ixeris.core.threading.MainThreadDispatcher;
import me.decce.ixeris.core.util.LambdaHelper;
import org.lwjgl.glfw.GLFW;

@CTransformer(value={GLFW.class})
public class GLFWTransformer {
    @CInline
    @CInject(method={"glfwSetInputMode"}, target={@CTarget(value="TAIL")})
    private static void ixeris$glfwSetInputMode(long window, int mode, int value, InjectionCallback ci) {
        if (GlfwCacheManager.hasWindowCache(window)) {
            GlfwCacheManager.getWindowCache(window).inputMode().set(mode, value);
        }
    }

    @CInline
    @CInject(method={"glfwGetInputMode"}, target={@CTarget(value="HEAD")}, cancellable=true)
    private static void ixeris$glfwGetInputMode(long window, int mode, InjectionCallback cir) {
        GlfwInputModeCache cache;
        if (Ixeris.isOnMainThread()) {
            return;
        }
        if (GlfwCacheManager.hasWindowCache(window) && (cache = GlfwCacheManager.getWindowCache(window).inputMode()).isCacheEnabled()) {
            cir.setReturnValue(cache.get(mode));
            return;
        }
        cir.setReturnValue(MainThreadDispatcher.query(LambdaHelper.makeSupplier(GLFW::glfwGetInputMode, window, mode)));
    }

    @CInline
    @CInject(method={"glfwGetKey"}, target={@CTarget(value="HEAD")}, cancellable=true)
    private static void ixeris$glfwGetKey(long window, int key, InjectionCallback cir) {
        GlfwKeyCache cache;
        if (Ixeris.isOnMainThread()) {
            return;
        }
        if (GlfwCacheManager.hasWindowCache(window) && (cache = GlfwCacheManager.getWindowCache(window).keys()).isCacheEnabled()) {
            int ret = cache.get(key);
            if (ret == 2) {
                ret = 1;
            }
            cir.setReturnValue(ret);
            return;
        }
        cir.setReturnValue(MainThreadDispatcher.query(LambdaHelper.makeSupplier(GLFW::glfwGetKey, window, key)));
    }

    @CInline
    @CInject(method={"glfwGetKeyName"}, target={@CTarget(value="HEAD")}, cancellable=true)
    private static void ixeris$glfwGetKeyName(int key, int scancode, InjectionCallback cir) {
        GlfwKeyNameCache cache = GlfwCacheManager.getGlobalCache().keyNames();
        if (cache.isCacheEnabled()) {
            cir.setReturnValue(cache.get(key, scancode));
        } else if (!Ixeris.isOnMainThread()) {
            cir.setReturnValue(MainThreadDispatcher.query(LambdaHelper.makeSupplier(GLFW::glfwGetKeyName, key, scancode)));
        }
    }

    @CInline
    @CInject(method={"glfwGetMouseButton"}, target={@CTarget(value="HEAD")}, cancellable=true)
    private static void ixeris$glfwGetMouseButton(long window, int button, InjectionCallback cir) {
        GlfwMouseButtonCache cache;
        if (Ixeris.isOnMainThread()) {
            return;
        }
        if (GlfwCacheManager.hasWindowCache(window) && (cache = GlfwCacheManager.getWindowCache(window).mouseButtons()).isCacheEnabled()) {
            cir.setReturnValue(cache.get(button));
            return;
        }
        cir.setReturnValue(MainThreadDispatcher.query(LambdaHelper.makeSupplier(GLFW::glfwGetMouseButton, window, button)));
    }

    @CInline
    @CInject(method={"glfwGetPrimaryMonitor"}, target={@CTarget(value="HEAD")}, cancellable=true)
    private static void ixeris$glfwGetPrimaryMonitor(InjectionCallback cir) {
        if (Ixeris.getConfig().useFlexibleThreading()) {
            return;
        }
        GlfwMonitorCache cache = GlfwCacheManager.getGlobalCache().monitors();
        if (cache.isCacheEnabled()) {
            cir.setReturnValue(cache.getPrimaryMonitor());
        } else if (!Ixeris.isOnMainThread()) {
            cir.setReturnValue(MainThreadDispatcher.query(GLFW::glfwGetPrimaryMonitor));
        }
    }

    @CInline
    @CInject(method={"glfwGetWindowMonitor"}, target={@CTarget(value="HEAD")}, cancellable=true)
    private static void ixeris$glfwGetWindowMonitor(long window, InjectionCallback cir) {
        me.decce.ixeris.core.glfw.state_caching.window.GlfwMonitorCache cache;
        if (Ixeris.isOnMainThread()) {
            return;
        }
        if (GlfwCacheManager.hasWindowCache(window) && (cache = GlfwCacheManager.getWindowCache(window).monitor()).isCacheEnabled()) {
            cir.setReturnValue(cache.get());
            return;
        }
        cir.setReturnValue(MainThreadDispatcher.query(LambdaHelper.makeSupplier(GLFW::glfwGetWindowMonitor, window)));
    }

    @CInline
    @CInject(method={"glfwSetWindowMonitor"}, target={@CTarget(value="TAIL")})
    private static void ixeris$glfwSetWindowMonitor(long window, long monitor, int xpos, int ypos, int width, int height, int refreshRate, InjectionCallback ci) {
        if (GlfwCacheManager.hasWindowCache(window)) {
            GlfwCacheManager.getWindowCache(window).monitor().set(monitor);
        }
    }

    @CInline
    @CInject(method={"glfwCreateStandardCursor"}, target={@CTarget(value="HEAD")}, cancellable=true)
    private static void ixeris$glfwCreateStandardCursor(int shape, InjectionCallback cir) {
        if (Ixeris.getConfig().useFlexibleThreading()) {
            return;
        }
        GlfwStandardCursorCache cache = GlfwCacheManager.getGlobalCache().standardCursors();
        if (cache.isCacheEnabled()) {
            cir.setReturnValue(cache.create(shape));
        } else if (!Ixeris.isOnMainThread()) {
            cir.setReturnValue(MainThreadDispatcher.query(LambdaHelper.makeSupplier(GLFW::glfwCreateStandardCursor, shape)));
        }
    }

    @CInline
    @CInject(method={"glfwDestroyCursor"}, target={@CTarget(value="HEAD")}, cancellable=true)
    private static void ixeris$glfwDestroyCursor(long cursor, InjectionCallback ci) {
        if (Ixeris.getConfig().useFlexibleThreading()) {
            return;
        }
        GlfwStandardCursorCache cache = GlfwCacheManager.getGlobalCache().standardCursors();
        if (cache.isCacheEnabled() && cache.isCached(cursor)) {
            ci.setCancelled(true);
            cache.destroy(cursor);
        } else if (!Ixeris.isOnMainThread()) {
            ci.setCancelled(true);
            MainThreadDispatcher.run(LambdaHelper.makeRunnable(GLFW::glfwDestroyCursor, cursor));
        }
    }

    @CInline
    @CInject(method={"glfwGetWindowSize(J[I[I)V"}, target={@CTarget(value="HEAD")}, cancellable=true)
    private static void ixeris$glfwGetWindowSize(long window, int[] width, int[] height, InjectionCallback ci) {
        GlfwWindowSizeCache cache;
        if (Ixeris.isOnMainThread()) {
            return;
        }
        if (GlfwCacheManager.hasWindowCache(window) && (cache = GlfwCacheManager.getWindowCache(window).windowSize()).isCacheEnabled() && BufferHelper.check(width) && BufferHelper.check(height)) {
            ci.setCancelled(true);
            cache.get(width, height);
            return;
        }
        ci.setCancelled(true);
        MainThreadDispatcher.runNow(LambdaHelper.makeRunnable(GLFW::glfwGetWindowSize, window, width, height));
    }

    @CInline
    @CInject(method={"glfwGetWindowSize(JLjava/nio/IntBuffer;Ljava/nio/IntBuffer;)V"}, target={@CTarget(value="HEAD")}, cancellable=true)
    private static void ixeris$glfwGetWindowSize(long window, IntBuffer width, IntBuffer height, InjectionCallback ci) {
        GlfwWindowSizeCache cache;
        if (Ixeris.isOnMainThread()) {
            return;
        }
        if (GlfwCacheManager.hasWindowCache(window) && (cache = GlfwCacheManager.getWindowCache(window).windowSize()).isCacheEnabled() && BufferHelper.check(width) && BufferHelper.check(height)) {
            ci.setCancelled(true);
            cache.get(width, height);
            return;
        }
        ci.setCancelled(true);
        MainThreadDispatcher.runNow(LambdaHelper.makeRunnable(GLFW::glfwGetWindowSize, window, width, height));
    }

    @CInline
    @CInject(method={"glfwGetFramebufferSize(J[I[I)V"}, target={@CTarget(value="HEAD")}, cancellable=true)
    private static void ixeris$glfwGetFramebufferSize(long window, int[] width, int[] height, InjectionCallback ci) {
        GlfwFramebufferSizeCache cache;
        if (Ixeris.isOnMainThread()) {
            return;
        }
        if (GlfwCacheManager.hasWindowCache(window) && (cache = GlfwCacheManager.getWindowCache(window).framebufferSize()).isCacheEnabled() && BufferHelper.check(width) && BufferHelper.check(height)) {
            ci.setCancelled(true);
            cache.get(width, height);
            return;
        }
        ci.setCancelled(true);
        MainThreadDispatcher.runNow(LambdaHelper.makeRunnable(GLFW::glfwGetFramebufferSize, window, width, height));
    }

    @CInline
    @CInject(method={"glfwGetFramebufferSize(JLjava/nio/IntBuffer;Ljava/nio/IntBuffer;)V"}, target={@CTarget(value="HEAD")}, cancellable=true)
    private static void ixeris$glfwGetFramebufferSize(long window, IntBuffer width, IntBuffer height, InjectionCallback ci) {
        if (Ixeris.isOnMainThread()) {
            return;
        }
        if (GlfwCacheManager.hasWindowCache(window)) {
            GlfwFramebufferSizeCache cache = GlfwCacheManager.getWindowCache(window).framebufferSize();
            if (cache.isCacheEnabled() && BufferHelper.check(width) && BufferHelper.check(height)) {
                ci.setCancelled(true);
                cache.get(width, height);
            }
            return;
        }
        ci.setCancelled(true);
        MainThreadDispatcher.runNow(LambdaHelper.makeRunnable(GLFW::glfwGetFramebufferSize, window, width, height));
    }

    @CInline
    @CInject(method={"glfwGetWindowContentScale(J[F[F)V"}, target={@CTarget(value="HEAD")}, cancellable=true)
    private static void ixeris$glfwGetWindowContentScale(long window, float[] xscale, float[] yscale, InjectionCallback ci) {
        GlfwWindowContentScaleCache cache;
        if (Ixeris.isOnMainThread()) {
            return;
        }
        if (GlfwCacheManager.hasWindowCache(window) && (cache = GlfwCacheManager.getWindowCache(window).contentScale()).isCacheEnabled() && BufferHelper.check(xscale) && BufferHelper.check(yscale)) {
            ci.setCancelled(true);
            cache.get(xscale, yscale);
            return;
        }
        ci.setCancelled(true);
        MainThreadDispatcher.runNow(LambdaHelper.makeRunnable(GLFW::glfwGetWindowContentScale, window, xscale, yscale));
    }

    @CInline
    @CInject(method={"glfwGetWindowContentScale(JLjava/nio/FloatBuffer;Ljava/nio/FloatBuffer;)V"}, target={@CTarget(value="HEAD")}, cancellable=true)
    private static void ixeris$glfwGetWindowContentScale(long window, FloatBuffer xscale, FloatBuffer yscale, InjectionCallback ci) {
        GlfwWindowContentScaleCache cache;
        if (Ixeris.isOnMainThread()) {
            return;
        }
        if (GlfwCacheManager.hasWindowCache(window) && (cache = GlfwCacheManager.getWindowCache(window).contentScale()).isCacheEnabled() && BufferHelper.check(xscale) && BufferHelper.check(yscale)) {
            ci.setCancelled(true);
            cache.get(xscale, yscale);
            return;
        }
        ci.setCancelled(true);
        MainThreadDispatcher.runNow(LambdaHelper.makeRunnable(GLFW::glfwGetWindowContentScale, window, xscale, yscale));
    }

    @CInline
    @CInject(method={"glfwGetWindowAttrib"}, target={@CTarget(value="HEAD")}, cancellable=true)
    private static void ixeris$glfwGetWindowAttrib(long window, int attrib, InjectionCallback cir) {
        GlfwWindowAttribCache cache;
        if (Ixeris.isOnMainThread()) {
            return;
        }
        if (GlfwCacheManager.hasWindowCache(window) && (cache = GlfwCacheManager.getWindowCache(window).attrib()).isCacheEnabled()) {
            cir.setReturnValue(cache.get(attrib));
            return;
        }
        cir.setReturnValue(MainThreadDispatcher.query(LambdaHelper.makeSupplier(GLFW::glfwGetWindowAttrib, window, attrib)));
    }

    @CInline
    @CInject(method={"glfwGetCursorPos(J[D[D)V"}, target={@CTarget(value="HEAD")}, cancellable=true)
    private static void ixeris$glfwGetCursorPos(long window, double[] xpos, double[] ypos, InjectionCallback ci) {
        GlfwCursorPosCache cache;
        if (Ixeris.isOnMainThread() || Ixeris.getConfig().useFlexibleThreading()) {
            return;
        }
        if (GlfwCacheManager.hasWindowCache(window) && (cache = GlfwCacheManager.getWindowCache(window).cursorPos()).isCacheEnabled() && BufferHelper.check(xpos) && BufferHelper.check(ypos)) {
            ci.setCancelled(true);
            cache.get(xpos, ypos);
            return;
        }
        ci.setCancelled(true);
        MainThreadDispatcher.runNow(LambdaHelper.makeRunnable(GLFW::glfwGetCursorPos, window, xpos, ypos));
    }

    @CInline
    @CInject(method={"glfwGetCursorPos(JLjava/nio/DoubleBuffer;Ljava/nio/DoubleBuffer;)V"}, target={@CTarget(value="HEAD")}, cancellable=true)
    private static void ixeris$glfwGetCursorPos(long window, DoubleBuffer xpos, DoubleBuffer ypos, InjectionCallback ci) {
        GlfwCursorPosCache cache;
        if (Ixeris.isOnMainThread() || Ixeris.getConfig().useFlexibleThreading()) {
            return;
        }
        if (GlfwCacheManager.hasWindowCache(window) && (cache = GlfwCacheManager.getWindowCache(window).cursorPos()).isCacheEnabled() && BufferHelper.check(xpos) && BufferHelper.check(ypos)) {
            ci.setCancelled(true);
            cache.get(xpos, ypos);
            return;
        }
        ci.setCancelled(true);
        MainThreadDispatcher.runNow(LambdaHelper.makeRunnable(GLFW::glfwGetCursorPos, window, xpos, ypos));
    }
}

