/*
 * Decompiled with CFR 0.152.
 */
package me.decce.ixeris.core.shadow.classtransform.transformer.coprocessor.impl;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import me.decce.ixeris.core.shadow.classtransform.TransformerManager;
import me.decce.ixeris.core.shadow.classtransform.annotations.CLocalVariable;
import me.decce.ixeris.core.shadow.classtransform.transformer.IAnnotationCoprocessor;
import me.decce.ixeris.core.shadow.classtransform.utils.ASMUtils;
import me.decce.ixeris.core.shadow.classtransform.utils.CoprocessorUtils;
import me.decce.ixeris.core.shadow.classtransform.utils.Types;
import me.decce.ixeris.core.shadow.classtransform.utils.annotations.AnnotationParser;
import me.decce.ixeris.core.shadow.classtransform.utils.annotations.AnnotationUtils;
import me.decce.ixeris.core.shadow.classtransform.utils.annotations.IParsedAnnotation;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class CLocalVariableCoprocessor
implements IAnnotationCoprocessor {
    private CoprocessorUtils.AnnotatedParameter[] parameters;
    private boolean isAnyModifiable;

    @Override
    public MethodNode preprocess(TransformerManager transformerManager, ClassNode transformedClass, MethodNode transformedMethod, ClassNode transformer, MethodNode transformerMethod) {
        this.parameters = CoprocessorUtils.getAnnotatedParameters(transformerMethod, CLocalVariable.class);
        if (this.parameters == null) {
            return transformerMethod;
        }
        transformedMethod.signature = null;
        CoprocessorUtils.mergeParametersToArray(transformerMethod, this.parameters);
        return transformerMethod;
    }

    @Override
    public MethodNode transform(TransformerManager transformerManager, ClassNode transformedClass, MethodNode transformedMethod, ClassNode transformer, MethodNode transformerMethod) {
        if (this.parameters == null) {
            return transformerMethod;
        }
        ASMUtils.cutParameters(transformerMethod, 1);
        return transformerMethod;
    }

    @Override
    public void postprocess(TransformerManager transformerManager, ClassNode transformedClass, MethodNode transformedMethod, List<MethodInsnNode> transformerMethodCalls, ClassNode transformer, MethodNode transformerMethod) {
        AbstractInsnNode cast;
        LocalVariable localVariable;
        int i;
        if (this.parameters == null) {
            return;
        }
        ASMUtils.addParameters(transformerMethod, Types.type(Object[].class));
        LocalVariable[] localVariables = this.getLocalVariables(transformerManager, transformedMethod);
        int targetArrayIndex = ASMUtils.getFreeVarIndex(transformedMethod);
        InsnList before = new InsnList();
        InsnList after = new InsnList();
        before.add(ASMUtils.intPush(localVariables.length));
        before.add((AbstractInsnNode)new TypeInsnNode(189, Types.internalName(Object.class)));
        if (this.isAnyModifiable) {
            before.add((AbstractInsnNode)new InsnNode(89));
            before.add((AbstractInsnNode)new VarInsnNode(58, targetArrayIndex));
        }
        for (i = 0; i < localVariables.length; ++i) {
            localVariable = localVariables[i];
            before.add((AbstractInsnNode)new InsnNode(89));
            before.add(ASMUtils.intPush(i));
            before.add((AbstractInsnNode)new VarInsnNode(localVariable.type.getOpcode(21), localVariable.variableIndex));
            cast = ASMUtils.getPrimitiveToObject(localVariable.parameter.getType());
            if (cast != null) {
                before.add(cast);
            }
            before.add((AbstractInsnNode)new InsnNode(83));
        }
        if (this.isAnyModifiable) {
            for (i = 0; i < localVariables.length; ++i) {
                localVariable = localVariables[i];
                if (!localVariable.annotation.modifiable()) continue;
                after.add((AbstractInsnNode)new VarInsnNode(25, targetArrayIndex));
                after.add(ASMUtils.intPush(i));
                after.add((AbstractInsnNode)new InsnNode(50));
                cast = ASMUtils.getCast(localVariable.parameter.getType());
                after.add((InsnList)cast);
                after.add((AbstractInsnNode)new VarInsnNode(localVariable.type.getOpcode(54), localVariable.variableIndex));
            }
        }
        for (MethodInsnNode transformerCall : transformerMethodCalls) {
            transformerCall.desc = transformerMethod.desc;
            transformedMethod.instructions.insertBefore((AbstractInsnNode)transformerCall, ASMUtils.cloneInsnList(before));
            transformedMethod.instructions.insert((AbstractInsnNode)transformerCall, ASMUtils.cloneInsnList(after));
        }
    }

    private LocalVariable[] getLocalVariables(TransformerManager transformerManager, MethodNode methodNode) {
        ArrayList<LocalVariable> localVariables = new ArrayList<LocalVariable>();
        for (CoprocessorUtils.AnnotatedParameter parameter : this.parameters) {
            if (parameter == null) continue;
            CLocalVariable annotation = AnnotationParser.parse(CLocalVariable.class, transformerManager, AnnotationUtils.listToMap(parameter.getAnnotation().values));
            IParsedAnnotation parsedAnnotation = (IParsedAnnotation)((Object)annotation);
            this.isAnyModifiable |= annotation.modifiable();
            boolean nameSet = parsedAnnotation.wasSet("name");
            boolean ordinalSet = parsedAnnotation.wasSet("ordinal");
            boolean indexSet = parsedAnnotation.wasSet("index");
            Integer variableIndex = null;
            if (nameSet || !ordinalSet && !indexSet && parameter.getName() != null) {
                String name;
                String string = name = nameSet ? annotation.name() : parameter.getName();
                if (methodNode.localVariables == null) {
                    if (!indexSet) {
                        throw new IllegalStateException("Local variables are not available to get the index by name");
                    }
                } else {
                    for (LocalVariableNode localVariable : methodNode.localVariables) {
                        if (!localVariable.name.equals(name)) continue;
                        variableIndex = localVariable.index;
                        break;
                    }
                }
            }
            if (ordinalSet && variableIndex == null) {
                if (methodNode.localVariables == null) {
                    if (!indexSet) {
                        throw new IllegalStateException("Local variables are not available to get the index by ordinal");
                    }
                } else {
                    int ordinal = annotation.ordinal();
                    int i = 0;
                    for (LocalVariableNode localVariable : methodNode.localVariables) {
                        if (!localVariable.desc.equals(parameter.getType().getDescriptor())) continue;
                        if (i == ordinal) {
                            variableIndex = localVariable.index;
                            break;
                        }
                        ++i;
                    }
                }
            }
            if (indexSet && variableIndex == null) {
                variableIndex = annotation.index();
            }
            if (variableIndex == null) {
                throw new IllegalArgumentException("No index, ordinal or name was set for annotated parameter " + parameter.getAnnotationIndex());
            }
            Type variableType = null;
            if (parsedAnnotation.wasSet("loadOpcode")) {
                variableType = this.getType(annotation.loadOpcode());
            } else {
                for (AbstractInsnNode instruction : methodNode.instructions) {
                    if (instruction instanceof VarInsnNode && ((VarInsnNode)instruction).var == variableIndex) {
                        Type opcodeType = this.getType(instruction.getOpcode());
                        if (variableType == null) {
                            variableType = opcodeType;
                            continue;
                        }
                        if (opcodeType.equals((Object)variableType)) continue;
                        throw new IllegalStateException("Local variable " + variableIndex + " has multiple types. Please specify the correct opcode.");
                    }
                    if (!(instruction instanceof IincInsnNode) || ((IincInsnNode)instruction).var != variableIndex) continue;
                    if (variableType == null) {
                        variableType = Type.INT_TYPE;
                        continue;
                    }
                    if (Type.INT_TYPE.equals((Object)variableType)) continue;
                    throw new IllegalStateException("Local variable " + variableIndex + " has multiple types. Please specify the correct opcode.");
                }
                if (variableType == null) {
                    throw new IllegalStateException("Local variable " + variableIndex + " could not be resolved");
                }
            }
            localVariables.add(new LocalVariable(variableIndex, variableType, parameter, annotation));
        }
        localVariables.sort(Comparator.comparingInt(o -> ((LocalVariable)o).parameter.getAnnotationIndex()));
        return localVariables.toArray(new LocalVariable[0]);
    }

    private Type getType(int opcode) {
        switch (opcode) {
            case 21: 
            case 54: {
                return Type.INT_TYPE;
            }
            case 22: 
            case 55: {
                return Type.LONG_TYPE;
            }
            case 23: 
            case 56: {
                return Type.FLOAT_TYPE;
            }
            case 24: 
            case 57: {
                return Type.DOUBLE_TYPE;
            }
            case 25: 
            case 58: {
                return Types.type(Object.class);
            }
        }
        throw new IllegalStateException("Unknown opcode " + opcode);
    }

    private static class LocalVariable {
        private final int variableIndex;
        private final Type type;
        private final CoprocessorUtils.AnnotatedParameter parameter;
        private final CLocalVariable annotation;

        private LocalVariable(int variableIndex, Type type, CoprocessorUtils.AnnotatedParameter parameter, CLocalVariable annotation) {
            this.variableIndex = variableIndex;
            this.type = type;
            this.parameter = parameter;
            this.annotation = annotation;
        }
    }
}

