/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.utils;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class ManualOrder<T>
implements Comparator<T> {
    private final Comparator<T> parent;
    private final Map<T, Integer> manualOrdering;

    public ManualOrder(Comparator<T> parent, Map<T, Integer> manualOrdering) {
        this.parent = parent;
        this.manualOrdering = Map.copyOf(manualOrdering);
    }

    @Override
    public int compare(T o1, T o2) {
        Integer index1 = this.manualOrdering.get(o1);
        Integer index2 = this.manualOrdering.get(o2);
        if (index1 == null) {
            if (index2 == null) {
                return this.parent.compare(o1, o2);
            }
            return 1;
        }
        if (index2 == null) {
            return -1;
        }
        return index1.compareTo(index2);
    }

    public static <T> Builder<T> builder(Comparator<T> parent) {
        return new Builder<T>(parent);
    }

    public static class Builder<T> {
        private final Comparator<T> parent;
        private final Map<T, Integer> ordering = new HashMap<T, Integer>();

        private Builder(Comparator<T> parent) {
            this.parent = parent;
        }

        public ManualOrder<T> build() {
            return new ManualOrder<T>(this.parent, this.ordering);
        }

        public Builder<T> add(T t, int order) {
            this.ordering.put(t, order);
            return this;
        }

        public Builder<T> add(T t) {
            return this.add(t, this.ordering.values().stream().max(Comparator.naturalOrder()).orElse(0) + 1);
        }
    }
}

