/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.module;

import com.yogpc.qp.Holder;
import com.yogpc.qp.machines.module.FilterModuleItem;
import java.util.stream.IntStream;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public final class FilterModuleExpandRecipe
extends ShapedRecipe {
    static final int MAX_ROWS = 6;
    static final int ROW_INCREMENT = 2;
    public static final ResourceLocation LOCATION = ResourceLocation.fromNamespaceAndPath((String)"quarryplus", (String)"filter_module_expand_recipe");
    public static final RecipeSerializer<FilterModuleExpandRecipe> SERIALIZER = new SimpleCraftingRecipeSerializer(FilterModuleExpandRecipe::new);
    private final Item moduleItem;

    public FilterModuleExpandRecipe(ResourceLocation pId, CraftingBookCategory pCategory) {
        super(pId, "", pCategory, 3, 3, FilterModuleExpandRecipe.createIngredients(Holder.ITEM_FILTER_MODULE), new ItemStack((ItemLike)Holder.ITEM_FILTER_MODULE));
        this.moduleItem = Holder.ITEM_FILTER_MODULE;
    }

    FilterModuleExpandRecipe(ResourceLocation pId, CraftingBookCategory pCategory, Item moduleItem) {
        super(pId, "", pCategory, 3, 3, FilterModuleExpandRecipe.createIngredients(moduleItem), new ItemStack((ItemLike)Holder.ITEM_FILTER_MODULE));
        this.moduleItem = moduleItem;
    }

    static NonNullList<Ingredient> createIngredients(Item moduleItem) {
        Ingredient chest = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42009_});
        Ingredient module = Ingredient.m_43929_((ItemLike[])new ItemLike[]{moduleItem});
        return NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{chest, chest, chest, chest, module, chest, chest, chest, chest});
    }

    public boolean m_5818_(CraftingContainer pInv, Level pLevel) {
        if (!super.m_5818_(pInv, pLevel)) {
            return false;
        }
        ItemStack module = this.findModule(pInv);
        if (module.m_41619_()) {
            return false;
        }
        int rows = FilterModuleItem.getRowsFromStack(module);
        return rows + 2 <= 6;
    }

    public ItemStack m_5874_(CraftingContainer pContainer, RegistryAccess pRegistryAccess) {
        ItemStack module = this.findModule(pContainer).m_41777_();
        int rows = FilterModuleItem.getRowsFromStack(module);
        module.m_41784_().m_128405_("filter_items_rows", rows + 2);
        return module;
    }

    public boolean m_5598_() {
        return true;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    ItemStack findModule(CraftingContainer container) {
        return IntStream.range(0, container.m_6643_()).mapToObj(arg_0 -> ((CraftingContainer)container).m_8020_(arg_0)).filter(i -> i.m_150930_(this.moduleItem)).findAny().orElse(ItemStack.f_41583_);
    }
}

