/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.mini_quarry;

import com.mojang.blaze3d.platform.InputConstants;
import com.yogpc.qp.machines.mini_quarry.BlockStatePredicate;
import com.yogpc.qp.machines.mini_quarry.MiniListSyncMessage;
import com.yogpc.qp.machines.mini_quarry.MiniQuarryAddEntryGui;
import com.yogpc.qp.machines.mini_quarry.MiniQuarryTile;
import com.yogpc.qp.machines.misc.IndexedButton;
import com.yogpc.qp.packet.PacketHandler;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public class MiniQuarryListGui
extends Screen
implements Button.OnPress {
    final List<BlockStatePredicate> whiteList;
    final List<BlockStatePredicate> blackList;
    private final BlockPos pos;
    private final ResourceKey<Level> dim;
    EntryList list;
    boolean whiteListFlag = true;

    MiniQuarryListGui(MiniQuarryTile tile, Collection<BlockStatePredicate> whiteList, Collection<BlockStatePredicate> blackList) {
        super(tile.m_5446_());
        this.whiteList = whiteList.stream().sorted(Comparator.comparing(Object::toString)).collect(Collectors.toList());
        this.blackList = blackList.stream().sorted(Comparator.comparing(Object::toString)).collect(Collectors.toList());
        this.pos = tile.m_58899_();
        this.dim = PacketHandler.getDimension(tile);
    }

    protected void m_7856_() {
        super.m_7856_();
        int buttonWidth = 80;
        int width = this.f_96543_;
        int height = this.f_96544_;
        this.list = new EntryList(this.getMinecraft(), width, height, 30, height - 70, 18, this, this::getEntries);
        this.m_142416_((GuiEventListener)this.list);
        this.m_142416_((GuiEventListener)new IndexedButton(0, width / 3 - buttonWidth / 2, height - 35, buttonWidth, 20, (Component)Component.m_237115_((String)"quarryplus.gui.blacklist"), this));
        this.m_142416_((GuiEventListener)new IndexedButton(1, width / 3 * 2 - buttonWidth / 2, height - 35, buttonWidth, 20, (Component)Component.m_237115_((String)"gui.done"), this));
        this.m_142416_((GuiEventListener)new IndexedButton(2, width / 2 - buttonWidth, height - 60, buttonWidth, 20, (Component)Component.m_237115_((String)"quarryplus.gui.new_entry"), this));
        this.m_142416_((GuiEventListener)new IndexedButton(3, width / 2, height - 60, buttonWidth, 20, (Component)Component.m_237115_((String)"selectWorld.delete"), this));
        this.m_264313_((GuiEventListener)this.list);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.list.m_88315_(graphics, mouseX, mouseY, partialTicks);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        MutableComponent listName = Component.m_237115_((String)(this.whiteListFlag ? "quarryplus.gui.whitelist" : "quarryplus.gui.blacklist"));
        MutableComponent title = Component.m_237110_((String)"quarryplus.gui.of", (Object[])new Object[]{listName, super.m_96636_().getString()});
        graphics.m_280653_(this.f_96547_, (Component)title, this.f_96543_ / 2, 8, 0xFFFFFF);
    }

    List<BlockStatePredicate> getEntries() {
        if (this.whiteListFlag) {
            return this.whiteList;
        }
        return this.blackList;
    }

    public void setWhiteListFlag(boolean whiteListFlag) {
        this.whiteListFlag = whiteListFlag;
        this.list.updateList();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        InputConstants.Key mouseKey = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        if (this.getMinecraft().f_91066_.f_92092_.isActiveAndMatches(mouseKey)) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_93750_(Button button) {
        if (button instanceof IndexedButton) {
            IndexedButton indexedButton = (IndexedButton)button;
            switch (indexedButton.id()) {
                case 0: {
                    this.setWhiteListFlag(!this.whiteListFlag);
                    button.m_93666_((Component)Component.m_237115_((String)(this.whiteListFlag ? "quarryplus.gui.whitelist" : "quarryplus.gui.blacklist")));
                    break;
                }
                case 1: {
                    this.m_7379_();
                    break;
                }
                case 2: {
                    this.getMinecraft().pushGuiLayer((Screen)new MiniQuarryAddEntryGui(this, e -> {
                        if (MiniQuarryTile.canAddInList(this.whiteListFlag, e)) {
                            this.getEntries().add((BlockStatePredicate)e);
                            this.list.updateList();
                            PacketHandler.sendToServer(new MiniListSyncMessage(this.pos, this.dim, this.blackList, this.whiteList));
                        }
                    }));
                    break;
                }
                case 3: {
                    BlockStatePredicate data;
                    MiniQuarryListEntry selected = (MiniQuarryListEntry)this.list.m_93511_();
                    if (selected == null || !MiniQuarryTile.canAddInList(this.whiteListFlag, data = selected.getData())) break;
                    this.getEntries().remove(data);
                    this.list.updateList();
                    PacketHandler.sendToServer(new MiniListSyncMessage(this.pos, this.dim, this.blackList, this.whiteList));
                }
            }
        }
    }

    private static class EntryList
    extends ObjectSelectionList<MiniQuarryListEntry> {
        private final Screen parent;
        private final Supplier<List<BlockStatePredicate>> entriesSupplier;

        public EntryList(Minecraft mcIn, int widthIn, int heightIn, int topIn, int bottomIn, int slotHeightIn, Screen parent, Supplier<List<BlockStatePredicate>> entriesSupplier) {
            super(mcIn, widthIn, heightIn, topIn, bottomIn, slotHeightIn);
            this.parent = parent;
            this.entriesSupplier = entriesSupplier;
            this.updateList();
        }

        public void updateList() {
            this.m_93516_();
            this.entriesSupplier.get().stream().map(e -> new MiniQuarryListEntry((BlockStatePredicate)e, this.parent, arg_0 -> ((EntryList)this).m_6987_(arg_0))).forEach(x$0 -> this.m_7085_((AbstractSelectionList.Entry)x$0));
        }
    }

    private static class MiniQuarryListEntry
    extends ObjectSelectionList.Entry<MiniQuarryListEntry> {
        private final BlockStatePredicate data;
        private final Screen parent;
        private final Consumer<MiniQuarryListEntry> setSelected;

        MiniQuarryListEntry(BlockStatePredicate data, Screen parent, Consumer<MiniQuarryListEntry> setSelected) {
            this.data = data;
            this.parent = parent;
            this.setSelected = setSelected;
        }

        public BlockStatePredicate getData() {
            return this.data;
        }

        public void m_6311_(GuiGraphics graphics, int entryIdx, int top, int left, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean p_render_8_, float partialTicks) {
            String name = this.data.toString();
            graphics.m_280056_(Minecraft.m_91087_().f_91062_, name, (this.parent.f_96543_ - Minecraft.m_91087_().f_91062_.m_92895_(name)) / 2, top + 2, 0xFFFFFF, false);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            this.setSelected.accept(this);
            return false;
        }

        public Component m_142172_() {
            return Component.m_237110_((String)"narrator.select", (Object[])new Object[]{this.data});
        }
    }
}

