/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.marker;

import com.yogpc.qp.machines.marker.ContainerMarker;
import com.yogpc.qp.machines.marker.FlexMarkerMessage;
import com.yogpc.qp.machines.marker.TileFlexMarker;
import com.yogpc.qp.machines.misc.IndexedButton;
import com.yogpc.qp.packet.PacketHandler;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ScreenFlexMarker
extends AbstractContainerScreen<ContainerMarker> {
    private static final ResourceLocation LOCATION = new ResourceLocation("quarryplus", "textures/gui/flex_marker.png");
    private final TileFlexMarker marker;
    private static final int yOffsetCenter = 35;
    private static final int yOffsetLR = 55;
    private static final int yOffsetBottom = 78;
    private static final int buttonWidth = 20;
    private static final int buttonHeight = 14;

    public ScreenFlexMarker(ContainerMarker containerMarker, Inventory inventory, Component component) {
        super((AbstractContainerMenu)containerMarker, inventory, component);
        this.f_97726_ = 217;
        this.f_97727_ = 220;
        this.f_97731_ = this.f_97727_ - 96 + 2;
        this.marker = (TileFlexMarker)containerMarker.player.m_9236_().m_7702_(containerMarker.pos);
    }

    public void m_7856_() {
        int j;
        super.m_7856_();
        Component[] mp = (Component[])Stream.of("--", "-", "+", "++").map(Component::m_237113_).toArray(Component[]::new);
        int w = 20;
        int h = 14;
        int top = 16;
        AtomicInteger buttonIndex = new AtomicInteger(0);
        for (j = 0; j < mp.length; ++j) {
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)mp[j], this::actionPerformed).m_252794_(this.getGuiLeft() + this.f_97726_ / 2 + (j - mp.length / 2) * w, this.getGuiTop() + top).m_253046_(w, h).build(IndexedButton.builder(buttonIndex.getAndIncrement())));
        }
        for (j = 0; j < mp.length; ++j) {
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)mp[j], this::actionPerformed).m_252794_(this.getGuiLeft() + 8 + j * w, this.getGuiTop() + top + 55).m_253046_(w, h).build(IndexedButton.builder(buttonIndex.getAndIncrement())));
        }
        for (j = 0; j < mp.length; ++j) {
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)mp[j], this::actionPerformed).m_252794_(this.getGuiLeft() + this.f_97726_ / 2 + (j - mp.length / 2) * w, this.getGuiTop() + top + 35).m_253046_(w, h).build(IndexedButton.builder(buttonIndex.getAndIncrement())));
        }
        for (j = 0; j < mp.length; ++j) {
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)mp[j], this::actionPerformed).m_252794_(this.getGuiLeft() + this.f_97726_ - 8 + (j - mp.length) * w, this.getGuiTop() + top + 55).m_253046_(w, h).build(IndexedButton.builder(buttonIndex.getAndIncrement())));
        }
        for (j = 0; j < mp.length; ++j) {
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)mp[j], this::actionPerformed).m_252794_(this.getGuiLeft() + this.f_97726_ / 2 + (j - mp.length / 2) * w, this.getGuiTop() + top + 78).m_253046_(w, h).build(IndexedButton.builder(buttonIndex.getAndIncrement())));
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, delta);
        this.m_280072_(graphics, mouseX, mouseY);
    }

    protected void m_7286_(GuiGraphics graphics, float delta, int mouseX, int mouseY) {
        int pX = this.getGuiLeft();
        int pY = this.getGuiTop();
        graphics.m_280218_(LOCATION, pX, pY, 0, 0, this.f_97726_, this.f_97727_);
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        super.m_280003_(graphics, mouseX, mouseY);
        MutableComponent s = Component.m_237115_((String)TileFlexMarker.Movable.UP.transName);
        graphics.m_280614_(this.f_96547_, (Component)s, (this.f_97726_ - this.f_96547_.m_92852_((FormattedText)s)) / 2, 6, 0x404040, false);
        s = Component.m_237115_((String)TileFlexMarker.Movable.FORWARD.transName);
        graphics.m_280614_(this.f_96547_, (Component)s, (this.f_97726_ - this.f_96547_.m_92852_((FormattedText)s)) / 2, 41, 0x404040, false);
        s = Component.m_237115_((String)TileFlexMarker.Movable.LEFT.transName);
        graphics.m_280614_(this.f_96547_, (Component)s, 48 - this.f_96547_.m_92852_((FormattedText)s) / 2, 61, 0x404040, false);
        s = Component.m_237115_((String)TileFlexMarker.Movable.RIGHT.transName);
        graphics.m_280614_(this.f_96547_, (Component)s, this.f_97726_ - 8 - 40 - this.f_96547_.m_92852_((FormattedText)s) / 2, 61, 0x404040, false);
        s = Component.m_237115_((String)TileFlexMarker.Movable.DOWN.transName);
        graphics.m_280614_(this.f_96547_, (Component)s, (this.f_97726_ - this.f_96547_.m_92852_((FormattedText)s)) / 2, 84, 0x404040, false);
        this.marker.getArea().ifPresent(area -> {
            String start = "(%d, %d, %d)".formatted(area.minX(), area.minY(), area.minZ());
            String end = "(%d, %d, %d)".formatted(area.maxX(), area.maxY(), area.maxZ());
            int x = this.f_97726_ - Math.max(this.f_96547_.m_92895_(start), this.f_96547_.m_92895_(end)) - 10;
            int heightOffset = 26;
            graphics.m_280056_(this.f_96547_, start, x, 6 + heightOffset + 78, 0x404040, false);
            graphics.m_280056_(this.f_96547_, end, x, 6 + heightOffset + 78 + 10, 0x404040, false);
            BlockPos minPos = new BlockPos(area.minX(), area.minY(), area.minZ());
            BlockPos maxPos = new BlockPos(area.maxX(), area.maxY(), area.maxZ());
            String distanceUp = String.valueOf(TileFlexMarker.Movable.UP.distanceFromOrigin(this.marker.m_58899_(), minPos, maxPos, this.marker.direction));
            String distanceLeft = String.valueOf(TileFlexMarker.Movable.LEFT.distanceFromOrigin(this.marker.m_58899_(), minPos, maxPos, this.marker.direction));
            String distanceForward = String.valueOf(TileFlexMarker.Movable.FORWARD.distanceFromOrigin(this.marker.m_58899_(), minPos, maxPos, this.marker.direction));
            String distanceRight = String.valueOf(TileFlexMarker.Movable.RIGHT.distanceFromOrigin(this.marker.m_58899_(), minPos, maxPos, this.marker.direction));
            String distanceDown = String.valueOf(TileFlexMarker.Movable.DOWN.distanceFromOrigin(this.marker.m_58899_(), minPos, maxPos, this.marker.direction));
            graphics.m_280056_(this.f_96547_, distanceUp, (this.f_97726_ - this.f_96547_.m_92895_(distanceUp)) / 2, 6 + heightOffset, 0x404040, false);
            graphics.m_280056_(this.f_96547_, distanceLeft, 48 - this.f_96547_.m_92895_(distanceLeft) / 2, 6 + heightOffset + 55, 0x404040, false);
            graphics.m_280056_(this.f_96547_, distanceForward, (this.f_97726_ - this.f_96547_.m_92895_(distanceForward)) / 2, 6 + heightOffset + 35, 0x404040, false);
            graphics.m_280056_(this.f_96547_, distanceRight, this.f_97726_ - 8 - 40 - this.f_96547_.m_92895_(distanceRight) / 2, 6 + heightOffset + 55, 0x404040, false);
            graphics.m_280056_(this.f_96547_, distanceDown, (this.f_97726_ - this.f_96547_.m_92895_(distanceDown)) / 2, 6 + heightOffset + 78, 0x404040, false);
        });
    }

    public void actionPerformed(Button button) {
        IndexedButton indexedButton;
        int id;
        if (button instanceof IndexedButton && (id = (indexedButton = (IndexedButton)button).id()) >= 0) {
            int[] amounts = new int[]{-16, -1, 1, 16};
            int amount = amounts[id % 4];
            TileFlexMarker.Movable movable = TileFlexMarker.Movable.valueOf(id / 4);
            FlexMarkerMessage message = new FlexMarkerMessage(((ContainerMarker)this.m_6262_()).player.m_9236_(), ((ContainerMarker)this.m_6262_()).pos, movable, amount);
            PacketHandler.sendToServer(message);
        }
    }
}

