/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.integration.jei;

import com.yogpc.qp.Holder;
import com.yogpc.qp.integration.jei.MoverRecipeCategory;
import com.yogpc.qp.integration.jei.WorkBenchRecipeCategory;
import com.yogpc.qp.machines.workbench.RecipeFinder;
import com.yogpc.qp.machines.workbench.ScreenWorkbench;
import com.yogpc.qp.machines.workbench.WorkbenchRecipe;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import me.shedaniel.rei.plugincompatibilities.api.REIPluginCompatIgnore;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

@REIPluginCompatIgnore
@JeiPlugin
public class QuarryJeiPlugin
implements IModPlugin {
    static IJeiRuntime jeiRuntime;
    static WorkBenchRecipeCategory workBenchRecipeCategory;
    static MoverRecipeCategory moverRecipeCategory;

    public void registerRecipes(IRecipeRegistration registration) {
        List recipes = RecipeFinder.find(Objects.requireNonNull(Minecraft.m_91087_().f_91073_).m_7465_(), WorkbenchRecipe.RECIPE_TYPE).values().stream().filter(WorkbenchRecipe::showInJEI).filter(WorkbenchRecipe::hasContent).sorted(WorkbenchRecipe.COMPARATOR).collect(Collectors.toList());
        registration.addRecipes(WorkBenchRecipeCategory.RECIPE_TYPE, recipes);
        registration.addRecipes(MoverRecipeCategory.RECIPE_TYPE, MoverRecipeCategory.recipes());
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Holder.BLOCK_WORKBENCH), new RecipeType[]{WorkBenchRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Holder.BLOCK_MOVER), new RecipeType[]{MoverRecipeCategory.RECIPE_TYPE});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(ScreenWorkbench.class, 7, 74, 161, 11, new RecipeType[]{WorkBenchRecipeCategory.RECIPE_TYPE});
    }

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("quarryplus", "jei_recipe");
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        workBenchRecipeCategory = new WorkBenchRecipeCategory(registry.getJeiHelpers().getGuiHelper());
        registry.addRecipeCategories(new IRecipeCategory[]{workBenchRecipeCategory});
        moverRecipeCategory = new MoverRecipeCategory(registry.getJeiHelpers().getGuiHelper());
        registry.addRecipeCategories(new IRecipeCategory[]{moverRecipeCategory});
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        QuarryJeiPlugin.jeiRuntime = jeiRuntime;
    }
}

