/*
 * Decompiled with CFR 0.152.
 */
package me.mangregory.asr.util.handlers;

import java.util.List;
import me.mangregory.asr.item.AsgardShieldItem;
import me.mangregory.asr.item.GiantSwordItem;
import me.mangregory.asr.util.RandomUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class EventHandler {
    @SubscribeEvent
    public static void onAttackEntity(AttackEntityEvent event) {
        Player player = event.getEntity();
        Level level = player.m_9236_();
        Vec3 pos = player.m_20318_(0.0f);
        if (level instanceof ServerLevel) {
            ServerLevel _level = (ServerLevel)level;
            if (player.m_21120_(player.f_20912_).m_41720_().toString().equals("ender_giant_sword")) {
                EventHandler.enderFx(_level, pos);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onBlockStart(PlayerInteractEvent.RightClickItem event) {
        Player player = event.getEntity();
        Level level = player.m_9236_();
        Vec3 pos = player.m_20318_(0.0f);
        Item itemMainHand = player.m_21120_(InteractionHand.MAIN_HAND).m_41720_();
        Item itemOffHand = player.m_21120_(InteractionHand.OFF_HAND).m_41720_();
        if (itemMainHand instanceof GiantSwordItem || itemOffHand instanceof GiantSwordItem || itemMainHand instanceof AsgardShieldItem || itemOffHand instanceof AsgardShieldItem) {
            level.m_5594_(null, BlockPos.m_274446_((Position)player.m_20318_(0.0f)), SoundEvents.f_12057_, SoundSource.PLAYERS, 0.8f, 0.8f + player.m_9236_().f_46441_.m_188501_() * 0.4f);
        }
        if (itemMainHand instanceof GiantSwordItem) {
            if (itemOffHand instanceof AsgardShieldItem) {
                if (!player.m_36335_().m_41519_(itemOffHand)) {
                    ((GiantSwordItem)itemMainHand).isBlocking = false;
                    ((AsgardShieldItem)itemOffHand).isBlocking = true;
                    if (event.getHand() == InteractionHand.MAIN_HAND) {
                        player.m_5810_();
                        event.setCancellationResult(InteractionResult.PASS);
                        event.setCanceled(true);
                    }
                } else {
                    ((GiantSwordItem)itemMainHand).isBlocking = true;
                    ((AsgardShieldItem)itemOffHand).isBlocking = false;
                }
            } else if (itemOffHand instanceof ShieldItem) {
                ((GiantSwordItem)itemMainHand).isBlocking = false;
                if (event.getHand() == InteractionHand.MAIN_HAND) {
                    player.m_5810_();
                    event.setCancellationResult(InteractionResult.PASS);
                    event.setCanceled(true);
                }
            }
        }
        if (level instanceof ServerLevel) {
            ServerLevel _level = (ServerLevel)level;
            if (player.m_21120_(player.m_7655_()).m_41720_().toString().equals("ender_giant_sword")) {
                EventHandler.enderFx(_level, pos);
            }
        }
    }

    @SubscribeEvent
    public static void onBlockActive(LivingAttackEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!event.getEntity().m_9236_().f_46443_) {
                DamageSource source = event.getSource();
                if (player.m_21254_() && (source.m_276093_(DamageTypes.f_268566_) || source.m_276093_(DamageTypes.f_268534_) || source.m_276093_(DamageTypes.f_268565_) || source.m_276093_(DamageTypes.f_268739_)) || source.m_276093_(DamageTypes.f_268464_) || source.m_276093_(DamageTypes.f_268448_)) {
                    ItemStack stack = player.m_21120_(player.f_20912_);
                    Item item = stack.m_41720_();
                    String name = item.m_7626_(stack).toString();
                    float damage = event.getAmount();
                    float knockback = 0.0f;
                    Entity projectile = source.m_7640_();
                    Entity enemy = source.m_7639_();
                    boolean cancel = true;
                    if (item instanceof AsgardShieldItem) {
                        switch (item.toString()) {
                            case "wooden_shield": {
                                knockback = 1.0f;
                                if (source.m_276093_(DamageTypes.f_268468_)) {
                                    cancel = false;
                                    break;
                                }
                                if (!(projectile instanceof Arrow)) break;
                                Arrow arrow = (Arrow)projectile;
                                if (arrow.m_6060_()) {
                                    cancel = false;
                                    break;
                                }
                                if (!RandomUtil.chance(0.5)) break;
                                EventHandler.dropArrowAtPlayer(arrow, player);
                                break;
                            }
                            case "gilded_wooden_shield": {
                                knockback = 1.5f;
                                if (source.m_276093_(DamageTypes.f_268468_)) {
                                    cancel = false;
                                    break;
                                }
                                if (!(projectile instanceof Arrow)) break;
                                Arrow arrow = (Arrow)projectile;
                                if (arrow.m_6060_()) {
                                    cancel = false;
                                    break;
                                }
                                EventHandler.dropArrowAtPlayer(arrow, player);
                                break;
                            }
                            case "stone_shield": {
                                if (source.m_276093_(DamageTypes.f_268565_)) {
                                    damage *= 1.5f;
                                    cancel = false;
                                    break;
                                }
                                if (source.m_276093_(DamageTypes.f_268468_) && RandomUtil.chance(0.5)) {
                                    damage = 0.0f;
                                }
                                knockback = 1.5f;
                                player.m_9236_().m_5594_(null, BlockPos.m_274446_((Position)player.m_20318_(0.0f)), SoundEvents.f_12442_, SoundSource.PLAYERS, 0.8f, 0.8f + player.m_9236_().f_46441_.m_188501_() * 0.4f);
                                break;
                            }
                            case "gilded_stone_shield": {
                                if (source.m_276093_(DamageTypes.f_268565_)) {
                                    damage *= 1.5f;
                                    cancel = false;
                                    break;
                                }
                                if (source.m_276093_(DamageTypes.f_268468_)) {
                                    damage = 0.0f;
                                }
                                knockback = 1.5f;
                                player.m_9236_().m_5594_(null, BlockPos.m_274446_((Position)player.m_20318_(0.0f)), SoundEvents.f_12442_, SoundSource.PLAYERS, 0.8f, 0.8f + player.m_9236_().f_46441_.m_188501_() * 0.4f);
                                break;
                            }
                            case "iron_shield": {
                                if (player.m_20070_()) {
                                    damage *= 1.5f;
                                }
                                if (source.m_276093_(DamageTypes.f_268565_) && RandomUtil.chance(0.5)) {
                                    damage *= 0.5f;
                                }
                                knockback = 1.0f;
                                player.m_9236_().m_5594_(null, BlockPos.m_274446_((Position)player.m_20318_(0.0f)), SoundEvents.f_11668_, SoundSource.PLAYERS, 0.6f, 0.8f + player.m_9236_().f_46441_.m_188501_() * 0.4f);
                                break;
                            }
                            case "gilded_iron_shield": {
                                if (player.m_20070_()) {
                                    damage *= 1.5f;
                                }
                                if (source.m_276093_(DamageTypes.f_268565_)) {
                                    damage *= 0.5f;
                                }
                                knockback = 1.5f;
                                player.m_9236_().m_5594_(null, BlockPos.m_274446_((Position)player.m_20318_(0.0f)), SoundEvents.f_11668_, SoundSource.PLAYERS, 0.6f, 0.8f + player.m_9236_().f_46441_.m_188501_() * 0.4f);
                                break;
                            }
                            case "diamond_shield": {
                                if (projectile != null && RandomUtil.chance(0.3)) {
                                    EventHandler.reflectProjectile(player, projectile);
                                    damage *= 1.5f;
                                } else {
                                    knockback = 1.0f;
                                }
                                player.m_9236_().m_5594_(null, BlockPos.m_274446_((Position)player.m_20318_(0.0f)), (SoundEvent)SoundEvents.f_12211_.get(), SoundSource.PLAYERS, 0.6f, 0.8f + player.m_9236_().f_46441_.m_188501_() * 0.4f);
                                break;
                            }
                            case "gilded_diamond_shield": {
                                if (projectile != null && RandomUtil.chance(0.6)) {
                                    EventHandler.reflectProjectile(player, projectile);
                                    damage *= 1.5f;
                                } else {
                                    knockback = 1.5f;
                                }
                                player.m_9236_().m_5594_(null, BlockPos.m_274446_((Position)player.m_20318_(0.0f)), (SoundEvent)SoundEvents.f_12211_.get(), SoundSource.PLAYERS, 0.6f, 0.8f + player.m_9236_().f_46441_.m_188501_() * 0.4f);
                                break;
                            }
                            case "netherquartz_shield": {
                                player.m_36399_(damage);
                                if (projectile instanceof SmallFireball && RandomUtil.chance(0.5)) {
                                    player.m_9236_().m_5594_(null, BlockPos.m_274446_((Position)player.m_20318_(0.0f)), SoundEvents.f_11937_, SoundSource.PLAYERS, 0.6f, 0.8f + player.m_9236_().f_46441_.m_188501_() * 0.4f);
                                    projectile.m_146870_();
                                    player.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_42613_));
                                }
                                knockback = 1.0f;
                                player.m_9236_().m_5594_(null, BlockPos.m_274446_((Position)player.m_20318_(0.0f)), (SoundEvent)SoundEvents.f_12218_.get(), SoundSource.PLAYERS, 0.6f, 0.8f + player.m_9236_().f_46441_.m_188501_() * 0.4f);
                                break;
                            }
                            case "gilded_netherquartz_shield": {
                                player.m_36399_(damage);
                                if (projectile instanceof SmallFireball) {
                                    player.m_9236_().m_5594_(null, BlockPos.m_274446_((Position)player.m_20318_(0.0f)), SoundEvents.f_11937_, SoundSource.PLAYERS, 0.8f, 0.8f + player.m_9236_().f_46441_.m_188501_() * 0.4f);
                                    projectile.m_146870_();
                                    player.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_42613_));
                                }
                                knockback = 1.5f;
                                player.m_9236_().m_5594_(null, BlockPos.m_274446_((Position)player.m_20318_(0.0f)), (SoundEvent)SoundEvents.f_12218_.get(), SoundSource.PLAYERS, 0.8f, 0.8f + player.m_9236_().f_46441_.m_188501_() * 0.4f);
                                break;
                            }
                            case "skull_shield": {
                                if (RandomUtil.chance(0.1f)) {
                                    damage *= 3.0f;
                                }
                                if (enemy instanceof LivingEntity && RandomUtil.chance(0.15)) {
                                    List entities = enemy.m_9236_().m_45933_(null, new AABB(enemy.m_20185_() - 4.0, enemy.m_20186_() - 4.0, enemy.m_20189_() - 4.0, enemy.m_20185_() + 4.0, enemy.m_20186_() + 4.0, enemy.m_20189_() + 4.0));
                                    if (entities.size() > 1) {
                                        ((LivingEntity)enemy).m_7023_(((Entity)entities.get(1)).m_20318_(0.0f));
                                        ((LivingEntity)enemy).m_7327_((Entity)entities.get(1));
                                    } else {
                                        enemy.m_6469_(new DamageSource((Holder)DamageTypes.f_268515_), 10000.0f);
                                    }
                                }
                                knockback = 1.0f;
                                player.m_9236_().m_5594_(null, BlockPos.m_274446_((Position)player.m_20318_(0.0f)), SoundEvents.f_12381_, SoundSource.PLAYERS, 0.8f, 0.8f + player.m_9236_().f_46441_.m_188501_() * 0.4f);
                                break;
                            }
                            case "gilded_skull_shield": {
                                if (RandomUtil.chance(0.1f)) {
                                    damage *= 3.0f;
                                }
                                if (enemy instanceof LivingEntity && RandomUtil.chance(0.3)) {
                                    List entities = enemy.m_9236_().m_45933_(null, new AABB(enemy.m_20185_() - 4.0, enemy.m_20186_() - 4.0, enemy.m_20189_() - 4.0, enemy.m_20185_() + 4.0, enemy.m_20186_() + 4.0, enemy.m_20189_() + 4.0));
                                    if (entities.size() > 1) {
                                        ((LivingEntity)enemy).m_7023_(((Entity)entities.get(1)).m_20318_(0.0f));
                                        ((LivingEntity)enemy).m_7327_((Entity)entities.get(1));
                                    } else {
                                        enemy.m_6469_(new DamageSource((Holder)DamageTypes.f_268515_), 10000.0f);
                                    }
                                }
                                knockback = 1.5f;
                                player.m_9236_().m_5594_(null, BlockPos.m_274446_((Position)player.m_20318_(0.0f)), SoundEvents.f_12381_, SoundSource.PLAYERS, 0.8f, 0.8f + player.m_9236_().f_46441_.m_188501_() * 0.4f);
                                break;
                            }
                            case "ender_shield": {
                                if (enemy instanceof EnderMan || enemy instanceof Endermite || enemy instanceof EnderDragon) {
                                    cancel = false;
                                    break;
                                }
                                knockback = enemy instanceof LivingEntity && RandomUtil.chance(0.2) ? EventHandler.teleportEnemy(enemy, knockback) : 1.5f;
                                player.m_9236_().m_5594_(null, BlockPos.m_274446_((Position)player.m_20318_(0.0f)), SoundEvents.f_11895_, SoundSource.PLAYERS, 0.8f, 0.8f + player.m_9236_().f_46441_.m_188501_() * 0.4f);
                                break;
                            }
                            case "gilded_ender_shield": {
                                if (enemy instanceof EnderMan || enemy instanceof Endermite || enemy instanceof EnderDragon) {
                                    cancel = false;
                                    break;
                                }
                                knockback = enemy instanceof LivingEntity && RandomUtil.chance(0.4) ? EventHandler.teleportEnemy(enemy, knockback) : 1.5f;
                                player.m_9236_().m_5594_(null, BlockPos.m_274446_((Position)player.m_20318_(0.0f)), SoundEvents.f_11895_, SoundSource.PLAYERS, 0.8f, 0.8f + player.m_9236_().f_46441_.m_188501_() * 0.4f);
                            }
                        }
                        if (cancel) {
                            stack.m_41720_().damageItem(stack, (int)damage, (LivingEntity)player, player1 -> {});
                            if (enemy instanceof LivingEntity && projectile == enemy) {
                                ((LivingEntity)enemy).m_147240_((double)(knockback * 0.5f), player.m_20185_() - enemy.m_20186_(), player.m_20189_() - enemy.m_20189_());
                            }
                        }
                    } else if (item instanceof GiantSwordItem) {
                        switch (item.toString()) {
                            case "wooden_giant_sword": {
                                knockback = 1.0f;
                                break;
                            }
                            case "stone_giant_sword": {
                                knockback = 1.0f;
                                player.m_9236_().m_5594_(null, BlockPos.m_274446_((Position)player.m_20318_(0.0f)), SoundEvents.f_12442_, SoundSource.PLAYERS, 0.8f, 0.8f + player.m_9236_().f_46441_.m_188501_() * 0.4f);
                                break;
                            }
                            case "iron_giant_sword": 
                            case "golden_giant_sword": {
                                knockback = 1.0f;
                                player.m_9236_().m_5594_(null, BlockPos.m_274446_((Position)player.m_20318_(0.0f)), SoundEvents.f_11668_, SoundSource.PLAYERS, 0.6f, 0.8f + player.m_9236_().f_46441_.m_188501_() * 0.4f);
                                break;
                            }
                            case "diamond_giant_sword": {
                                knockback = 1.0f;
                                player.m_9236_().m_5594_(null, BlockPos.m_274446_((Position)player.m_20318_(0.0f)), (SoundEvent)SoundEvents.f_12211_.get(), SoundSource.PLAYERS, 0.8f, 0.8f + player.m_9236_().f_46441_.m_188501_() * 0.4f);
                                break;
                            }
                            case "netherquartz_giant_sword": {
                                knockback = 1.0f;
                                player.m_9236_().m_5594_(null, BlockPos.m_274446_((Position)player.m_20318_(0.0f)), (SoundEvent)SoundEvents.f_12218_.get(), SoundSource.PLAYERS, 0.8f, 0.8f + player.m_9236_().f_46441_.m_188501_() * 0.4f);
                                break;
                            }
                            case "skull_giant_sword": {
                                knockback = 1.0f;
                                player.m_9236_().m_5594_(null, BlockPos.m_274446_((Position)player.m_20318_(0.0f)), SoundEvents.f_12381_, SoundSource.PLAYERS, 0.8f, 0.8f + player.m_9236_().f_46441_.m_188501_() * 0.4f);
                                break;
                            }
                            case "ender_giant_sword": {
                                knockback = 1.0f;
                                player.m_9236_().m_5594_(null, BlockPos.m_274446_((Position)player.m_20318_(0.0f)), SoundEvents.f_11895_, SoundSource.PLAYERS, 0.8f, 0.8f + player.m_9236_().f_46441_.m_188501_() * 0.4f);
                            }
                        }
                        stack.m_41720_().damageItem(stack, (int)damage, (LivingEntity)player, player1 -> {});
                        if (enemy instanceof LivingEntity && projectile == enemy) {
                            ((LivingEntity)enemy).m_147240_((double)(knockback * 0.5f), player.m_20185_() - enemy.m_20185_(), player.m_20189_() - enemy.m_20189_());
                        }
                    }
                }
            }
        }
    }

    public static void dropArrowAtPlayer(Arrow arrow, Player player) {
        arrow.m_20334_(0.0, 0.0, 0.0);
        arrow.m_146870_();
        ItemStack arrowStack = new ItemStack((ItemLike)Items.f_42412_);
        player.m_150109_().m_36054_(arrowStack);
        player.m_9236_().m_5594_(null, BlockPos.m_274446_((Position)player.m_20318_(0.0f)), SoundEvents.f_11685_, SoundSource.PLAYERS, 0.8f, 0.8f + player.m_9236_().f_46441_.m_188501_() * 0.4f);
    }

    public static void reflectProjectile(Player player, Entity projectile) {
        Vec3 look = player.m_20154_();
        double speed = projectile.m_20185_() * projectile.f_19854_ + projectile.f_19855_ * projectile.f_19855_ + projectile.f_19856_ * projectile.f_19856_;
        speed = Math.sqrt(speed);
        projectile.f_19854_ = look.f_82479_ * (speed += (double)0.2f);
        projectile.f_19855_ = look.f_82480_ * speed;
        projectile.f_19856_ = look.f_82481_ * speed;
        projectile.m_7890_(Rotation.CLOCKWISE_180);
        if (player instanceof ServerPlayer) {
            ((ServerPlayer)player).f_8906_.f_9742_.m_129512_((Packet)new ClientboundAddEntityPacket(projectile));
        }
        if (projectile instanceof Arrow) {
            ((Arrow)projectile).m_5602_((Entity)player);
            projectile.f_19854_ /= (double)-0.1f;
            projectile.f_19855_ /= (double)-0.1f;
            projectile.f_19856_ /= (double)-0.1f;
        }
    }

    public static float teleportEnemy(Entity enemy, float knockback) {
        Vec3 prevPos = enemy.m_20318_(0.0f);
        double d0 = enemy.m_20318_((float)0.0f).f_82479_ + (enemy.m_9236_().f_46441_.m_188500_() - 0.5) * 64.0;
        double d1 = enemy.m_20318_((float)0.0f).f_82480_ + (double)(enemy.m_9236_().f_46441_.m_188503_(64) - 32);
        double d2 = enemy.m_20318_((float)0.0f).f_82481_ + (enemy.m_9236_().f_46441_.m_188500_() - 0.5) * 64.0;
        if (enemy.m_9236_() instanceof ServerLevel) {
            enemy.m_6021_(d0, d1, d2);
            enemy.m_9236_().m_6263_(null, prevPos.f_82479_, prevPos.f_82480_, prevPos.f_82481_, SoundEvents.f_11852_, enemy.m_5720_(), 1.0f, 1.0f);
            enemy.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
            return 0.0f;
        }
        return knockback;
    }

    public static void enderFx(ServerLevel level, Vec3 playerPos) {
        for (int i = 0; i < 3; ++i) {
            int rand1 = level.f_46441_.m_188503_(2) * 2 - 1;
            int rand2 = level.f_46441_.m_188503_(2) * 2 - 1;
            double xCoord = playerPos.f_82479_ + 0.5 + 0.25 * (double)rand1;
            double yCoord = playerPos.m_7098_() + (double)level.f_46441_.m_188501_();
            double zCoord = playerPos.m_7094_() + 0.5 + 0.25 * (double)rand2;
            double speed = ((double)level.f_46441_.m_188501_() - 0.5) * 0.125;
            level.m_8767_((ParticleOptions)ParticleTypes.f_123760_, xCoord, yCoord, zCoord, 2, 0.0, 0.0, 0.0, speed);
        }
    }
}

