/*
 * Decompiled with CFR 0.152.
 */
package me.mangregory.asr.item;

import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.Nullable;

public class GiantSwordItem
extends SwordItem {
    private static final Set<ToolAction> TOOL_ACTIONS = ToolActions.DEFAULT_SWORD_ACTIONS;
    public boolean isBlocking = false;
    public int cooldown;
    public int maxUseDuration;

    public GiantSwordItem(Tier p_43269_, int p_43270_, float p_43271_, Item.Properties p_43272_, int maxUseDuration) {
        super(p_43269_, p_43270_, p_43271_, p_43272_);
        this.maxUseDuration = maxUseDuration;
        this.cooldown = 0;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        player.m_6672_(hand);
        this.isBlocking = true;
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        TOOL_ACTIONS.add(ToolActions.SHIELD_BLOCK);
        return TOOL_ACTIONS.contains(toolAction);
    }

    public UseAnim m_6164_(ItemStack stack) {
        if (this.isBlocking) {
            return UseAnim.BLOCK;
        }
        return UseAnim.NONE;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public void onStopUsing(ItemStack stack, LivingEntity entity, int count) {
        if (entity instanceof Player && !entity.m_9236_().f_46443_) {
            ((Player)entity).m_36335_().m_41524_((Item)this, this.cooldown / 2);
            this.cooldown = 0;
        }
        this.isBlocking = false;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag flag) {
        components.add((Component)Component.m_237113_((String)("Maximum Block Duration: " + this.maxUseDuration / 20 + "s")).m_130940_(ChatFormatting.AQUA));
        super.m_7373_(stack, level, components, flag);
    }

    public void m_5929_(Level level, LivingEntity entity, ItemStack stack, int count) {
        if (!entity.m_9236_().f_46443_) {
            ++this.cooldown;
        }
        if (this.cooldown >= this.maxUseDuration) {
            entity.m_5810_();
            this.isBlocking = false;
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }
}

