/*
 * Decompiled with CFR 0.152.
 */
package me.mangregory.asr.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class AsgardShieldItem
extends ShieldItem {
    private final String strengthDesc;
    private final String weaknessDesc;
    public int cooldown = 0;
    public boolean isBlocking = false;
    public int maxUseDuration;

    public AsgardShieldItem(Item.Properties properties, int maxUseDuration, String strength, String weakness) {
        super(properties);
        this.maxUseDuration = maxUseDuration;
        this.strengthDesc = strength;
        this.weaknessDesc = weakness;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        ItemStack stack = player.m_21120_(interactionHand);
        player.m_6672_(interactionHand);
        player.m_9236_().m_5594_(null, BlockPos.m_274446_((Position)player.m_20318_(0.0f)), SoundEvents.f_12057_, SoundSource.PLAYERS, 0.8f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
        this.isBlocking = true;
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack stack) {
        if (this.isBlocking) {
            return UseAnim.BLOCK;
        }
        return UseAnim.NONE;
    }

    public void onStopUsing(ItemStack stack, LivingEntity entity, int count) {
        if (entity instanceof Player && !entity.m_9236_().f_46443_) {
            ((Player)entity).m_36335_().m_41524_((Item)this, this.cooldown / 2);
            this.cooldown = 0;
        }
        this.isBlocking = false;
    }

    public void m_5929_(Level level, LivingEntity entity, ItemStack stack, int count) {
        if (!entity.m_9236_().f_46443_) {
            ++this.cooldown;
        }
        if (this.cooldown >= this.maxUseDuration) {
            entity.m_5810_();
            this.isBlocking = false;
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag flag) {
        components.add((Component)Component.m_237113_((String)("Maximum Block Duration: " + this.maxUseDuration / 20 + "s")).m_130940_(ChatFormatting.AQUA));
        components.add((Component)Component.m_237113_((String)("Perk: " + this.strengthDesc)).m_130940_(ChatFormatting.GREEN));
        components.add((Component)Component.m_237113_((String)("Weakness: " + this.weaknessDesc)).m_130940_(ChatFormatting.RED));
        super.m_7373_(stack, level, components, flag);
    }
}

