/*
 * Decompiled with CFR 0.152.
 */
package elocindev.necronomicon.api.text;

import elocindev.necronomicon.util.ColorUtils;
import java.awt.Color;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

public class TextAPI {
    public static void setStaticGradient(MutableComponent text, int color1, int color2) {
        text.m_6270_(Styles.getStaticGradient((Component)text, color1, color2).m_7383_());
    }

    public static void setSlideGradient(MutableComponent text, int offset, int color1, int color2, float tickrate) {
        text.m_6270_(Styles.getGradient((Component)text, offset, color1, color2, tickrate).m_7383_());
    }

    public static void setBreathingGradient(MutableComponent text, int offset, int color1, int color2, float tickrate) {
        text.m_6270_(Styles.getBreathingGradient((Component)text, offset, color1, color2, tickrate).m_7383_());
    }

    public static void setRainbowGradient(MutableComponent text, int offset, float tickrate) {
        text.m_6270_(Styles.getRainbowGradient((Component)text, offset, tickrate).m_7383_());
    }

    private static MutableComponent getEmptyText() {
        return Component.m_237119_();
    }

    public class Styles {
        public static MutableComponent getStaticGradient(Component text, int color1, int color2) {
            MutableComponent gradientColor = TextAPI.getEmptyText();
            String string = text.getString();
            for (int i = 0; i < string.length(); ++i) {
                int color = ColorUtils.interpolate(color1, color2, (double)i / (double)string.length());
                Style style = Style.f_131099_.m_178520_(color);
                gradientColor.m_7220_((Component)Component.m_237113_((String)String.valueOf(string.charAt(i))).m_6270_(style));
            }
            return gradientColor;
        }

        public static MutableComponent getGradient(Component text, int offset, int color1, int color2, float tickrate) {
            long time = System.currentTimeMillis() / ((long)tickrate * 50L);
            MutableComponent gradientColor = TextAPI.getEmptyText();
            String string = text.getString();
            for (int i = 0; i < string.length(); ++i) {
                double hue = (double)(time - (long)i - (long)offset) % 45.0;
                Style style = Style.f_131099_.m_178520_(ColorUtils.gradientSlide((float)hue / 22.5f, new Color(color1), new Color(color2)).getRGB());
                gradientColor.m_7220_((Component)Component.m_237113_((String)String.valueOf(string.charAt(i))).m_6270_(style));
            }
            return gradientColor;
        }

        public static MutableComponent getBreathingGradient(Component text, int offset, int color1, int color2, float tickrate) {
            long time = System.currentTimeMillis() / ((long)tickrate * 50L);
            MutableComponent gradientColor = TextAPI.getEmptyText();
            String string = text.getString();
            for (int i = 0; i < string.length(); ++i) {
                double animationFactor = (Math.sin((double)(time - (long)i - (long)offset) * 0.05) + 1.0) / 2.0;
                int color = ColorUtils.interpolateAnimation(color1, color2, (double)i / (double)string.length(), animationFactor);
                Style style = Style.f_131099_.m_178520_(color);
                gradientColor.m_7220_((Component)Component.m_237113_((String)String.valueOf(string.charAt(i))).m_6270_(style));
            }
            return gradientColor;
        }

        public static MutableComponent getRainbowGradient(Component text, int offset, float tickrate) {
            long time = System.currentTimeMillis() / ((long)tickrate * 50L);
            String string = text.getString();
            MutableComponent rainbowColor = TextAPI.getEmptyText();
            for (int i = 0; i < string.length(); ++i) {
                double hue = 0.011111111111111112 * (double)(time - (long)i - (long)offset);
                Style style = Style.f_131099_.m_178520_(Color.HSBtoRGB((float)(hue % 360.0), 0.5f, 1.0f));
                rainbowColor.m_7220_((Component)Component.m_237113_((String)String.valueOf(string.charAt(i))).m_6270_(style));
            }
            return rainbowColor;
        }
    }
}

