/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.craterlib.core.config;

import com.hypherionmc.craterlib.CraterConstants;
import com.hypherionmc.craterlib.core.config.AbstractConfig;
import java.io.Serializable;
import java.util.HashMap;
import org.jetbrains.annotations.ApiStatus;
import shadow.hypherionmc.moonconfig.core.file.FileWatcher;

public final class ConfigController
implements Serializable {
    private static final HashMap<String, AbstractConfig> watchedConfigs = new HashMap();
    private static final FileWatcher watcher = new FileWatcher(e -> CraterConstants.LOG.error("Config Watcher Error", (Throwable)e));

    @ApiStatus.Internal
    public static void register_config(AbstractConfig config) {
        if (watchedConfigs.containsKey(config.getConfigPath().toString())) {
            CraterConstants.LOG.error("Failed to register {}. Config already registered", (Object)config.getConfigPath().getName());
        } else {
            try {
                watcher.addWatch(config.getConfigPath(), () -> {
                    if (!config.isWasSaveCalled()) {
                        CraterConstants.LOG.info("Sending Reload Event for: {}", (Object)config.getConfigPath().getName());
                        config.configReloaded();
                    }
                });
            }
            catch (Exception e) {
                CraterConstants.LOG.error("Failed to register {} for auto reloading. {}", (Object)config.getConfigPath().getName(), (Object)e.getMessage());
            }
            watchedConfigs.put(config.getConfigPath().toString(), config);
            CraterConstants.LOG.info("Registered {} successfully!", (Object)config.getConfigPath().getName());
        }
    }

    public static HashMap<String, AbstractConfig> getWatchedConfigs() {
        return watchedConfigs;
    }
}

