/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.network.packet.s2c;

import com.nine.travelerscompass.common.data.CompassProperties;
import com.nine.travelerscompass.common.data.DataStorage;
import com.nine.travelerscompass.common.item.TravelersCompassItem;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class SyncDataPacket {
    private final UUID uuid;
    private final DataStorage<?> data;
    private final CompoundTag tag;

    public SyncDataPacket(DataStorage<?> data, CompoundTag tag, UUID uuid) {
        this.data = data;
        this.tag = tag;
        this.uuid = uuid;
    }

    public SyncDataPacket(FriendlyByteBuf buf) {
        this.data = CompassProperties.REGISTRY.get(buf.m_130281_());
        this.tag = buf.m_130260_();
        this.uuid = buf.m_130259_();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130085_(this.data.getId());
        buf.m_130079_(this.tag);
        buf.m_130077_(this.uuid);
    }

    public static void onMessage(SyncDataPacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        if (context.getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            context.enqueueWork(() -> SyncDataPacket.handleClientPacket(packet));
        }
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleClientPacket(SyncDataPacket packet) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ItemStack stack = null;
        ItemStack handStack = player.m_21205_();
        Item item = handStack.m_41720_();
        if (item instanceof TravelersCompassItem) {
            TravelersCompassItem compassItem = (TravelersCompassItem)item;
            if (CompassProperties.COMPASS_UUID.get(handStack).equals(packet.uuid)) {
                stack = handStack;
            }
        }
        if (stack == null) {
            for (ItemStack slotStack : player.m_150109_().f_35974_) {
                if (!(slotStack.m_41720_() instanceof TravelersCompassItem) || !CompassProperties.COMPASS_UUID.get(slotStack).equals(packet.uuid)) continue;
                stack = slotStack;
                break;
            }
        }
        if (stack != null && packet.tag != null) {
            Object value = CompassProperties.get(packet.tag, packet.data);
            DataStorage<?> finalDataStorage = packet.data;
            CompassProperties.putWithValidation(stack, finalDataStorage, value);
        }
    }
}

