/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.compat.lootr;

import com.nine.travelerscompass.common.data.CompassProperties;
import com.nine.travelerscompass.common.search.SearchOptions;
import com.nine.travelerscompass.common.search.criterion.ISearchCriterion;
import com.nine.travelerscompass.common.search.criterion.TypedCriteria;
import com.nine.travelerscompass.common.search.location.ILocationObject;
import com.nine.travelerscompass.common.search.location.LootrContainerLocationObject;
import com.nine.travelerscompass.common.search.location.LootrMinecartLocationObject;
import com.nine.travelerscompass.compat.lootr.LootrSearchMode;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import noobanidus.mods.lootr.api.IHasOpeners;
import noobanidus.mods.lootr.api.blockentity.ILootBlockEntity;
import noobanidus.mods.lootr.data.DataStorage;
import noobanidus.mods.lootr.data.SpecialChestInventory;
import noobanidus.mods.lootr.entity.LootrChestMinecartEntity;

public class ForgeLootrHelper {
    public static List<ILocationObject> minecartMatch(TypedCriteria criteria, SearchOptions options, Entity entity, Level level, BlockPos pos) {
        ArrayList<ILocationObject> ret = new ArrayList<ILocationObject>();
        if (entity instanceof LootrChestMinecartEntity) {
            LootrChestMinecartEntity minecart = (LootrChestMinecartEntity)entity;
            if (criteria.itemCriteria.isEmpty()) {
                return List.of();
            }
            if (!ForgeLootrHelper.shouldCheckLootrContainer((IHasOpeners)minecart, options)) {
                return ret;
            }
            SpecialChestInventory inventory = DataStorage.getInventory((Level)level, (LootrChestMinecartEntity)minecart, (ServerPlayer)options.player(), (arg_0, arg_1, arg_2, arg_3) -> ((LootrChestMinecartEntity)minecart).addLoot(arg_0, arg_1, arg_2, arg_3));
            if (inventory != null) {
                String id = entity.m_6095_().m_20675_();
                for (ItemStack stack : inventory.getInventoryContents()) {
                    Item item = stack.m_41720_();
                    if (!criteria.itemCriteriaMap.containsKey(item)) continue;
                    ISearchCriterion criterion = criteria.itemCriteriaMap.get(item);
                    ret.add(new LootrMinecartLocationObject(pos.m_7949_(), criterion.slot(), criterion.priority(), id, item.m_5524_(), entity.m_20148_()));
                }
            }
        }
        return ret;
    }

    public static List<ILocationObject> matchLootrContainer(TypedCriteria criteria, SearchOptions options, BlockPos pos, BlockState state, BlockEntity be) {
        ArrayList<ILocationObject> ret = new ArrayList<ILocationObject>();
        if (be instanceof ILootBlockEntity) {
            ILootBlockEntity lootEntity = (ILootBlockEntity)be;
            if (criteria.itemCriteria.isEmpty()) {
                return List.of();
            }
            if (!ForgeLootrHelper.shouldCheckLootrContainer((IHasOpeners)lootEntity, options)) {
                return ret;
            }
            SpecialChestInventory inventory = DataStorage.getInventory((Level)options.player().m_9236_(), (UUID)lootEntity.getTileId(), (BlockPos)lootEntity.getPosition(), (ServerPlayer)options.player(), (RandomizableContainerBlockEntity)((RandomizableContainerBlockEntity)lootEntity), (arg_0, arg_1, arg_2, arg_3) -> ((ILootBlockEntity)lootEntity).unpackLootTable(arg_0, arg_1, arg_2, arg_3));
            if (inventory != null) {
                ResourceLocation id = ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_());
                for (ItemStack stack : inventory.getInventoryContents()) {
                    Item item = stack.m_41720_();
                    if (!criteria.itemCriteriaMap.containsKey(item)) continue;
                    ISearchCriterion criterion = criteria.itemCriteriaMap.get(item);
                    ret.add(new LootrContainerLocationObject(pos.m_7949_(), criterion.slot(), criterion.priority(), 0, state.m_60734_().m_7705_(), item.m_5524_(), id));
                }
            }
        }
        return ret;
    }

    public static boolean shouldCheckLootrContainer(IHasOpeners iHasOpeners, SearchOptions options) {
        LootrSearchMode searchMode = options.get(CompassProperties.LOOTR_MODE);
        boolean opened = iHasOpeners.getOpeners().contains(options.getPlayerUUID());
        return switch (searchMode) {
            case LootrSearchMode.ALL -> true;
            case LootrSearchMode.OPENED -> opened;
            case LootrSearchMode.CLOSED -> {
                if (!opened) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }
}

