/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.common.search.location;

import com.nine.travelerscompass.common.search.location.ILocationObject;
import com.nine.travelerscompass.common.search.location.codec.LocationCodec;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Block;

public record BlockLocationObject(BlockPos blockPos, int slotIndex, boolean priority, String descriptionId, ResourceLocation blockId) implements ILocationObject
{
    public static ResourceLocation TYPE = new ResourceLocation("travelerscompass", "block_location_codec");
    public static final LocationCodec<BlockLocationObject> CODEC = new LocationCodec<BlockLocationObject>(){

        @Override
        public void write(FriendlyByteBuf buf, BlockLocationObject obj) {
            this.writePosSafe(buf, obj.blockPos);
            buf.writeInt(obj.slotIndex);
            buf.writeBoolean(obj.priority);
            buf.m_130070_(obj.descriptionId);
            buf.m_130085_(obj.blockId);
        }

        @Override
        public BlockLocationObject read(FriendlyByteBuf buf) {
            BlockPos blockPos = this.readPosSafe(buf);
            int slotIndex = buf.readInt();
            boolean priority = buf.readBoolean();
            String descriptionId = buf.m_130277_();
            ResourceLocation blockId = buf.m_130281_();
            return new BlockLocationObject(blockPos, slotIndex, priority, descriptionId, blockId);
        }
    };

    @Override
    public ResourceLocation type() {
        return TYPE;
    }

    @Override
    public ILocationObject copy(BlockPos blockPos, int slotIndex, boolean priority, String descriptionId) {
        return new BlockLocationObject(blockPos, slotIndex, priority, descriptionId, this.blockId);
    }

    @Override
    public boolean isValid(ServerLevel level) {
        boolean loaded = level.m_46749_(this.blockPos);
        if (!loaded) {
            return true;
        }
        Block block = level.m_8055_(this.blockPos).m_60734_();
        return ((Block)BuiltInRegistries.f_256975_.m_7745_(this.blockId)).equals(block);
    }

    @Override
    public Optional<ILocationObject> update(ServerLevel level) {
        return Optional.of(this);
    }

    @Override
    public String toString() {
        return "Block Location: [" + this.descriptionId + "], " + String.valueOf(this.blockPos) + (this.priority ? " [priority]" : "");
    }
}

