/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.common.container.menu;

import com.nine.travelerscompass.common.container.CompassContainer;
import com.nine.travelerscompass.common.data.CompassProperties;
import com.nine.travelerscompass.common.item.TravelersCompassItem;
import com.nine.travelerscompass.common.search.SearchManager;
import com.nine.travelerscompass.config.filter.FilterManager;
import com.nine.travelerscompass.config.filter.FilterReason;
import com.nine.travelerscompass.init.ItemRegistry;
import com.nine.travelerscompass.init.MenuRegistry;
import java.util.Arrays;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.AirItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class CompassMenu
extends AbstractContainerMenu {
    public static final int COMPASS_SLOTS = 9;

    public CompassMenu(int id, Inventory playerInventory, CompassContainer container) {
        super((MenuType)MenuRegistry.COMPASS_MENU.get(), id);
        int j;
        int i;
        int slotIndex = 0;
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                this.m_38897_(new Slot(container, slotIndex, 73 + j * 18, 11 + i * 18){

                    public boolean m_5857_(ItemStack stack) {
                        return super.m_5857_(stack);
                    }

                    public boolean m_280329_() {
                        Item item = CompassMenu.this.m_142621_().m_41720_();
                        FilterReason reason = FilterManager.getFilterReason(item);
                        return item instanceof AirItem || reason instanceof FilterReason.Allowed;
                    }

                    public boolean m_8010_(Player CompassMenuIn) {
                        return false;
                    }
                });
                ++slotIndex;
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, slotIndex, 9 + j * 18, i * 18 + 87){

                    public boolean m_5857_(ItemStack stack) {
                        return !(stack.m_41720_() instanceof TravelersCompassItem);
                    }
                });
                ++slotIndex;
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 9 + i * 18, 145){

                public boolean m_5857_(ItemStack stack) {
                    return !(stack.m_41720_() instanceof TravelersCompassItem);
                }

                public boolean m_8010_(Player player) {
                    return !(this.m_7993_().m_41720_() instanceof TravelersCompassItem);
                }
            });
            ++slotIndex;
        }
    }

    public ItemStack m_7648_(Player player, int index) {
        Slot slot = (Slot)this.f_38839_.get(index);
        if (index > 8 && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = ((Slot)this.f_38839_.get(i)).m_7993_();
                if (slotStack.m_41720_() == stack.m_41720_()) {
                    return ItemStack.f_41583_;
                }
                if (!stack.m_41619_()) continue;
                ItemStack itemstack = slotStack.m_41777_();
                if (!this.mayPlaceToSlot(player, itemstack)) break;
                itemstack.m_41764_(1);
                CompassContainer container = (CompassContainer)((Slot)this.f_38839_.get((int)i)).f_40218_;
                container.setItem(i, itemstack, player);
                break;
            }
        }
        return ItemStack.f_41583_;
    }

    public void m_150399_(int slotIndex, int dragType, ClickType clickType, Player player) {
        if (slotIndex >= 0 && slotIndex < 9 && !(this.m_38853_(slotIndex).m_7993_().m_41720_() instanceof TravelersCompassItem)) {
            ItemStack stack = player.m_21205_();
            if (stack.m_41720_() instanceof TravelersCompassItem && clickType == ClickType.QUICK_MOVE) {
                int[] newArray;
                int[] array = CompassProperties.get(stack, CompassProperties.PRIORITY_SLOTS);
                boolean contains = false;
                for (int i2 : array) {
                    if (i2 != slotIndex) continue;
                    contains = true;
                    break;
                }
                if (contains) {
                    newArray = Arrays.stream(array).filter(i -> i != slotIndex).toArray();
                } else {
                    newArray = Arrays.copyOf(array, array.length + 1);
                    newArray[newArray.length - 1] = slotIndex;
                }
                if (player.m_9236_().f_46443_) {
                    player.m_5496_((SoundEvent)SoundEvents.f_12490_.m_203334_(), 1.0f, 1.0f);
                }
                CompassProperties.PRIORITY_SLOTS.put(stack, newArray);
                if (!this.m_38853_(slotIndex).m_7993_().m_150930_(Items.f_41852_)) {
                    SearchManager.updateSlotPriority(CompassProperties.get(stack, CompassProperties.COMPASS_UUID), slotIndex, !contains);
                }
            } else {
                ItemStack carried = this.m_142621_().m_41777_();
                if (carried.m_41619_() || carried.m_150930_((Item)ItemRegistry.TRAVELERS_COMPASS.get())) {
                    ((Slot)this.f_38839_.get(slotIndex)).m_5852_(ItemStack.f_41583_);
                } else {
                    carried.m_41764_(1);
                    if (this.mayPlaceToSlot(player, carried)) {
                        CompassContainer container = (CompassContainer)((Slot)this.f_38839_.get((int)slotIndex)).f_40218_;
                        container.setItem(slotIndex, carried, player);
                    }
                }
                ((Slot)this.f_38839_.get(slotIndex)).m_6654_();
                return;
            }
        }
        super.m_150399_(slotIndex, dragType, clickType, player);
    }

    public boolean mayPlaceToSlot(Player player, ItemStack stack) {
        for (int i = 0; i < 9; ++i) {
            if (!((Slot)this.f_38839_.get(i)).m_7993_().m_150930_(stack.m_41720_())) continue;
            return false;
        }
        return true;
    }

    public boolean m_6875_(Player player) {
        return player.m_21205_().m_41720_().equals(ItemRegistry.TRAVELERS_COMPASS.get());
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        ItemStack stack = player.m_21205_();
        if (stack.m_41720_() instanceof TravelersCompassItem && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            SearchManager.removeWatcher(CompassProperties.COMPASS_UUID.get(stack), serverPlayer);
        }
    }
}

