/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.hud;

import com.nine.travelerscompass.client.ClientData;
import com.nine.travelerscompass.client.hud.HudData;
import com.nine.travelerscompass.client.hud.HudSettings;
import com.nine.travelerscompass.client.hud.type.IHudTypeRenderer;
import com.nine.travelerscompass.common.data.CompassProperties;
import com.nine.travelerscompass.common.utils.HudRenderMode;
import com.nine.travelerscompass.config.TCConfig;
import com.nine.travelerscompass.init.ItemRegistry;
import java.util.HashSet;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class HudRenderer {
    public static final ResourceLocation TEXTURE = new ResourceLocation("travelerscompass", "textures/gui/gui_components.png");
    public static final ResourceLocation EDGES_TEXTURE = new ResourceLocation("travelerscompass", "textures/gui/hud_edges.png");
    private static final int EDGE_PADDING = 7;
    private static final int HEIGHT_PADDING = 2;
    private static final int WIDTH_PADDING = 2;
    static final Minecraft minecraft = Minecraft.m_91087_();
    private static int renderTicksCount = 0;

    public static void renderTick(GuiGraphics graphics, float partialTicks) {
        LocalPlayer player = HudRenderer.minecraft.f_91074_;
        if (player != null) {
            if (player.f_19797_ % 100 == 0) {
                HashSet<UUID> validUUIDs = new HashSet<UUID>();
                for (ItemStack stack : player.m_150109_().f_35974_) {
                    if (!stack.m_150930_((Item)ItemRegistry.TRAVELERS_COMPASS.get())) continue;
                    UUID uuid2 = CompassProperties.get(stack, CompassProperties.COMPASS_UUID);
                    validUUIDs.add(uuid2);
                }
                ClientData.HUD_DATA_CACHE.keySet().removeIf(uuid -> !validUUIDs.contains(uuid));
            }
            if (!HudRenderer.shouldShow()) {
                return;
            }
            Font font = HudRenderer.minecraft.f_91062_;
            for (HudData hudData : ClientData.HUD_DATA_CACHE.values()) {
                HudSettings settings = hudData.getSettings();
                if (settings.renderMode() == HudRenderMode.OFF || settings.renderMode() == HudRenderMode.HAND_ONLY && !hudData.isSelected() || HudRenderer.minecraft.f_91080_ instanceof ChatScreen && !settings.hudWithChat() || HudRenderer.minecraft.f_91080_ != null && !(HudRenderer.minecraft.f_91080_ instanceof ChatScreen)) continue;
                IHudTypeRenderer renderer = settings.hudType().renderer;
                graphics.m_280168_().m_85836_();
                graphics.m_280168_().m_85841_(settings.scale(), settings.scale(), 1.0f);
                renderer.render(graphics, (Player)player, font, hudData);
                graphics.m_280168_().m_85849_();
            }
        }
        if (player != null && renderTicksCount % 3000 == 0) {
            renderTicksCount = 0;
        }
    }

    public static void forceRender(GuiGraphics graphics, float partialTicks, UUID uuid) {
        if (ClientData.HUD_DATA_CACHE.containsKey(uuid)) {
            HudData hudData = ClientData.HUD_DATA_CACHE.get(uuid);
            HudSettings settings = hudData.getSettings();
            IHudTypeRenderer renderer = settings.hudType().renderer;
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_85841_(settings.scale(), settings.scale(), 1.0f);
            renderer.render(graphics, (Player)HudRenderer.minecraft.f_91074_, HudRenderer.minecraft.f_91062_, hudData);
            HudRenderer.drawEdges(graphics, settings.xPos(), settings.yPos(), settings.width(), settings.height(), partialTicks);
            graphics.m_280168_().m_85849_();
        }
    }

    private static boolean shouldShow() {
        return TCConfig.ENABLE_HUD.get() != false && HudRenderer.minecraft.f_91073_ != null && !HudRenderer.minecraft.f_91066_.f_92062_ && !HudRenderer.minecraft.f_91066_.f_92063_;
    }

    protected static void drawEdges(GuiGraphics graphics, int xPos, int yPos, int width, int height, float partialTicks) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        float pulse = 0.8f + 0.2f * Mth.m_14031_((float)((partialTicks + (float)player.f_19797_) * 0.1f));
        int padding = 7;
        graphics.m_280246_(1.0f, 1.0f, 1.0f, pulse);
        graphics.m_280163_(EDGES_TEXTURE, xPos, yPos, 0.0f, 0.0f, 7, 7, 14, 14);
        graphics.m_280163_(EDGES_TEXTURE, xPos + width - 7 + 4, yPos, 7.0f, 0.0f, 7, 7, 14, 14);
        graphics.m_280163_(EDGES_TEXTURE, xPos, yPos + height - 7 + 2, 0.0f, 7.0f, 7, 7, 14, 14);
        graphics.m_280163_(EDGES_TEXTURE, xPos + width - 7 + 4, yPos + height - 7 + 2, 7.0f, 7.0f, 7, 7, 14, 14);
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
    }
}

