/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.hud;

import com.nine.travelerscompass.client.hud.HudSettings;
import com.nine.travelerscompass.client.utils.ClientUtils;
import com.nine.travelerscompass.common.search.location.ILocationObject;
import com.nine.travelerscompass.common.utils.SearchState;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;

public class HudData {
    private ILocationObject locationObject;
    private boolean paused;
    private SearchState searchState;
    private boolean selected;
    public boolean dirty;
    private HudSettings settings;
    private Component targetName = Component.m_237119_();
    private Component state = Component.m_237115_((String)"hud.travelerscompass.compact.state.idle").m_130940_(ChatFormatting.GRAY);

    public HudData(HudSettings settings, boolean paused, boolean selected, SearchState searchState) {
        this.settings = settings;
        this.paused = paused;
        this.selected = selected;
        this.searchState = searchState;
    }

    public ILocationObject getLocationObject() {
        return this.locationObject;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public SearchState searchState() {
        return this.searchState;
    }

    public HudSettings getSettings() {
        return this.settings;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public void setSearchState(SearchState state) {
        this.searchState = state;
    }

    public void setLocationObject(ILocationObject newLocationObject) {
        if (!Objects.equals(this.locationObject, newLocationObject)) {
            this.locationObject = newLocationObject;
            this.markDirty();
        }
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
        this.markDirty();
    }

    public void updateSettings(HudSettings value) {
        if (!value.equals(this.settings)) {
            this.settings = value;
            this.markDirty();
        }
    }

    public Component getTargetName() {
        return this.targetName;
    }

    public void setTargetName(Component targetName) {
        this.targetName = targetName;
    }

    public Component getState() {
        return this.state;
    }

    public void setState(Component state) {
        this.state = state;
    }

    public void markDirty() {
        this.dirty = true;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void clearDirty() {
        this.dirty = false;
    }

    public void updateCachedData(Font font, int targetPrefLength) {
        if (this.locationObject == null) {
            this.targetName = Component.m_237119_();
        } else {
            Component formattedNameComponent = ClientUtils.getLocationObjectTargetName(this.locationObject);
            this.setTargetName(ClientUtils.cutComponent(font, formattedNameComponent, this.settings.width() - targetPrefLength));
        }
        this.state = this.locationObject != null ? Component.m_237115_((String)"hud.travelerscompass.compact.state.found").m_130940_(ChatFormatting.GRAY) : (this.searchState == SearchState.SEARCHING || this.searchState == SearchState.WIDE_SEARCHING ? Component.m_237115_((String)"hud.travelerscompass.compact.state.searching").m_130940_(ChatFormatting.GRAY) : (this.paused ? Component.m_237115_((String)"hud.travelerscompass.compact.state.pause").m_130940_(ChatFormatting.GRAY) : Component.m_237115_((String)"hud.travelerscompass.compact.state.idle").m_130940_(ChatFormatting.GRAY)));
    }
}

