/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.component.button;

import com.nine.travelerscompass.client.ClientData;
import com.nine.travelerscompass.client.component.button.BaseButton;
import com.nine.travelerscompass.client.utils.ClientUtils;
import com.nine.travelerscompass.common.container.CompassContainer;
import com.nine.travelerscompass.common.data.CompassProperties;
import com.nine.travelerscompass.common.utils.SearchState;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

public class WarningButton
extends BaseButton {
    public boolean hidden = false;
    private Warning warning;

    public WarningButton(int x, int y, int width, int height, ItemStack stack) {
        super(x, y, width, height);
        this.updateState(stack);
        this.refreshTooltip();
    }

    @Override
    protected void renderMainLayer(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.warning != Warning.NORMAL) {
            ClientUtils.renderTexture(graphics, ClientData.WARNING_SIGN, this.m_252754_(), this.m_252907_());
        }
    }

    public void updateState(ItemStack stack) {
        if (this.hidden) {
            return;
        }
        this.warning = CompassProperties.PAUSE.get(stack) != false && CompassProperties.SEARCH_STATE.get(stack) != SearchState.WIDE_SEARCHING ? Warning.PAUSED : (CompassContainer.container(stack).m_7983_() ? Warning.EMPTY : (CompassProperties.BLOCKS.get(stack) == false && CompassProperties.MOBS.get(stack) == false && CompassProperties.SPAWNERS.get(stack) == false && CompassProperties.INVENTORIES.get(stack) == false && CompassProperties.DROP.get(stack) == false && CompassProperties.VILLAGERS.get(stack) == false && CompassProperties.CONTAINERS.get(stack) == false && CompassProperties.FLUIDS.get(stack) == false && CompassProperties.ITEM_ENTITIES.get(stack) == false ? Warning.INACTIVE : Warning.NORMAL));
        this.refreshTooltip();
    }

    @Override
    public void refreshTooltip() {
        ArrayList<Component> components = new ArrayList<Component>();
        if (this.warning == Warning.NORMAL || this.hidden) {
            this.m_257544_(Tooltip.m_257550_((Component)Component.m_237119_()));
            return;
        }
        String key = "tooltip.travelerscompass.warning." + this.warning.name().toLowerCase();
        MutableComponent title = Component.m_237115_((String)key);
        MutableComponent desc = Component.m_237115_((String)(key + ".desc")).m_130940_(ChatFormatting.GRAY);
        components.add((Component)title);
        components.add((Component)desc);
        this.m_257544_(Tooltip.m_257550_((Component)ClientUtils.buildTooltip(components)));
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        super.m_6375_(mouseX, mouseY, button);
        return false;
    }

    public static enum Warning {
        PAUSED,
        EMPTY,
        INACTIVE,
        NORMAL;

    }
}

