/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.component.button;

import com.nine.travelerscompass.client.ClientData;
import com.nine.travelerscompass.client.component.button.ToggleButton;
import com.nine.travelerscompass.client.component.button.Toggleable;
import com.nine.travelerscompass.client.utils.ClientUtils;
import com.nine.travelerscompass.client.utils.IconTexture;
import com.nine.travelerscompass.client.utils.TextureData;
import com.nine.travelerscompass.common.data.CompassProperties;
import com.nine.travelerscompass.common.data.DataStorage;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

public class SearchModeButton
extends ToggleButton {
    private final DataStorage<Boolean> data;
    protected final IconTexture iconInactive;
    protected final IconTexture iconActive;
    private final ItemStack stack;
    private final boolean enabled;

    public SearchModeButton(int x, int y, int width, int height, boolean enabled, DataStorage<Boolean> data, IconTexture iconActive, IconTexture iconInactive, ItemStack stack) {
        super(x, y, width, height, ClientData.TOGGLE_BUTTON);
        this.data = data;
        this.stack = stack;
        this.iconActive = iconActive;
        this.iconInactive = iconInactive;
        this.enabled = enabled;
        this.f_93623_ = enabled;
        this.setToggled(data.get(stack));
        this.refreshTooltip();
    }

    public void m_5716_(double mouseX, double mouseY) {
        CompassProperties.toggleFromClient(this.stack, this.data);
        this.setToggled(this.data.get(this.stack));
        this.refreshTooltip();
    }

    @Override
    protected TextureData getBaseLayer() {
        return this.buttonTextures.get(this.toggled, this.f_93622_, this.enabled);
    }

    @Override
    public void refreshTooltip() {
        Component state;
        ArrayList<Component> list = new ArrayList<Component>();
        String key = "tooltip.travelerscompass.search_mode." + this.data.getKey();
        MutableComponent title = Component.m_237115_((String)key);
        list.add((Component)title);
        if (this.enabled) {
            Component component = state = this.isToggled() ? Toggleable.ENABLED : Toggleable.DISABLED;
            if (this.shiftPressed) {
                list.add((Component)Component.m_237119_().m_7220_(ClientUtils.DESC_ARROW).m_7220_((Component)Component.m_237115_((String)(key + ".desc")).m_130940_(ChatFormatting.GRAY)));
            }
        } else {
            state = Toggleable.CONFIG_DISABLED;
        }
        list.add(state);
        this.m_257544_(Tooltip.m_257550_((Component)ClientUtils.buildTooltip(list)));
    }

    @Override
    public void renderIcon(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        IconTexture icon = this.isToggled() ? this.iconActive : this.iconInactive;
        ClientUtils.renderTexture(graphics, icon, this.m_252754_(), this.m_252907_());
    }

    @Override
    public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.m_87963_(graphics, mouseX, mouseY, partialTicks);
        if (this.enabled) {
            this.renderIcon(graphics, mouseX, mouseY, partialTicks);
        } else {
            TextureData lock = ClientData.LOCK;
            ClientUtils.renderTexture(graphics, lock, this.m_252754_() + 3, this.m_252907_() + 2);
        }
    }
}

