/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.component.button;

import com.nine.travelerscompass.client.ClientData;
import com.nine.travelerscompass.client.component.button.BaseButton;
import com.nine.travelerscompass.client.utils.ClientUtils;
import com.nine.travelerscompass.client.utils.IconTexture;
import com.nine.travelerscompass.client.utils.RangeUtils;
import com.nine.travelerscompass.client.utils.TextureData;
import com.nine.travelerscompass.common.data.CompassProperties;
import com.nine.travelerscompass.common.data.DataStorage;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

public class RangeButton<T extends Number>
extends BaseButton
implements RangeUtils.RangeButtonHandler<T> {
    private final IconTexture PLUS = new IconTexture(ClientData.PLUS, 3, 3);
    private final IconTexture PLUS_INACTIVE = new IconTexture(ClientData.PLUS_INACTIVE, 3, 3);
    private final IconTexture PLUS_CTRL = new IconTexture(ClientData.PLUS_HOVERED, 3, 3);
    private final IconTexture MINUS = new IconTexture(ClientData.MINUS, 3, 3);
    private final IconTexture MINUS_INACTIVE = new IconTexture(ClientData.MINUS_INACTIVE, 3, 3);
    private final IconTexture MINUS_CTRL = new IconTexture(ClientData.MINUS_HOVERED, 3, 3);
    private final IconTexture icon;
    private final Supplier<ItemStack> supplier;
    private final DataStorage<T> data;
    private final T min;
    private final T max;
    private final RangeUtils.RangeAdapter<T> adapter;
    private T cached;

    public RangeButton(int x, int y, int width, int height, T minValue, T maxValue, RangeUtils.RangeAdapter<T> adapter, IconTexture textureData, DataStorage<T> data, Supplier<ItemStack> supplier) {
        super(x, y, width, height);
        this.data = data;
        this.supplier = supplier;
        this.min = minValue;
        this.max = maxValue;
        this.adapter = adapter;
        this.icon = textureData;
        this.updateState();
    }

    @Override
    public T current() {
        return this.cached;
    }

    @Override
    public void set(T value) {
        CompassProperties.putFromClient(this.supplier.get(), this.data, value);
    }

    @Override
    public T min() {
        return this.min;
    }

    @Override
    public T max() {
        return this.max;
    }

    @Override
    public RangeUtils.RangeAdapter<T> adapter() {
        return this.adapter;
    }

    public void m_5716_(double mouseX, double mouseY) {
        boolean changed = RangeUtils.changeValue(this, this.shiftPressed, this.ctrlPressed);
        if (changed) {
            this.updateState();
        }
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        boolean changed = RangeUtils.changeValue(this, delta < 0.0, this.ctrlPressed);
        if (changed) {
            this.updateState();
        }
        return changed && super.m_6050_(mouseX, mouseY, delta);
    }

    public void updateState() {
        ItemStack stack = this.supplier.get();
        this.cached = (Number)this.data.get(stack);
        this.refreshTooltip();
    }

    public void renderIcon(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks, boolean outOfBounds) {
        IconTexture result;
        int xOff = 2;
        if (this.f_93622_) {
            result = this.shiftPressed ? (outOfBounds ? this.MINUS_INACTIVE : (this.ctrlPressed ? this.MINUS_CTRL : this.MINUS)) : (outOfBounds ? this.PLUS_INACTIVE : (this.ctrlPressed ? this.PLUS_CTRL : this.PLUS));
            xOff = 3;
        } else {
            result = this.icon;
        }
        ClientUtils.renderTexture(graphics, result, this.m_252754_(), this.m_252907_());
    }

    @Override
    public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.m_87963_(graphics, mouseX, mouseY, partialTicks);
        boolean outOfBounds = RangeUtils.isOutOfBounds(this, this.adapter().add(this.cached, (this.ctrlPressed ? 5 : 1) * (this.shiftPressed ? -1 : 1)));
        TextureData baseLayer = ClientData.TOGGLE_BUTTON.get(false, this.m_274382_(), !outOfBounds || !this.f_93622_);
        ClientUtils.renderTexture(graphics, baseLayer, this.m_252754_(), this.m_252907_());
        this.renderIcon(graphics, mouseX, mouseY, partialTicks, outOfBounds);
    }

    @Override
    public void refreshTooltip() {
        ArrayList<Component> components = new ArrayList<Component>();
        components.add((Component)Component.m_237115_((String)("tooltip.travelerscompass.settings." + this.data.getKey())).m_130940_(ChatFormatting.WHITE));
        MutableComponent shift = ClientUtils.coloredComponent(Component.m_237115_((String)"tooltip.travelerscompass.settings.modification.shift"), this.shiftPressed ? 0xAAAAAA : 0xC8C8C8);
        MutableComponent ctrl = ClientUtils.coloredComponent(Component.m_237115_((String)"tooltip.travelerscompass.settings.modification.ctrl"), this.ctrlPressed ? 0xAAAAAA : 0xC8C8C8);
        components.add((Component)Component.m_237110_((String)"tooltip.travelerscompass.settings.modification.hold_to_decrease", (Object[])new Object[]{shift}).m_130940_(ChatFormatting.GRAY));
        components.add((Component)Component.m_237110_((String)"tooltip.travelerscompass.settings.modification.hold_to_change_faster", (Object[])new Object[]{ctrl}).m_130940_(ChatFormatting.GRAY));
        if (this.shiftPressed) {
            MutableComponent desc = Component.m_237119_().m_7220_(ClientUtils.DESC_ARROW).m_7220_((Component)Component.m_237115_((String)("tooltip.travelerscompass.settings." + this.data.getKey() + ".desc")).m_130940_(ChatFormatting.GRAY));
            components.add((Component)desc);
        }
        MutableComponent value = Component.m_237113_((String)String.valueOf(this.cached));
        ClientUtils.setColor(value, 0xC8C8C8);
        components.add((Component)Component.m_237110_((String)("tooltip.travelerscompass.settings." + this.data.getKey() + ".value"), (Object[])new Object[]{value}).m_130940_(ChatFormatting.GRAY));
        this.m_257544_(Tooltip.m_257550_((Component)ClientUtils.buildTooltip(components)));
    }
}

