/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.component.button;

import com.nine.travelerscompass.client.ClientData;
import com.nine.travelerscompass.client.component.button.PopupButton;
import com.nine.travelerscompass.client.component.button.Toggleable;
import com.nine.travelerscompass.client.component.element.NewPopupElement;
import com.nine.travelerscompass.client.component.element.NewRangePopupElement;
import com.nine.travelerscompass.client.hud.HudRenderer;
import com.nine.travelerscompass.client.hud.HudSettings;
import com.nine.travelerscompass.client.utils.ClientUtils;
import com.nine.travelerscompass.client.utils.IconTexture;
import com.nine.travelerscompass.client.utils.RangeUtils;
import com.nine.travelerscompass.client.utils.TextureData;
import com.nine.travelerscompass.common.data.CompassProperties;
import com.nine.travelerscompass.common.data.DataStorage;
import com.nine.travelerscompass.common.utils.Alignment;
import com.nine.travelerscompass.common.utils.HudRenderMode;
import com.nine.travelerscompass.common.utils.HudType;
import com.nine.travelerscompass.config.TCConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

public class HudButton
extends PopupButton {
    public static final Component HUD_ENABLED = Component.m_237115_((String)"tooltip.travelerscompass.settings.hud.enabled").m_130940_(ChatFormatting.GRAY);
    public static final Component HUD_REQUIRES_HAND = Component.m_237115_((String)"tooltip.travelerscompass.settings.hud.requires_hand").m_130940_(ChatFormatting.GRAY);
    private final Supplier<ItemStack> supplier;
    private final DataStorage<HudRenderMode> data = CompassProperties.HUD_RENDER_MODE;
    private HudRenderMode cachedRenderMode;
    private final UUID uuid;

    public HudButton(int x, int y, final Supplier<ItemStack> supplier) {
        super(x, y, 14, 14, ClientData.CONNECTOR_VERTICAL, ClientData.POPUP_3X3, new Rect2i(0, 0, 13, 13), new Rect2i(0, 0, 42, 40));
        this.supplier = supplier;
        ItemStack stack = supplier.get();
        this.uuid = CompassProperties.get(stack, CompassProperties.COMPASS_UUID);
        this.cachedRenderMode = CompassProperties.get(stack, CompassProperties.HUD_RENDER_MODE);
        HudType hudType = CompassProperties.HUD_TYPE.get(stack);
        final NewRangePopupElement<Integer> widthElement = new NewRangePopupElement<Integer>(9, 9, Integer.valueOf(hudType.minWidth()), Integer.valueOf(hudType.maxWidth()), Integer.valueOf(1), Integer.valueOf(5), RangeUtils.INTEGER, new IconTexture(ClientData.HUD_WIDTH, 2, 2), CompassProperties.HUD_WIDTH, supplier){
            private HudType cachedType;

            @Override
            public void updateState() {
                super.updateState();
                this.cachedType = CompassProperties.HUD_TYPE.get((ItemStack)supplier.get());
                ClientData.HUD_DATA_CACHE.computeIfPresent(HudButton.this.uuid, (id, hudData) -> {
                    HudSettings settings = hudData.getSettings();
                    hudData.updateSettings(settings.toBuilder().width((Integer)this.cached).build());
                    return hudData;
                });
            }

            @Override
            public Integer max() {
                return this.cachedType.maxWidth();
            }

            @Override
            public Integer min() {
                return this.cachedType.minWidth();
            }

            @Override
            public void set(Integer value) {
                super.set(value);
            }
        };
        final NewRangePopupElement<Integer> heightElement = new NewRangePopupElement<Integer>(9, 9, Integer.valueOf(hudType.minHeight()), Integer.valueOf(hudType.maxHeight()), Integer.valueOf(1), Integer.valueOf(5), RangeUtils.INTEGER, new IconTexture(ClientData.HUD_HEIGHT, 3, 2), CompassProperties.HUD_HEIGHT, supplier){
            private HudType cachedType;

            @Override
            public void updateState() {
                super.updateState();
                this.cachedType = CompassProperties.HUD_TYPE.get((ItemStack)supplier.get());
                ClientData.HUD_DATA_CACHE.computeIfPresent(HudButton.this.uuid, (id, hudData) -> {
                    HudSettings settings = hudData.getSettings();
                    hudData.updateSettings(settings.toBuilder().height((Integer)this.cached).build());
                    return hudData;
                });
            }

            @Override
            public Integer max() {
                return this.cachedType.maxHeight();
            }

            @Override
            public Integer min() {
                return this.cachedType.minHeight();
            }

            @Override
            public void set(Integer value) {
                super.set(value);
            }
        };
        NewRangePopupElement<Float> scaleElement = new NewRangePopupElement<Float>(9, 9, Float.valueOf(0.2f), Float.valueOf(3.0f), Float.valueOf(0.01f), Float.valueOf(0.1f), RangeUtils.FLOAT, new IconTexture(ClientData.HUD_SCALE, 2, 2), CompassProperties.HUD_SCALE, supplier){

            @Override
            public void updateState() {
                super.updateState();
                ClientData.HUD_DATA_CACHE.computeIfPresent(HudButton.this.uuid, (id, hudData) -> {
                    HudSettings settings = hudData.getSettings();
                    hudData.updateSettings(settings.toBuilder().scale(((Float)this.cached).floatValue()).build());
                    return hudData;
                });
            }

            @Override
            public void set(Float value) {
                super.set(value);
            }
        };
        NewRangePopupElement<Integer> xPosElement = new NewRangePopupElement<Integer>(9, 9, Integer.valueOf(0), Integer.valueOf(-1), Integer.valueOf(1), Integer.valueOf(10), RangeUtils.INTEGER, new IconTexture(ClientData.HUD_X_POS, 2, 2), CompassProperties.HUD_X_POS, supplier){

            @Override
            public void updateState() {
                super.updateState();
                ClientData.HUD_DATA_CACHE.computeIfPresent(HudButton.this.uuid, (id, hudData) -> {
                    HudSettings settings = hudData.getSettings();
                    hudData.updateSettings(settings.toBuilder().xPos((Integer)this.cached).build());
                    return hudData;
                });
            }

            @Override
            public void refreshTooltip() {
                this.setTooltip(HudButton.this.getHudAxisPosTooltip((ItemStack)supplier.get(), (Integer)this.cached, "x"));
            }

            @Override
            public void set(Integer value) {
                super.set(value);
            }

            @Override
            public Integer max() {
                return Minecraft.m_91087_().m_91268_().m_85445_() - 4;
            }
        };
        NewRangePopupElement<Integer> yPosElement = new NewRangePopupElement<Integer>(9, 9, Integer.valueOf(0), Integer.valueOf(-1), Integer.valueOf(1), Integer.valueOf(10), RangeUtils.INTEGER, new IconTexture(ClientData.HUD_Y_POS, 2, 2), CompassProperties.HUD_Y_POS, supplier){

            @Override
            public void updateState() {
                super.updateState();
                ClientData.HUD_DATA_CACHE.computeIfPresent(HudButton.this.uuid, (id, hudData) -> {
                    HudSettings settings = hudData.getSettings();
                    hudData.updateSettings(settings.toBuilder().yPos((Integer)this.cached).build());
                    return hudData;
                });
            }

            @Override
            public void refreshTooltip() {
                this.setTooltip(HudButton.this.getHudAxisPosTooltip((ItemStack)supplier.get(), (Integer)this.cached, "y"));
            }

            @Override
            public void set(Integer value) {
                super.set(value);
            }

            @Override
            public Integer max() {
                return Minecraft.m_91087_().m_91268_().m_85446_() - 4;
            }
        };
        NewPopupElement hudTypeElement = new NewPopupElement(9, 9){
            private HudType cached;
            {
                super(width, height);
                this.updateState();
            }

            @Override
            public void updateState() {
                this.cached = CompassProperties.HUD_TYPE.get((ItemStack)supplier.get());
                this.refreshTooltip();
                ClientData.HUD_DATA_CACHE.computeIfPresent(HudButton.this.uuid, (id, hudData) -> {
                    hudData.updateSettings(hudData.getSettings().toBuilder().hudType(this.cached).build());
                    return hudData;
                });
            }

            @Override
            public void renderElement(GuiGraphics graphics, int xPos, int yPos) {
                TextureData baseLayer = ClientData.SMALL_TOGGLE_BUTTON.get(false, this.isHovered, true);
                IconTexture iconTexture = switch (this.cached) {
                    default -> throw new IncompatibleClassChangeError();
                    case HudType.EXTENDED -> {
                        if (this.isHovered) {
                            yield ClientData.HUD_TYPE_EXTENDED_HOVERED.icon(2, 2);
                        }
                        yield ClientData.HUD_TYPE_EXTENDED.icon(2, 2);
                    }
                    case HudType.COMPACT -> this.isHovered ? ClientData.HUD_TYPE_COMPACT_HOVERED.icon(2, 2) : ClientData.HUD_TYPE_COMPACT.icon(2, 2);
                };
                ClientUtils.renderTexture(graphics, baseLayer, xPos, yPos);
                ClientUtils.renderTexture(graphics, iconTexture, xPos, yPos);
            }

            @Override
            public void onClick(int button) {
                CompassProperties.toggleFromClient((ItemStack)supplier.get(), CompassProperties.HUD_TYPE, button == 1);
                this.updateState();
                widthElement.updateState();
                heightElement.updateState();
            }

            @Override
            public void refreshTooltip() {
                ArrayList<Component> ret = new ArrayList<Component>();
                String key = "tooltip.travelerscompass.settings.hud.type";
                MutableComponent title = Component.m_237115_((String)key);
                MutableComponent state = Component.m_237115_((String)(key + "." + this.cached.name().toLowerCase())).m_130940_(ChatFormatting.GRAY);
                ret.add((Component)title);
                if (this.shiftPressed) {
                    ret.add((Component)ClientUtils.DESC_ARROW.m_6881_().m_7220_((Component)Component.m_237115_((String)(key + ".desc")).m_130940_(ChatFormatting.GRAY)));
                }
                ret.add((Component)state);
                this.setTooltip(ret);
            }
        };
        NewPopupElement hucChatElement = new NewPopupElement(9, 9){
            private boolean cached;
            {
                super(width, height);
                this.updateState();
            }

            @Override
            public void updateState() {
                this.cached = CompassProperties.HUD_WITH_CHAT.get((ItemStack)supplier.get());
                this.refreshTooltip();
                ClientData.HUD_DATA_CACHE.computeIfPresent(HudButton.this.uuid, (id, hudData) -> {
                    hudData.updateSettings(hudData.getSettings().toBuilder().hudWithChat(this.cached).build());
                    return hudData;
                });
            }

            @Override
            public void renderElement(GuiGraphics graphics, int xPos, int yPos) {
                TextureData baseLayer = ClientData.SMALL_TOGGLE_BUTTON.get(false, this.isHovered, true);
                IconTexture iconTexture = this.cached ? (this.isHovered ? ClientData.HUD_CHAT_ACTIVE_HOVERED.icon(1, 1) : ClientData.HUD_CHAT_ACTIVE.icon(1, 1)) : (this.isHovered ? ClientData.HUD_CHAT_INACTIVE_HOVERED.icon(1, 1) : ClientData.HUD_CHAT_INACTIVE.icon(1, 1));
                ClientUtils.renderTexture(graphics, baseLayer, xPos, yPos);
                ClientUtils.renderTexture(graphics, iconTexture, xPos, yPos);
            }

            @Override
            public void onClick(int button) {
                CompassProperties.toggleFromClient((ItemStack)supplier.get(), CompassProperties.HUD_WITH_CHAT, button == 1);
                this.updateState();
            }

            @Override
            public void refreshTooltip() {
                ArrayList<Component> ret = new ArrayList<Component>();
                String key = "tooltip.travelerscompass.settings.hud_with_chat";
                MutableComponent title = Component.m_237115_((String)key);
                Component state = this.cached ? Toggleable.ENABLED : Toggleable.DISABLED;
                ret.add((Component)title);
                if (this.shiftPressed) {
                    ret.add((Component)ClientUtils.DESC_ARROW.m_6881_().m_7220_((Component)Component.m_237115_((String)(key + ".desc")).m_130940_(ChatFormatting.GRAY)));
                }
                ret.add(state);
                this.setTooltip(ret);
            }
        };
        NewPopupElement hudAlignmentButton = new NewPopupElement(9, 9){
            private Alignment cached;
            {
                super(width, height);
                this.updateState();
            }

            @Override
            public void updateState() {
                this.cached = CompassProperties.HUD_ALIGNMENT.get((ItemStack)supplier.get());
                this.refreshTooltip();
                ClientData.HUD_DATA_CACHE.computeIfPresent(HudButton.this.uuid, (id, hudData) -> {
                    hudData.updateSettings(hudData.getSettings().toBuilder().alignment(this.cached).build());
                    return hudData;
                });
            }

            @Override
            public void renderElement(GuiGraphics graphics, int xPos, int yPos) {
                TextureData baseLayer = ClientData.SMALL_TOGGLE_BUTTON.get(false, this.isHovered, true);
                IconTexture iconTexture = switch (this.cached) {
                    default -> throw new IncompatibleClassChangeError();
                    case Alignment.CENTER -> {
                        if (this.isHovered) {
                            yield ClientData.HUD_ALIGNMENT_CENTER_HOVERED.icon(3, 1);
                        }
                        yield ClientData.HUD_ALIGNMENT_CENTER.icon(3, 1);
                    }
                    case Alignment.LEFT -> {
                        if (this.isHovered) {
                            yield ClientData.HUD_ALIGNMENT_LEFT_HOVERED.icon(1, 1);
                        }
                        yield ClientData.HUD_ALIGNMENT_LEFT.icon(1, 1);
                    }
                    case Alignment.RIGHT -> this.isHovered ? ClientData.HUD_ALIGNMENT_RIGHT_HOVERED.icon(5, 1) : ClientData.HUD_ALIGNMENT_RIGHT.icon(5, 1);
                };
                ClientUtils.renderTexture(graphics, baseLayer, xPos, yPos);
                ClientUtils.renderTexture(graphics, iconTexture, xPos, yPos);
            }

            @Override
            public void onClick(int button) {
                CompassProperties.toggleFromClient((ItemStack)supplier.get(), CompassProperties.HUD_ALIGNMENT, button == 1);
                this.updateState();
            }

            @Override
            public void refreshTooltip() {
                ArrayList<Component> ret = new ArrayList<Component>();
                String key = "tooltip.travelerscompass.settings.hud.alignment";
                MutableComponent title = Component.m_237115_((String)key);
                MutableComponent state = Component.m_237115_((String)(key + "." + this.cached.name().toLowerCase())).m_130940_(ChatFormatting.GRAY);
                ret.add((Component)title);
                if (this.shiftPressed) {
                    ArrayList<MutableComponent> alignedList = new ArrayList<MutableComponent>();
                    for (Alignment alignment : Alignment.values()) {
                        MutableComponent alignComponent = Component.m_237115_((String)(key + "." + alignment.name().toLowerCase()));
                        if (alignment == this.cached) {
                            ClientUtils.setColor(alignComponent, 0xC8C8C8);
                        } else {
                            alignComponent = alignComponent.m_130940_(ChatFormatting.GRAY);
                        }
                        alignedList.add(alignComponent);
                    }
                    MutableComponent aligns = Component.m_237119_();
                    for (int i = 0; i < alignedList.size(); ++i) {
                        aligns.m_7220_((Component)alignedList.get(i));
                        if (i >= alignedList.size() - 1) continue;
                        aligns.m_7220_((Component)Component.m_237113_((String)"/"));
                    }
                    MutableComponent desc = ClientUtils.DESC_ARROW.m_6881_().m_7220_((Component)Component.m_237110_((String)"tooltip.travelerscompass.settings.hud.alignment.desc", (Object[])new Object[]{aligns}).m_130940_(ChatFormatting.GRAY));
                    ret.add((Component)desc);
                }
                ret.add((Component)state);
                this.setTooltip(ret);
            }
        };
        NewPopupElement resetElement = new NewPopupElement(9, 9){

            @Override
            public void onClick(int button) {
                HudButton.this.resetSettings((ItemStack)supplier.get());
            }

            @Override
            public void renderElement(GuiGraphics graphics, int xPos, int yPos) {
                TextureData baseLayer = ClientData.SMALL_TOGGLE_BUTTON.get(false, this.isHovered, true);
                IconTexture iconTexture = this.isHovered ? ClientData.HUD_RESET_HOVERED.icon(3, 2) : ClientData.HUD_RESET.icon(3, 2);
                ClientUtils.renderTexture(graphics, baseLayer, xPos, yPos);
                ClientUtils.renderTexture(graphics, iconTexture, xPos, yPos);
            }

            @Override
            public void refreshTooltip() {
                ArrayList<Component> ret = new ArrayList<Component>();
                String key = "tooltip.travelerscompass.settings.hud.reset";
                MutableComponent title = Component.m_237115_((String)key);
                ret.add((Component)title);
                if (this.shiftPressed) {
                    ret.add((Component)ClientUtils.DESC_ARROW.m_6881_().m_7220_((Component)Component.m_237115_((String)(key + ".desc")).m_130940_(ChatFormatting.GRAY)));
                }
                this.setTooltip(ret);
            }
        };
        widthElement.init(-37, 2);
        heightElement.init(-26, 2);
        scaleElement.init(-37, 13);
        xPosElement.init(-37, -9);
        yPosElement.init(-26, -9);
        hudAlignmentButton.init(-15, -9);
        hudTypeElement.init(-15, 2);
        resetElement.init(-15, 13);
        hucChatElement.init(-26, 13);
        this.popupElements.add(widthElement);
        this.popupElements.add(heightElement);
        this.popupElements.add(scaleElement);
        this.popupElements.add(xPosElement);
        this.popupElements.add(yPosElement);
        this.popupElements.add(hudAlignmentButton);
        this.popupElements.add(resetElement);
        this.popupElements.add(hudTypeElement);
        this.popupElements.add(hucChatElement);
        this.updateState();
    }

    private List<Component> getHudAxisPosTooltip(ItemStack stack, int pos, String axis) {
        ArrayList<Component> components = new ArrayList<Component>();
        MutableComponent title = Component.m_237115_((String)("tooltip.travelerscompass.settings.hud.position." + axis)).m_130940_(ChatFormatting.WHITE);
        MutableComponent value = Component.m_237113_((String)String.valueOf(pos));
        ClientUtils.setColor(value, 0xC8C8C8);
        MutableComponent offset = Component.m_237110_((String)"tooltip.travelerscompass.settings.hud.position.value", (Object[])new Object[]{value}).m_130940_(ChatFormatting.GRAY);
        MutableComponent shift = ClientUtils.coloredComponent(Component.m_237115_((String)"tooltip.travelerscompass.settings.modification.shift"), this.shiftPressed ? 0xAAAAAA : 0xC8C8C8);
        MutableComponent ctrl = ClientUtils.coloredComponent(Component.m_237115_((String)"tooltip.travelerscompass.settings.modification.ctrl"), this.ctrlPressed ? 0xAAAAAA : 0xC8C8C8);
        components.add((Component)title);
        components.add((Component)Component.m_237110_((String)"tooltip.travelerscompass.settings.modification.hold_to_decrease", (Object[])new Object[]{shift}).m_130940_(ChatFormatting.GRAY));
        components.add((Component)Component.m_237110_((String)"tooltip.travelerscompass.settings.modification.hold_to_change_faster", (Object[])new Object[]{ctrl}).m_130940_(ChatFormatting.GRAY));
        if (this.shiftPressed) {
            String alignmentString = CompassProperties.get(stack, CompassProperties.HUD_ALIGNMENT).toString().toLowerCase();
            MutableComponent alignment = ClientUtils.coloredComponent(Component.m_237115_((String)("tooltip.travelerscompass.settings.hud.position.alignment." + alignmentString)), 0xC8C8C8);
            MutableComponent axisComponent = ClientUtils.coloredComponent(Component.m_237113_((String)axis.toUpperCase()), 0xC8C8C8);
            MutableComponent desc = ClientUtils.coloredComponent(Component.m_237113_((String)"\u25b6"), 0xC8C8C8).m_7220_((Component)Component.m_237110_((String)"tooltip.travelerscompass.settings.hud.position.desc", (Object[])new Object[]{axisComponent, alignment}).m_130940_(ChatFormatting.GRAY));
            components.add((Component)desc);
        }
        components.add((Component)offset);
        return components;
    }

    public void resetSettings(ItemStack stack) {
        CompassProperties.writeDefaultFromClient(stack, CompassProperties.HUD_X_POS);
        CompassProperties.writeDefaultFromClient(stack, CompassProperties.HUD_Y_POS);
        CompassProperties.writeDefaultFromClient(stack, CompassProperties.HUD_SCALE);
        CompassProperties.writeDefaultFromClient(stack, CompassProperties.HUD_ALIGNMENT);
        CompassProperties.writeDefaultFromClient(stack, CompassProperties.HUD_WITH_CHAT);
        for (HudType hudType : HudType.values()) {
            CompassProperties.putFromClient(stack, CompassProperties.HUD_TYPE, hudType);
            CompassProperties.writeDefaultFromClient(stack, CompassProperties.HUD_WIDTH);
            CompassProperties.writeDefaultFromClient(stack, CompassProperties.HUD_HEIGHT);
        }
        CompassProperties.writeDefaultFromClient(stack, CompassProperties.HUD_TYPE);
        for (NewPopupElement el : this.popupElements) {
            el.updateState();
        }
    }

    public void updateState() {
        ItemStack stack = this.supplier.get();
        this.cachedRenderMode = this.data.get(stack);
        this.refreshTooltip();
        ClientData.HUD_DATA_CACHE.computeIfPresent(this.uuid, (id, hudData) -> {
            hudData.updateSettings(hudData.getSettings().toBuilder().renderMode(this.cachedRenderMode).build());
            return hudData;
        });
    }

    @Override
    protected boolean isEnabled() {
        return TCConfig.ENABLE_HUD.get();
    }

    @Override
    protected int getPopupXOffset() {
        return -41;
    }

    @Override
    protected int getPopupYOffset() {
        return -13;
    }

    @Override
    protected int getConnectorXOffset() {
        return -1;
    }

    @Override
    protected int getConnectorYOffset() {
        return 1;
    }

    @Override
    protected boolean isPopupVisible() {
        return super.isPopupVisible() && this.isEnabled() && this.cachedRenderMode != HudRenderMode.OFF;
    }

    @Override
    protected void onMainButtonClick(int button) {
        ItemStack stack = this.supplier.get();
        CompassProperties.toggleFromClient(stack, this.data, true);
        this.updateState();
    }

    @Override
    protected void renderMainLayer(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        TextureData baseLayer = ClientData.TOGGLE_BUTTON.get(false, this.f_93622_, this.isEnabled());
        ClientUtils.renderTexture(graphics, baseLayer, this.m_252754_(), this.m_252907_());
    }

    @Override
    protected void renderIcon(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.isEnabled()) {
            IconTexture iconTexture = switch (this.cachedRenderMode) {
                default -> throw new IncompatibleClassChangeError();
                case HudRenderMode.OFF -> {
                    if (this.m_274382_()) {
                        yield new IconTexture(ClientData.HUD_OFF_HOVERED, 2, 2);
                    }
                    yield new IconTexture(ClientData.HUD_OFF, 2, 2);
                }
                case HudRenderMode.ALWAYS -> {
                    if (this.m_274382_()) {
                        yield new IconTexture(ClientData.HUD_ALWAYS_HOVERED, 2, 2);
                    }
                    yield new IconTexture(ClientData.HUD_ALWAYS, 2, 2);
                }
                case HudRenderMode.HAND_ONLY -> this.m_274382_() ? new IconTexture(ClientData.HUD_HAND_HOVERED, 2, 2) : new IconTexture(ClientData.HUD_HAND, 2, 2);
            };
            ClientUtils.renderTexture(graphics, iconTexture, this.m_252754_(), this.m_252907_());
            if (this.isPopupVisible()) {
                HudRenderer.forceRender(graphics, partialTicks, this.uuid);
            }
        } else {
            ClientUtils.renderTexture(graphics, new IconTexture(ClientData.LOCK, 3, 2), this.m_252754_(), this.m_252907_());
        }
    }

    @Override
    public void refreshTooltip() {
        Component state;
        String key = "tooltip.travelerscompass.settings.hud";
        MutableComponent title = Component.m_237115_((String)key);
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)title);
        if (this.isEnabled()) {
            switch (this.cachedRenderMode) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case OFF: {
                    Component component = Toggleable.DISABLED;
                    break;
                }
                case HAND_ONLY: {
                    Component component = HUD_REQUIRES_HAND;
                    break;
                }
                case ALWAYS: {
                    Component component = state = HUD_ENABLED;
                }
            }
            if (this.shiftPressed) {
                list.add((Component)Component.m_237119_().m_7220_(ClientUtils.DESC_ARROW).m_7220_((Component)Component.m_237115_((String)(key + ".desc")).m_130940_(ChatFormatting.GRAY)));
            }
        } else {
            state = Toggleable.CONFIG_DISABLED;
        }
        list.add(state);
        this.m_257544_(Tooltip.m_257550_((Component)ClientUtils.buildTooltip(list)));
    }
}

