/*
 * Decompiled with CFR 0.152.
 */
package cyberspace.network;

import cyberspace.CyberspaceMod;
import cyberspace.procedures.BackArrowButtonProcedureProcedure;
import cyberspace.procedures.FeatherfallUpgradeButtonProcedure;
import cyberspace.procedures.NourishedUpgradeButtonProcedure;
import cyberspace.procedures.SkyboundUpgradeButtonProcedure;
import cyberspace.procedures.SpeedUpgradeButtonProcedure;
import cyberspace.world.inventory.CyberspaceUpgradeGuiMenu;
import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class CyberspaceUpgradeGuiButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public CyberspaceUpgradeGuiButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public CyberspaceUpgradeGuiButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(CyberspaceUpgradeGuiButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(CyberspaceUpgradeGuiButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            CyberspaceUpgradeGuiButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = CyberspaceUpgradeGuiMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            FeatherfallUpgradeButtonProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            SkyboundUpgradeButtonProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            NourishedUpgradeButtonProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            SpeedUpgradeButtonProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            BackArrowButtonProcedureProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        CyberspaceMod.addNetworkMessage(CyberspaceUpgradeGuiButtonMessage.class, CyberspaceUpgradeGuiButtonMessage::buffer, CyberspaceUpgradeGuiButtonMessage::new, CyberspaceUpgradeGuiButtonMessage::handler);
    }
}

