/*
 * Decompiled with CFR 0.152.
 */
package cyberspace.network;

import cyberspace.CyberspaceMod;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class CyberspaceModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        CyberspaceMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.OverworldPlayerLocationX = message.data.OverworldPlayerLocationX;
                    variables.OverworldPlayerLocationY = message.data.OverworldPlayerLocationY;
                    variables.OverworldPlayerLocationZ = message.data.OverworldPlayerLocationZ;
                    variables.CyberspacePlayerLocationX = message.data.CyberspacePlayerLocationX;
                    variables.CyberspacePlayerLocationY = message.data.CyberspacePlayerLocationY;
                    variables.CyberspacePlayerLocationZ = message.data.CyberspacePlayerLocationZ;
                    variables.CyberspaceVisited = message.data.CyberspaceVisited;
                    variables.CreditNumber = message.data.CreditNumber;
                    variables.FeatherfallUpgrade = message.data.FeatherfallUpgrade;
                    variables.SkyboundUpgrade = message.data.SkyboundUpgrade;
                    variables.NourishedUpgrade = message.data.NourishedUpgrade;
                    variables.SpeedUpgrade = message.data.SpeedUpgrade;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double OverworldPlayerLocationX = 0.0;
        public double OverworldPlayerLocationY = 0.0;
        public double OverworldPlayerLocationZ = 0.0;
        public double CyberspacePlayerLocationX = 0.0;
        public double CyberspacePlayerLocationY = 0.0;
        public double CyberspacePlayerLocationZ = 0.0;
        public boolean CyberspaceVisited = false;
        public double CreditNumber = 0.0;
        public boolean FeatherfallUpgrade = false;
        public boolean SkyboundUpgrade = false;
        public boolean NourishedUpgrade = false;
        public boolean SpeedUpgrade = false;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                CyberspaceMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("OverworldPlayerLocationX", this.OverworldPlayerLocationX);
            nbt.m_128347_("OverworldPlayerLocationY", this.OverworldPlayerLocationY);
            nbt.m_128347_("OverworldPlayerLocationZ", this.OverworldPlayerLocationZ);
            nbt.m_128347_("CyberspacePlayerLocationX", this.CyberspacePlayerLocationX);
            nbt.m_128347_("CyberspacePlayerLocationY", this.CyberspacePlayerLocationY);
            nbt.m_128347_("CyberspacePlayerLocationZ", this.CyberspacePlayerLocationZ);
            nbt.m_128379_("CyberspaceVisited", this.CyberspaceVisited);
            nbt.m_128347_("CreditNumber", this.CreditNumber);
            nbt.m_128379_("FeatherfallUpgrade", this.FeatherfallUpgrade);
            nbt.m_128379_("SkyboundUpgrade", this.SkyboundUpgrade);
            nbt.m_128379_("NourishedUpgrade", this.NourishedUpgrade);
            nbt.m_128379_("SpeedUpgrade", this.SpeedUpgrade);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.OverworldPlayerLocationX = nbt.m_128459_("OverworldPlayerLocationX");
            this.OverworldPlayerLocationY = nbt.m_128459_("OverworldPlayerLocationY");
            this.OverworldPlayerLocationZ = nbt.m_128459_("OverworldPlayerLocationZ");
            this.CyberspacePlayerLocationX = nbt.m_128459_("CyberspacePlayerLocationX");
            this.CyberspacePlayerLocationY = nbt.m_128459_("CyberspacePlayerLocationY");
            this.CyberspacePlayerLocationZ = nbt.m_128459_("CyberspacePlayerLocationZ");
            this.CyberspaceVisited = nbt.m_128471_("CyberspaceVisited");
            this.CreditNumber = nbt.m_128459_("CreditNumber");
            this.FeatherfallUpgrade = nbt.m_128471_("FeatherfallUpgrade");
            this.SkyboundUpgrade = nbt.m_128471_("SkyboundUpgrade");
            this.NourishedUpgrade = nbt.m_128471_("NourishedUpgrade");
            this.SpeedUpgrade = nbt.m_128471_("SpeedUpgrade");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("cyberspace", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.OverworldPlayerLocationX = original.OverworldPlayerLocationX;
            clone.OverworldPlayerLocationY = original.OverworldPlayerLocationY;
            clone.OverworldPlayerLocationZ = original.OverworldPlayerLocationZ;
            clone.CyberspacePlayerLocationX = original.CyberspacePlayerLocationX;
            clone.CyberspacePlayerLocationY = original.CyberspacePlayerLocationY;
            clone.CyberspacePlayerLocationZ = original.CyberspacePlayerLocationZ;
            clone.CyberspaceVisited = original.CyberspaceVisited;
            clone.CreditNumber = original.CreditNumber;
            clone.FeatherfallUpgrade = original.FeatherfallUpgrade;
            clone.SkyboundUpgrade = original.SkyboundUpgrade;
            clone.NourishedUpgrade = original.NourishedUpgrade;
            clone.SpeedUpgrade = original.SpeedUpgrade;
            if (!event.isWasDeath()) {
                // empty if block
            }
        }
    }
}

