/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.util.helper;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import wayoftime.bloodmagic.ConfigManager;
import wayoftime.bloodmagic.altar.IBloodAltar;
import wayoftime.bloodmagic.event.SacrificeKnifeUsedEvent;
import wayoftime.bloodmagic.util.helper.IncenseHelper;

public class PlayerSacrificeHelper {
    public static float scalingOfSacrifice = 1.0f;
    public static int soulFrayDuration = 400;
    public static Potion soulFrayId;

    public static double getPlayerIncense(Player player) {
        return IncenseHelper.getCurrentIncense(player);
    }

    public static void setPlayerIncense(Player player, double amount) {
        IncenseHelper.setCurrentIncense(player, amount);
    }

    public static boolean incrementIncense(Player player, double min, double incenseAddition, double increment) {
        double amount = PlayerSacrificeHelper.getPlayerIncense(player);
        if (amount < min || amount >= incenseAddition) {
            return false;
        }
        amount += Math.min(increment, incenseAddition - amount);
        PlayerSacrificeHelper.setPlayerIncense(player, amount);
        if (amount == incenseAddition) {
            IncenseHelper.setMaxIncense(player, incenseAddition);
        }
        return true;
    }

    public static boolean sacrificePlayerHealth(Player player) {
        float maxHealth;
        float health;
        double amount = PlayerSacrificeHelper.getPlayerIncense(player);
        if (amount >= 0.0 && (double)(health = player.m_21223_()) > (double)(maxHealth = player.m_21233_()) / 10.0) {
            float sacrificedHealth = health - maxHealth / 10.0f;
            int lpAdded = (int)((double)(sacrificedHealth * (float)((Integer)ConfigManager.COMMON.sacrificialDaggerConversion.get()).intValue()) * PlayerSacrificeHelper.getModifier(amount));
            IBloodAltar altar = PlayerSacrificeHelper.getAltar(player.m_20193_(), player.m_20183_());
            if (altar != null) {
                SacrificeKnifeUsedEvent evt = new SacrificeKnifeUsedEvent(player, true, true, (int)sacrificedHealth, lpAdded);
                if (MinecraftForge.EVENT_BUS.post((Event)evt)) {
                    return false;
                }
                altar.sacrificialDaggerCall(evt.lpAdded, false);
                altar.startCycle();
                player.m_21153_(maxHealth / 10.0f);
                PlayerSacrificeHelper.setPlayerIncense(player, 0.0);
                return true;
            }
        }
        return false;
    }

    public static double getModifier(double amount) {
        return 1.0 + amount * (double)scalingOfSacrifice;
    }

    public static boolean findAndFillAltar(Level world, LivingEntity sacrificingEntity, int amount, boolean isSacrifice) {
        IBloodAltar altarEntity = PlayerSacrificeHelper.getAltar(world, sacrificingEntity.m_20183_());
        if (altarEntity == null) {
            return false;
        }
        altarEntity.sacrificialDaggerCall(amount, isSacrifice);
        altarEntity.startCycle();
        return true;
    }

    public static IBloodAltar getAltar(Level world, BlockPos blockPos) {
        for (int x = -2; x <= 2; ++x) {
            for (int y = -2; y <= 1; ++y) {
                for (int z = -2; z <= 2; ++z) {
                    BlockEntity tileEntity = world.m_7702_(blockPos.m_7918_(x, y, z));
                    if (!(tileEntity instanceof IBloodAltar)) continue;
                    return (IBloodAltar)tileEntity;
                }
            }
        }
        return null;
    }
}

