/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.util;

import java.util.List;
import java.util.Locale;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import wayoftime.bloodmagic.api.compat.IDemonWillViewer;
import wayoftime.bloodmagic.common.tags.BloodMagicTags;
import wayoftime.bloodmagic.common.tile.TileInventory;
import wayoftime.bloodmagic.util.helper.InventoryHelper;
import wayoftime.bloodmagic.util.helper.NBTHelper;

public class Utils {
    public static boolean insertItemToTile(TileInventory tile, Player player) {
        return Utils.insertItemToTile(tile, player, 0);
    }

    public static boolean insertItemToTile(TileInventory tile, Player player, int slot) {
        ItemStack slotStack = tile.m_8020_(slot);
        if (slotStack.m_41619_() && !player.m_21205_().m_41619_()) {
            ItemStack input = player.m_21205_().m_41777_();
            input.m_41764_(1);
            player.m_21205_().m_41774_(1);
            tile.m_6836_(slot, input);
            return true;
        }
        if (!slotStack.m_41619_() && player.m_21205_().m_41619_()) {
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)slotStack);
            tile.m_6211_();
            return false;
        }
        return false;
    }

    public static String toFancyCasing(String input) {
        return String.valueOf(input.charAt(0)).toUpperCase(Locale.ROOT) + input.substring(1);
    }

    public static boolean isImmuneToFireDamage(LivingEntity entity) {
        return entity.m_5825_() || entity.m_21023_(MobEffects.f_19607_);
    }

    public static boolean isBlockLiquid(BlockState state) {
        return state instanceof IFluidBlock || state.m_278721_();
    }

    public static boolean isFlowingLiquid(Level world, BlockPos pos, BlockState state) {
        Block block = state.m_60734_();
        return block instanceof IFluidBlock && Math.abs(((IFluidBlock)block).getFilledPercentage(world, pos)) == 1.0f || block instanceof LiquidBlock && !((LiquidBlock)block).m_5888_(state).m_76170_();
    }

    public static boolean spawnStackAtBlock(Level world, BlockPos pos, @Nullable Direction pushDirection, ItemStack stack) {
        BlockPos spawnPos = new BlockPos((Vec3i)pos);
        double velX = 0.0;
        double velY = 0.0;
        double velZ = 0.0;
        double velocity = 0.15;
        if (pushDirection != null) {
            spawnPos = spawnPos.m_121945_(pushDirection);
            switch (pushDirection) {
                case DOWN: {
                    velY = -velocity;
                    break;
                }
                case UP: {
                    velY = velocity;
                    break;
                }
                case NORTH: {
                    velZ = -velocity;
                    break;
                }
                case SOUTH: {
                    velZ = velocity;
                    break;
                }
                case WEST: {
                    velX = -velocity;
                    break;
                }
                case EAST: {
                    velX = velocity;
                }
            }
        }
        double posX = (double)spawnPos.m_123341_() + 0.5;
        double posY = (double)spawnPos.m_123342_() + 0.5;
        double posZ = (double)spawnPos.m_123343_() + 0.5;
        ItemEntity entityItem = new ItemEntity(world, posX, posY, posZ, stack);
        entityItem.m_20334_(velX, velY, velZ);
        entityItem.m_32045_(stack);
        return world.m_7967_((Entity)entityItem);
    }

    public static boolean swapLocations(Level initialWorld, BlockPos initialPos, Level finalWorld, BlockPos finalPos) {
        return Utils.swapLocations(initialWorld, initialPos, finalWorld, finalPos, true);
    }

    public static boolean swapLocations(Level initialWorld, BlockPos initialPos, Level finalWorld, BlockPos finalPos, boolean playSound) {
        BlockEntity newTileFinal;
        BlockEntity newTileInitial;
        BlockState initialState = initialWorld.m_8055_(initialPos);
        BlockState finalState = finalWorld.m_8055_(finalPos);
        if (initialState.m_60734_().equals(Blocks.f_50016_) && finalState.m_60734_().equals(Blocks.f_50016_) || initialState.m_204336_(BloodMagicTags.TELEPOSE_BLOCK_BLACKLIST) || finalState.m_204336_(BloodMagicTags.TELEPOSE_BLOCK_BLACKLIST)) {
            return false;
        }
        BlockEntity initialTile = initialWorld.m_7702_(initialPos);
        BlockEntity finalTile = finalWorld.m_7702_(finalPos);
        CompoundTag initialTag = new CompoundTag();
        CompoundTag finalTag = new CompoundTag();
        if (initialTile != null) {
            initialTag = initialTile.m_187480_();
        }
        if (finalTile != null) {
            finalTag = finalTile.m_187480_();
        }
        if (playSound) {
            initialWorld.m_6263_(null, (double)initialPos.m_123341_(), (double)initialPos.m_123342_(), (double)initialPos.m_123343_(), SoundEvents.f_11852_, SoundSource.AMBIENT, 1.0f, 1.0f);
            finalWorld.m_6263_(null, (double)finalPos.m_123341_(), (double)finalPos.m_123342_(), (double)finalPos.m_123343_(), SoundEvents.f_11852_, SoundSource.AMBIENT, 1.0f, 1.0f);
        }
        if (finalState.m_60734_() instanceof EntityBlock) {
            finalWorld.m_46747_(finalPos);
        }
        if (initialState.m_60734_() instanceof EntityBlock) {
            initialWorld.m_46747_(initialPos);
        }
        BlockState initialBlockState = initialWorld.m_8055_(initialPos);
        BlockState finalBlockState = finalWorld.m_8055_(finalPos);
        finalWorld.m_7731_(finalPos, initialBlockState, 3);
        initialWorld.m_7731_(initialPos, finalBlockState, 3);
        if (initialTile != null && (newTileInitial = finalWorld.m_7702_(finalPos)) != null) {
            newTileInitial.m_142466_(initialTag);
        }
        if (finalTile != null && (newTileFinal = initialWorld.m_7702_(initialPos)) != null) {
            newTileFinal.m_142466_(finalTag);
        }
        initialWorld.m_46672_(initialPos, finalState.m_60734_());
        finalWorld.m_46672_(finalPos, initialState.m_60734_());
        if (initialWorld.m_183326_().m_183582_(initialPos, (Object)initialState.m_60734_())) {
            finalWorld.m_186460_(finalPos, initialState.m_60734_(), 20);
        }
        if (finalWorld.m_183326_().m_183582_(finalPos, (Object)finalState.m_60734_())) {
            initialWorld.m_186460_(initialPos, finalState.m_60734_(), 20);
        }
        return true;
    }

    public static ItemStack insertStackIntoTile(ItemStack stack, BlockEntity tile, Direction dir) {
        LazyOptional capability = tile.getCapability(ForgeCapabilities.ITEM_HANDLER, dir);
        if (capability.isPresent()) {
            IItemHandler handler = (IItemHandler)capability.resolve().get();
            return Utils.insertStackIntoTile(stack, handler);
        }
        if (tile instanceof Container) {
            return Utils.insertStackIntoInventory(stack, (Container)tile, dir);
        }
        return stack;
    }

    public static ItemStack insertStackIntoTile(ItemStack stack, IItemHandler handler, boolean doCleanly) {
        int slot;
        int numberOfSlots = handler.getSlots();
        ItemStack copyStack = stack.m_41777_();
        if (doCleanly) {
            for (slot = 0; slot < numberOfSlots; ++slot) {
                ItemStack containedStack = handler.getStackInSlot(slot);
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)containedStack) || !(copyStack = handler.insertItem(slot, copyStack, false)).m_41619_()) continue;
                return ItemStack.f_41583_;
            }
        }
        for (slot = 0; slot < numberOfSlots; ++slot) {
            if (!(copyStack = handler.insertItem(slot, copyStack, false)).m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        return copyStack;
    }

    public static ItemStack insertStackIntoTile(ItemStack stack, IItemHandler handler) {
        return Utils.insertStackIntoTile(stack, handler, false);
    }

    public static int getNumberOfFreeSlots(BlockEntity tile, Direction dir) {
        int slots;
        block3: {
            block2: {
                slots = 0;
                LazyOptional capability = tile.getCapability(ForgeCapabilities.ITEM_HANDLER, dir);
                if (!capability.isPresent()) break block2;
                IItemHandler handler = (IItemHandler)capability.resolve().get();
                for (int i = 0; i < handler.getSlots(); ++i) {
                    if (!handler.getStackInSlot(i).m_41619_()) continue;
                    ++slots;
                }
                break block3;
            }
            if (!(tile instanceof Container)) break block3;
            for (int i = 0; i < ((Container)tile).m_6643_(); ++i) {
                if (!((Container)tile).m_8020_(i).m_41619_()) continue;
                ++slots;
            }
        }
        return slots;
    }

    public static ItemStack insertStackIntoInventory(ItemStack stack, Container inventory, Direction dir) {
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        boolean[] canBeInserted = new boolean[inventory.m_6643_()];
        if (inventory instanceof WorldlyContainer) {
            int[] array;
            for (int in : array = ((WorldlyContainer)inventory).m_7071_(dir)) {
                canBeInserted[in] = inventory.m_7013_(in, stack) && ((WorldlyContainer)inventory).m_7155_(in, stack, dir);
            }
        } else {
            for (int i = 0; i < canBeInserted.length; ++i) {
                canBeInserted[i] = inventory.m_7013_(i, stack);
            }
        }
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            if (!canBeInserted[i]) continue;
            ItemStack[] combinedStacks = Utils.combineStacks(stack, inventory.m_8020_(i));
            stack = combinedStacks[0];
            inventory.m_6836_(i, combinedStacks[1]);
            if (!stack.m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        return stack;
    }

    public static boolean canInsertStackFullyIntoInventory(ItemStack stack, IItemHandler itemHandler, boolean fillToLimit, int limit) {
        ItemStack invStack;
        int i;
        if (stack.m_41619_()) {
            return true;
        }
        int itemsLeft = stack.m_41613_();
        boolean[] canBeInserted = new boolean[itemHandler.getSlots()];
        for (int i2 = 0; i2 < canBeInserted.length; ++i2) {
            canBeInserted[i2] = itemHandler.isItemValid(i2, stack);
        }
        int numberMatching = 0;
        if (fillToLimit) {
            for (i = 0; i < itemHandler.getSlots(); ++i) {
                if (!canBeInserted[i] || (invStack = itemHandler.getStackInSlot(i)).m_41619_() || !ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)invStack)) continue;
                numberMatching += invStack.m_41613_();
            }
        }
        if (fillToLimit && limit < stack.m_41613_() + numberMatching) {
            return false;
        }
        for (i = 0; i < itemHandler.getSlots(); ++i) {
            if (!canBeInserted[i]) continue;
            invStack = itemHandler.getStackInSlot(i);
            if (invStack.m_41619_()) {
                itemsLeft = 0;
            } else {
                boolean canCombine = ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)invStack);
                if (canCombine) {
                    itemsLeft = invStack.m_41619_() ? 0 : (itemsLeft -= Math.min(invStack.m_41741_(), itemHandler.getSlotLimit(i)) - invStack.m_41613_());
                }
            }
            if (itemsLeft > 0) continue;
            return true;
        }
        return false;
    }

    public static boolean canInsertStackFullyIntoInventory(ItemStack stack, Container inventory, Direction dir, boolean fillToLimit, int limit) {
        if (stack.m_41619_()) {
            return true;
        }
        int itemsLeft = stack.m_41613_();
        boolean[] canBeInserted = new boolean[inventory.m_6643_()];
        if (inventory instanceof WorldlyContainer) {
            int[] array;
            for (int in : array = ((WorldlyContainer)inventory).m_7071_(dir)) {
                canBeInserted[in] = inventory.m_7013_(in, stack) && ((WorldlyContainer)inventory).m_7155_(in, stack, dir);
            }
        } else {
            for (int i = 0; i < canBeInserted.length; ++i) {
                canBeInserted[i] = inventory.m_7013_(i, stack);
            }
        }
        int numberMatching = 0;
        if (fillToLimit) {
            for (int i = 0; i < inventory.m_6643_(); ++i) {
                ItemStack invStack;
                if (!canBeInserted[i] || (invStack = inventory.m_8020_(i)).m_41619_() || !ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)invStack)) continue;
                numberMatching += invStack.m_41613_();
            }
        }
        if (fillToLimit && limit < stack.m_41613_() + numberMatching) {
            return false;
        }
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            if (!canBeInserted[i]) continue;
            ItemStack invStack = inventory.m_8020_(i);
            boolean canCombine = ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)invStack);
            if (canCombine) {
                itemsLeft = invStack.m_41619_() ? 0 : (itemsLeft -= invStack.m_41741_() - invStack.m_41613_());
            }
            if (itemsLeft > 0) continue;
            return true;
        }
        return false;
    }

    public static ItemStack[] combineStacks(ItemStack stack1, ItemStack stack2) {
        ItemStack[] returned = new ItemStack[2];
        if (ItemHandlerHelper.canItemStacksStack((ItemStack)stack1, (ItemStack)stack2)) {
            int transferedAmount;
            int n = transferedAmount = stack2.m_41619_() ? stack1.m_41613_() : Math.min(stack2.m_41741_() - stack2.m_41613_(), stack1.m_41613_());
            if (transferedAmount > 0) {
                ItemStack copyStack = stack1.m_41620_(transferedAmount);
                if (stack2.m_41619_()) {
                    stack2 = copyStack;
                } else {
                    stack2.m_41769_(transferedAmount);
                }
            }
        }
        returned[0] = stack1;
        returned[1] = stack2;
        return returned;
    }

    public static boolean canPlayerSeeDemonWill(Player player) {
        NonNullList<ItemStack> inventory = InventoryHelper.getActiveInventories(player);
        for (ItemStack stack : inventory) {
            if (!(stack.m_41720_() instanceof IDemonWillViewer) || !((IDemonWillViewer)stack.m_41720_()).canSeeDemonWillAura(player.m_20193_(), stack, player)) continue;
            return true;
        }
        return false;
    }

    public static double getDemonWillResolution(Player player) {
        NonNullList<ItemStack> inventory = InventoryHelper.getActiveInventories(player);
        for (ItemStack stack : inventory) {
            if (!(stack.m_41720_() instanceof IDemonWillViewer) || !((IDemonWillViewer)stack.m_41720_()).canSeeDemonWillAura(player.m_20193_(), stack, player)) continue;
            return ((IDemonWillViewer)stack.m_41720_()).getDemonWillAuraResolution(player.m_20193_(), stack, player);
        }
        return 100.0;
    }

    public static int plantSeedsInArea(Level world, AABB aabb, int horizontalRadius, int verticalRadius) {
        int placedBlocks = 0;
        List itemEntities = world.m_45976_(ItemEntity.class, aabb);
        for (ItemEntity itemEntity : itemEntities) {
            placedBlocks += Utils.plantEntityItem(itemEntity, horizontalRadius, verticalRadius);
        }
        return placedBlocks;
    }

    public static int plantItemStack(Level world, BlockPos centralPos, ItemStack stack, int horizontalRadius, int verticalRadius) {
        if (stack.m_41619_()) {
            return 0;
        }
        Item item = stack.m_41720_();
        if (!(item instanceof BlockItem)) {
            return 0;
        }
        BlockItem blockItem = (BlockItem)item;
        Block plantBlock = blockItem.m_40614_();
        if (!(plantBlock instanceof IPlantable)) {
            return 0;
        }
        IPlantable plantable = (IPlantable)plantBlock;
        int planted = 0;
        for (int y = -verticalRadius; y <= verticalRadius; ++y) {
            for (int x = -horizontalRadius; x <= horizontalRadius; ++x) {
                for (int z = -horizontalRadius; z <= horizontalRadius; ++z) {
                    BlockPos offsetPos;
                    BlockState state;
                    BlockPos newPos = centralPos.m_7918_(x, y, z);
                    if (!world.m_46859_(newPos) || !(state = world.m_8055_(offsetPos = newPos.m_121945_(Direction.DOWN))).m_60734_().canSustainPlant(state, (BlockGetter)world, offsetPos, Direction.UP, plantable)) continue;
                    BlockState plantState = plantable.getPlant((BlockGetter)world, newPos);
                    world.m_7731_(newPos, plantState, 3);
                    world.m_46796_(2001, newPos, Block.m_49956_((BlockState)plantState));
                    stack.m_41774_(1);
                    ++planted;
                    if (!stack.m_41619_() && stack.m_41613_() > 0) continue;
                    return planted;
                }
            }
        }
        return planted;
    }

    public static int plantEntityItem(ItemEntity itemEntity, int horizontalRadius, int verticalRadius) {
        if (itemEntity == null || !itemEntity.m_6084_()) {
            return 0;
        }
        Level world = itemEntity.m_20193_();
        BlockPos pos = itemEntity.m_20183_();
        ItemStack stack = itemEntity.m_32055_();
        int planted = Utils.plantItemStack(world, pos, stack, horizontalRadius, verticalRadius);
        if (stack.m_41619_()) {
            itemEntity.m_146870_();
        }
        return planted;
    }

    @Nullable
    public static IItemHandler getInventory(BlockEntity tile, @Nullable Direction facing) {
        if (facing == null) {
            facing = Direction.DOWN;
        }
        IItemHandler itemHandler = null;
        if (tile.getCapability(ForgeCapabilities.ITEM_HANDLER, facing).isPresent()) {
            itemHandler = (IItemHandler)tile.getCapability(ForgeCapabilities.ITEM_HANDLER, facing).resolve().get();
        } else if (tile instanceof WorldlyContainer) {
            itemHandler = ((WorldlyContainer)tile).m_7071_(facing).length != 0 ? new SidedInvWrapper((WorldlyContainer)tile, facing) : null;
        } else if (tile instanceof Container) {
            itemHandler = new InvWrapper((Container)tile);
        }
        return itemHandler;
    }

    public static float addAbsorptionToMaximum(LivingEntity entity, float added, int maximum, int duration) {
        float currentAmount = entity.m_6103_();
        added = Math.min((float)maximum - currentAmount, added);
        if (added <= 0.0f) {
            return 0.0f;
        }
        if (duration > 0) {
            int potionLevel = (int)((currentAmount + added) / 4.0f);
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19617_, duration, potionLevel, true, false));
        }
        entity.m_7911_(currentAmount + added);
        return added;
    }

    public static boolean hasUUID(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128441_("mostSig") && stack.m_41783_().m_128441_("leastSig");
    }

    public static UUID getUUID(ItemStack stack) {
        if (!Utils.hasUUID(stack)) {
            return null;
        }
        return new UUID(stack.m_41783_().m_128454_("mostSig"), stack.m_41783_().m_128454_("leastSig"));
    }

    public static void setUUID(ItemStack stack) {
        if (!(stack = NBTHelper.checkNBT(stack)).m_41783_().m_128441_("mostSig") && !stack.m_41783_().m_128441_("leastSig")) {
            UUID itemUUID = UUID.randomUUID();
            stack.m_41783_().m_128356_("mostSig", itemUUID.getMostSignificantBits());
            stack.m_41783_().m_128356_("leastSig", itemUUID.getLeastSignificantBits());
        }
    }

    public static boolean isMeleeDamage(DamageSource source) {
        if (source.m_269533_(DamageTypeTags.f_268524_)) {
            return false;
        }
        return source.m_276093_(DamageTypes.f_268566_) || source.m_276093_(DamageTypes.f_268511_) || source.m_276093_(DamageTypes.f_268464_);
    }
}

