/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.compat.patchouli.processors;

import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;
import wayoftime.bloodmagic.common.item.BloodMagicItems;
import wayoftime.bloodmagic.common.recipe.BloodMagicRecipeType;
import wayoftime.bloodmagic.recipe.RecipeAlchemyTable;

public class AlchemyTableProcessor
implements IComponentProcessor {
    private RecipeAlchemyTable recipe;

    public void setup(Level level, IVariableProvider variables) {
        Recipe recipe;
        ResourceLocation id = new ResourceLocation(variables.get("recipe").asString());
        Optional recipeHandler = Minecraft.m_91087_().f_91073_.m_7465_().m_44043_(id);
        if (recipeHandler.isPresent() && (recipe = (Recipe)recipeHandler.get()).m_6671_().equals(BloodMagicRecipeType.ALCHEMYTABLE.get())) {
            this.recipe = (RecipeAlchemyTable)recipe;
        }
        if (this.recipe == null) {
            LogManager.getLogger().warn("Guidebook missing Alchemy Table recipe {}", (Object)id);
        }
    }

    public IVariable process(Level level, String key) {
        if (this.recipe == null) {
            return null;
        }
        if (key.startsWith("input")) {
            int index = Integer.parseInt(key.substring(5)) - 1;
            if (this.recipe.getInput().size() > index) {
                return IVariable.wrapList((Iterable)Arrays.stream(this.recipe.getInput().get(index).m_43908_()).map(IVariable::from).collect(Collectors.toList()));
            }
            return null;
        }
        switch (key) {
            case "output": {
                return IVariable.from((Object)this.recipe.getOutput());
            }
            case "syphon": {
                return IVariable.wrap((Number)this.recipe.getSyphon());
            }
            case "time": {
                return IVariable.wrap((Number)this.recipe.getTicks());
            }
            case "tier": {
                return IVariable.wrap((Number)this.recipe.getMinimumTier());
            }
            case "orb": {
                switch (this.recipe.getMinimumTier()) {
                    case 0: 
                    case 1: {
                        return IVariable.from((Object)new ItemStack((ItemLike)BloodMagicItems.WEAK_BLOOD_ORB.get()));
                    }
                    case 2: {
                        return IVariable.from((Object)new ItemStack((ItemLike)BloodMagicItems.APPRENTICE_BLOOD_ORB.get()));
                    }
                    case 3: {
                        return IVariable.from((Object)new ItemStack((ItemLike)BloodMagicItems.MAGICIAN_BLOOD_ORB.get()));
                    }
                    case 4: {
                        return IVariable.from((Object)new ItemStack((ItemLike)BloodMagicItems.MASTER_BLOOD_ORB.get()));
                    }
                }
                LogManager.getLogger().warn("Guidebook unable to find large enough Blood Orb for {}", (Object)this.recipe.m_6423_());
                return IVariable.from((Object)new ItemStack((ItemLike)Items.f_42127_));
            }
        }
        return null;
    }
}

