/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.compat.jei.altar;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.common.block.BloodMagicBlocks;
import wayoftime.bloodmagic.recipe.RecipeBloodAltar;
import wayoftime.bloodmagic.util.ChatUtil;
import wayoftime.bloodmagic.util.helper.NumeralHelper;
import wayoftime.bloodmagic.util.helper.TextHelper;

public class BloodAltarRecipeCategory
implements IRecipeCategory<RecipeBloodAltar> {
    public static final RecipeType<RecipeBloodAltar> RECIPE_TYPE = RecipeType.create((String)"bloodmagic", (String)"altar", RecipeBloodAltar.class);
    @Nonnull
    private final IDrawable background;
    private final IDrawable icon;

    public BloodAltarRecipeCategory(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)BloodMagicBlocks.BLOOD_ALTAR.get()));
        this.background = guiHelper.createDrawable(BloodMagic.rl("gui/jei/altar.png"), 3, 4, 155, 65);
    }

    public List<Component> getTooltipStrings(RecipeBloodAltar recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        ArrayList tooltip = Lists.newArrayList();
        if (mouseX >= 85.0 && mouseX <= 104.0 && mouseY >= 30.0 && mouseY <= 44.0) {
            tooltip.add(Component.m_237110_((String)"jei.bloodmagic.recipe.consumptionrate", (Object[])new Object[]{ChatUtil.DECIMAL_FORMAT.format(recipe.getConsumeRate())}));
            tooltip.add(Component.m_237110_((String)"jei.bloodmagic.recipe.drainrate", (Object[])new Object[]{ChatUtil.DECIMAL_FORMAT.format(recipe.getDrainRate())}));
        }
        return tooltip;
    }

    @Nonnull
    public Component getTitle() {
        return Component.m_237115_((String)"jei.bloodmagic.recipe.altar");
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeBloodAltar recipe, IFocusGroup focuses) {
        IRecipeSlotBuilder output = builder.addSlot(RecipeIngredientRole.OUTPUT, 126, 31);
        output.addItemStack(recipe.getOutput());
        IRecipeSlotBuilder input = builder.addSlot(RecipeIngredientRole.INPUT, 32, 1);
        input.addIngredients(recipe.getInput());
    }

    public RecipeType<RecipeBloodAltar> getRecipeType() {
        return RECIPE_TYPE;
    }

    public void draw(RecipeBloodAltar recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Minecraft mc = Minecraft.m_91087_();
        String[] infoString = new String[]{TextHelper.localize("jei.bloodmagic.recipe.requiredtier", NumeralHelper.toRoman(recipe.getMinimumTier() + 1)), TextHelper.localize("jei.bloodmagic.recipe.requiredlp", recipe.getSyphon())};
        guiGraphics.m_280056_(mc.f_91062_, infoString[0], 90 - mc.f_91062_.m_92895_(infoString[0]) / 2, 0, Color.gray.getRGB(), false);
        guiGraphics.m_280056_(mc.f_91062_, infoString[1], 90 - mc.f_91062_.m_92895_(infoString[1]) / 2, 10, Color.gray.getRGB(), false);
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(87.0f, 41.0f, 0.0f);
        poseStack.m_85841_(0.5f, 0.5f, 1.0f);
        guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"jei.bloodmagic.recipe.info"), 0, 0, 0x8B8B8B, false);
        poseStack.m_85849_();
    }
}

