/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.tile;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import wayoftime.bloodmagic.common.block.BloodMagicBlocks;
import wayoftime.bloodmagic.common.tile.BloodMagicTileEntities;
import wayoftime.bloodmagic.common.tile.TileInventory;
import wayoftime.bloodmagic.util.ChatUtil;

public class TileMimic
extends TileInventory {
    public static final ModelProperty<BlockState> MIMIC = new ModelProperty();
    private BlockState mimic;
    public boolean dropItemsOnBreak = true;
    public CompoundTag tileTag = new CompoundTag();
    public BlockEntity mimicedTile = null;
    public int playerCheckRadius = 5;
    public int potionSpawnRadius = 5;
    public int potionSpawnInterval = 40;
    private int internalCounter = 0;

    public TileMimic(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, 2, "mimic", pos, state);
    }

    public TileMimic(BlockPos pos, BlockState state) {
        this((BlockEntityType)BloodMagicTileEntities.MIMIC_TYPE.get(), pos, state);
    }

    public boolean onBlockActivated(Level world, BlockPos pos, BlockState state, Player player, InteractionHand hand, ItemStack heldItem, Direction side) {
        Block block;
        BlockState mimicState;
        List list;
        if (!heldItem.m_41619_() && player.m_7500_() && !(list = PotionUtils.m_43547_((ItemStack)heldItem)).isEmpty()) {
            if (!world.f_46443_) {
                this.m_6836_(1, heldItem.m_41777_());
                world.m_7260_(pos, state, state, 3);
                ChatUtil.sendNoSpam(player, new Component[]{Component.m_237115_((String)"chat.bloodmagic.mimic.potionSet")});
            }
            return true;
        }
        if (this.performSpecialAbility(player, side)) {
            return true;
        }
        if (player.m_6144_()) {
            return false;
        }
        if (!player.m_21120_(hand).m_41619_() && player.m_21120_(hand).m_41720_() == new ItemStack((ItemLike)BloodMagicBlocks.MIMIC.get()).m_41720_()) {
            return false;
        }
        if (!this.m_8020_(0).m_41619_() && !player.m_21120_(hand).m_41619_()) {
            return false;
        }
        if (!this.dropItemsOnBreak && !player.m_7500_()) {
            return false;
        }
        ItemStack stack = player.m_21120_(hand);
        if (!(this.mimic != null && this.mimic != Blocks.f_50016_.m_49966_() || stack.m_41619_() || !(stack.m_41720_() instanceof BlockItem) || world.f_46443_ || (mimicState = (block = ((BlockItem)stack.m_41720_()).m_40614_()).m_49966_()).m_60713_((Block)BloodMagicBlocks.MIMIC.get()) || mimicState.m_60713_((Block)BloodMagicBlocks.ETHEREAL_MIMIC.get()))) {
            this.setMimic(mimicState);
        }
        this.refreshTileEntity();
        if (player.m_7500_()) {
            this.dropItemsOnBreak = this.m_8020_(0).m_41619_();
        }
        return true;
    }

    public boolean performSpecialAbility(Player player, Direction sideHit) {
        if (!player.m_7500_()) {
            return false;
        }
        if (player.m_21211_().m_41619_() && !this.m_8020_(1).m_41619_()) {
            switch (sideHit) {
                case EAST: 
                case WEST: {
                    if (player.m_6144_()) {
                        this.potionSpawnRadius = Math.max(this.potionSpawnRadius - 1, 0);
                        ChatUtil.sendNoSpam(player, new Component[]{Component.m_237110_((String)"chat.bloodmagic.mimic.potionSpawnRadius.down", (Object[])new Object[]{this.potionSpawnRadius})});
                        break;
                    }
                    ++this.potionSpawnRadius;
                    ChatUtil.sendNoSpam(player, new Component[]{Component.m_237110_((String)"chat.bloodmagic.mimic.potionSpawnRadius.up", (Object[])new Object[]{this.potionSpawnRadius})});
                    break;
                }
                case NORTH: 
                case SOUTH: {
                    if (player.m_6144_()) {
                        this.playerCheckRadius = Math.max(this.playerCheckRadius - 1, 0);
                        ChatUtil.sendNoSpam(player, new Component[]{Component.m_237110_((String)"chat.bloodmagic.mimic.detectRadius.down", (Object[])new Object[]{this.playerCheckRadius})});
                        break;
                    }
                    ++this.playerCheckRadius;
                    ChatUtil.sendNoSpam(player, new Component[]{Component.m_237110_((String)"chat.bloodmagic.mimic.detectRadius.up", (Object[])new Object[]{this.playerCheckRadius})});
                    break;
                }
                case UP: 
                case DOWN: {
                    if (player.m_6144_()) {
                        this.potionSpawnInterval = Math.max(this.potionSpawnInterval - 1, 1);
                        ChatUtil.sendNoSpam(player, new Component[]{Component.m_237110_((String)"chat.bloodmagic.mimic.potionInterval.down", (Object[])new Object[]{this.potionSpawnInterval})});
                        break;
                    }
                    ++this.potionSpawnInterval;
                    ChatUtil.sendNoSpam(player, new Component[]{Component.m_237110_((String)"chat.bloodmagic.mimic.potionInterval.up", (Object[])new Object[]{this.potionSpawnInterval})});
                    break;
                }
            }
            return true;
        }
        return false;
    }

    public void refreshTileEntity() {
        if (this.mimicedTile != null) {
            this.dropMimicedTileInventory();
        }
        this.mimicedTile = TileMimic.getTileFromStackWithTag(this.m_58904_(), this.f_58858_, this.m_8020_(0), this.tileTag, this.mimic);
    }

    public void dropMimicedTileInventory() {
        if (!this.m_58904_().f_46443_ && this.mimicedTile instanceof Container) {
            this.m_6836_(0, ItemStack.f_41583_);
            this.m_6836_(1, ItemStack.f_41583_);
        }
    }

    @Nullable
    public static BlockEntity getTileFromStackWithTag(Level world, BlockPos pos, ItemStack stack, @Nullable CompoundTag tag, BlockState replacementState) {
        if (!stack.m_41619_() && stack.m_41720_() instanceof BlockItem) {
            Block block = ((BlockItem)stack.m_41720_()).m_40614_();
            BlockState state = replacementState;
            if (block instanceof EntityBlock) {
                BlockEntity tile = ((EntityBlock)block).m_142194_(pos, state);
                if (tile == null) {
                    return null;
                }
                if (tag != null) {
                    CompoundTag copyTag = tag.m_6426_();
                    copyTag.m_128405_("x", pos.m_123341_());
                    copyTag.m_128405_("y", pos.m_123342_());
                    copyTag.m_128405_("z", pos.m_123343_());
                    tile.deserializeNBT(copyTag);
                }
                tile.m_142339_(world);
                return tile;
            }
        }
        return null;
    }

    public void setMimic(BlockState mimic) {
        this.mimic = mimic;
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }

    public BlockState getMimic() {
        return this.mimic;
    }

    @Override
    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.writeMimic(tag);
        return tag;
    }

    @Override
    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Override
    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        BlockState oldMimic = this.mimic;
        CompoundTag tag = pkt.m_131708_();
        this.deserialize(tag);
        if (!Objects.equals(oldMimic, this.mimic)) {
            this.requestModelDataUpdate();
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    @Nonnull
    public ModelData getModelData() {
        return ModelData.builder().with(MIMIC, (Object)this.mimic).build();
    }

    @Override
    public void deserialize(CompoundTag tag) {
        super.deserialize(tag);
        this.dropItemsOnBreak = tag.m_128471_("dropItemsOnBreak");
        this.tileTag = tag.m_128469_("tileTag");
        this.readMimic(tag);
        this.mimicedTile = TileMimic.getTileFromStackWithTag(this.m_58904_(), this.f_58858_, this.m_8020_(0), this.tileTag, this.mimic);
        this.playerCheckRadius = tag.m_128451_("playerCheckRadius");
        this.potionSpawnRadius = tag.m_128451_("potionSpawnRadius");
        this.potionSpawnInterval = Math.max(1, tag.m_128451_("potionSpawnInterval"));
    }

    private void readMimic(CompoundTag tag) {
        if (tag.m_128441_("mimic")) {
            this.mimic = NbtUtils.m_247651_((HolderGetter)this.f_58857_.m_246945_(Registries.f_256747_), (CompoundTag)tag.m_128469_("mimic"));
        }
    }

    @Override
    public CompoundTag serialize(CompoundTag tag) {
        tag.m_128379_("dropItemsOnBreak", this.dropItemsOnBreak);
        tag.m_128365_("tileTag", (Tag)this.tileTag);
        tag.m_128405_("playerCheckRadius", this.playerCheckRadius);
        tag.m_128405_("potionSpawnRadius", this.potionSpawnRadius);
        tag.m_128405_("potionSpawnInterval", this.potionSpawnInterval);
        this.writeMimic(tag);
        return super.serialize(tag);
    }

    private void writeMimic(CompoundTag tag) {
        if (this.mimic != null) {
            tag.m_128365_("mimic", (Tag)NbtUtils.m_129202_((BlockState)this.mimic));
        }
    }

    @Override
    public void dropItems() {
        if (this.dropItemsOnBreak) {
            this.m_6836_(0, ItemStack.f_41583_);
            this.m_6836_(1, ItemStack.f_41583_);
        }
        this.dropMimicedTileInventory();
    }
}

