/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.tile;

import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import wayoftime.bloodmagic.api.compat.EnumDemonWillType;
import wayoftime.bloodmagic.common.block.BlockDemonCrystal;
import wayoftime.bloodmagic.common.tile.BloodMagicTileEntities;
import wayoftime.bloodmagic.common.tile.base.TileTicking;
import wayoftime.bloodmagic.demonaura.WorldDemonWillHandler;
import wayoftime.bloodmagic.will.DemonWillHolder;

public class TileDemonCrystal
extends TileTicking {
    public static final double sameWillConversionRate = 45.0;
    public static final double defaultWillConversionRate = 90.0;
    public static final double timeDelayForWrongWill = 0.6;
    public final int maxWill = 100;
    public DemonWillHolder holder = new DemonWillHolder();
    public double progressToNextCrystal = 0.0;
    public int internalCounter = 0;
    public Direction placement = Direction.UP;
    public double injectedWill = 0.0;
    public double speedModifier = 1.0;
    public double appliedConversionRate = 45.0;
    public EnumDemonWillType willType;

    public TileDemonCrystal(BlockEntityType<?> type, EnumDemonWillType willType, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.willType = willType;
    }

    public TileDemonCrystal(EnumDemonWillType willType, BlockPos pos, BlockState state) {
        this((BlockEntityType)BloodMagicTileEntities.DEMON_CRYSTAL_TYPE.get(), willType, pos, state);
    }

    public TileDemonCrystal(BlockPos pos, BlockState state) {
        this((BlockEntityType)BloodMagicTileEntities.DEMON_CRYSTAL_TYPE.get(), EnumDemonWillType.DEFAULT, pos, state);
    }

    @Override
    public void onUpdate() {
        int crystalCount;
        if (this.f_58857_.f_46443_) {
            return;
        }
        ++this.internalCounter;
        if (this.internalCounter % 20 == 0 && (crystalCount = this.getCrystalCount()) < 7) {
            EnumDemonWillType type = this.getWillType();
            double value = WorldDemonWillHandler.getCurrentWill(this.m_58904_(), this.f_58858_, type);
            if (value >= 0.5) {
                double nextProgress = this.getCrystalGrowthPerSecond(value);
                double bufferDrainRate = 45.0 - this.appliedConversionRate;
                double conversionRate = Math.min(this.appliedConversionRate, 45.0);
                if (this.injectedWill > 0.0 && bufferDrainRate > 0.0) {
                    nextProgress = Math.min(this.injectedWill / bufferDrainRate, nextProgress);
                }
                nextProgress = Math.min(WorldDemonWillHandler.drainWill(this.m_58904_(), this.m_58899_(), type, nextProgress * conversionRate, true) / conversionRate, nextProgress);
                this.progressToNextCrystal += nextProgress;
                if (this.injectedWill > 0.0 && bufferDrainRate > 0.0) {
                    this.injectedWill = Math.max(0.0, this.injectedWill - nextProgress * bufferDrainRate);
                    if (this.injectedWill <= 0.0) {
                        this.appliedConversionRate = 45.0;
                        this.speedModifier = 1.0;
                    }
                }
            } else if (type != EnumDemonWillType.DEFAULT && (value = WorldDemonWillHandler.getCurrentWill(this.m_58904_(), this.f_58858_, EnumDemonWillType.DEFAULT)) > 0.5) {
                double nextProgress = this.getCrystalGrowthPerSecond(value) * 0.6;
                this.progressToNextCrystal += WorldDemonWillHandler.drainWill(this.m_58904_(), this.m_58899_(), EnumDemonWillType.DEFAULT, nextProgress * 90.0, true) / 90.0;
            }
            if (this.speedModifier <= 0.0) {
                this.speedModifier = 1.0;
            }
            this.checkAndGrowCrystal();
        }
    }

    public double getInjectedWill() {
        return this.injectedWill;
    }

    public void applyCatalyst(double addedInjectedWill, double speedModifier, double conversionRate) {
        if (this.speedModifier < speedModifier) {
            this.speedModifier = speedModifier;
        }
        if (this.appliedConversionRate > conversionRate) {
            this.appliedConversionRate = conversionRate;
        }
        this.injectedWill += addedInjectedWill;
    }

    public double growCrystalWithWillAmount(double willDrain, double progressPercentage) {
        double percentDrain;
        int crystalCount = this.getCrystalCount();
        if (crystalCount >= 7) {
            return 0.0;
        }
        EnumDemonWillType type = this.getWillType();
        double value = WorldDemonWillHandler.getCurrentWill(this.m_58904_(), this.f_58858_, type);
        double d = percentDrain = willDrain <= 0.0 ? 1.0 : Math.min(1.0, value / willDrain);
        if (percentDrain <= 0.0) {
            return 0.0;
        }
        WorldDemonWillHandler.drainWill(this.m_58904_(), this.f_58858_, type, percentDrain * willDrain, true);
        this.progressToNextCrystal += percentDrain * progressPercentage;
        this.checkAndGrowCrystal();
        return percentDrain * progressPercentage;
    }

    public EnumDemonWillType getWillType() {
        return this.willType;
    }

    public void checkAndGrowCrystal() {
        int crystalCount = this.getCrystalCount();
        if (this.progressToNextCrystal >= 1.0 && this.internalCounter % 100 == 0 && crystalCount < 7) {
            this.progressToNextCrystal -= 1.0;
            this.setCrystalCount(crystalCount + 1);
            this.m_6596_();
            this.notifyUpdate();
        }
    }

    public double getMaxWillForCrystal() {
        return 50.0;
    }

    public boolean dropSingleCrystal() {
        EnumDemonWillType type;
        ItemStack stack;
        int crystalCount = this.getCrystalCount();
        if (!this.m_58904_().f_46443_ && crystalCount > 1 && !(stack = BlockDemonCrystal.getItemStackDropped(type = this.getWillType(), 1)).m_41619_()) {
            this.setCrystalCount(crystalCount - 1);
            Containers.m_18992_((Level)this.m_58904_(), (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (ItemStack)stack);
            this.notifyUpdate();
            this.m_6596_();
            return true;
        }
        return false;
    }

    public double getCrystalGrowthPerSecond(double will) {
        double speed = 0.005 * Math.sqrt(will / 200.0);
        if (this.speedModifier > 0.0) {
            speed *= this.speedModifier;
        }
        return speed;
    }

    @Override
    public void deserialize(CompoundTag tag) {
        this.holder.readFromNBT(tag, "Will");
        this.placement = Direction.m_122376_((int)tag.m_128451_("placement"));
        this.progressToNextCrystal = tag.m_128459_("progress");
        this.willType = !tag.m_128441_("demonWillType") ? EnumDemonWillType.DEFAULT : EnumDemonWillType.valueOf(tag.m_128461_("demonWillType").toUpperCase(Locale.ROOT));
        this.injectedWill = tag.m_128459_("injectedWill");
        this.speedModifier = tag.m_128459_("speedModifier");
        this.appliedConversionRate = tag.m_128459_("appliedConversionRate");
    }

    @Override
    public CompoundTag serialize(CompoundTag tag) {
        this.holder.writeToNBT(tag, "Will");
        tag.m_128405_("placement", this.placement.m_122411_());
        tag.m_128347_("progress", this.progressToNextCrystal);
        if (this.willType == EnumDemonWillType.DEFAULT) {
            if (tag.m_128441_("demonWillType")) {
                tag.m_128473_("demonWillType");
            }
        } else {
            tag.m_128359_("demonWillType", this.willType.toString());
        }
        tag.m_128347_("injectedWill", this.injectedWill);
        tag.m_128347_("speedModifier", this.speedModifier);
        tag.m_128347_("appliedConversionRate", this.appliedConversionRate);
        return tag;
    }

    public int getCrystalCount() {
        BlockState state = this.f_58857_.m_8055_(this.m_58899_());
        return (Integer)state.m_61143_((Property)BlockDemonCrystal.AGE) + 1;
    }

    public void setCrystalCount(int crystalCount) {
        BlockState state = this.f_58857_.m_8055_(this.m_58899_());
        this.f_58857_.m_46597_(this.m_58899_(), (BlockState)state.m_61124_((Property)BlockDemonCrystal.AGE, (Comparable)Integer.valueOf(crystalCount - 1)));
    }

    public Direction getPlacement() {
        return this.placement;
    }

    public void setPlacement(Direction placement) {
        this.placement = placement;
    }
}

