/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.tile;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import wayoftime.bloodmagic.api.compat.EnumDemonWillType;
import wayoftime.bloodmagic.api.compat.IDemonWillConduit;
import wayoftime.bloodmagic.api.compat.IDemonWillGem;
import wayoftime.bloodmagic.api.compat.IDiscreteDemonWill;
import wayoftime.bloodmagic.common.tile.BloodMagicTileEntities;
import wayoftime.bloodmagic.common.tile.TileInventory;
import wayoftime.bloodmagic.demonaura.WorldDemonWillHandler;

public class TileDemonCrucible
extends TileInventory
implements IDemonWillConduit,
WorldlyContainer {
    public final int maxWill = 100;
    public final double gemDrainRate = 10.0;
    public HashMap<EnumDemonWillType, Double> willMap = new HashMap();
    public int internalCounter = 0;

    public TileDemonCrucible(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, 1, "demoncrucible", pos, state);
    }

    public TileDemonCrucible(BlockPos pos, BlockState state) {
        this((BlockEntityType)BloodMagicTileEntities.DEMON_CRUCIBLE_TYPE.get(), pos, state);
    }

    public void tick() {
        if (this.m_58904_().f_46443_) {
            return;
        }
        ++this.internalCounter;
        if (this.m_58904_().m_276867_(this.m_58899_())) {
            ItemStack stack = this.m_8020_(0);
            if (stack.m_41720_() instanceof IDemonWillGem) {
                IDemonWillGem gemItem = (IDemonWillGem)stack.m_41720_();
                for (EnumDemonWillType type : EnumDemonWillType.values()) {
                    double current;
                    double fillAmount;
                    if (!this.willMap.containsKey((Object)type) || !((fillAmount = Math.min(10.0, current = this.willMap.get((Object)type).doubleValue())) > 0.0)) continue;
                    fillAmount = gemItem.fillWill(type, stack, fillAmount, true);
                    if (this.willMap.get((Object)type) - fillAmount <= 0.0) {
                        this.willMap.remove((Object)type);
                        continue;
                    }
                    this.willMap.put(type, this.willMap.get((Object)type) - fillAmount);
                }
            }
        } else {
            ItemStack stack = this.m_8020_(0);
            if (!stack.m_41619_()) {
                if (stack.m_41720_() instanceof IDemonWillGem) {
                    IDemonWillGem gemItem = (IDemonWillGem)stack.m_41720_();
                    for (EnumDemonWillType type : EnumDemonWillType.values()) {
                        double currentAmount = WorldDemonWillHandler.getCurrentWill(this.m_58904_(), this.f_58858_, type);
                        double drainAmount = Math.min(100.0 - currentAmount, 10.0);
                        double filled = WorldDemonWillHandler.fillWillToMaximum(this.m_58904_(), this.f_58858_, type, drainAmount, 100.0, false);
                        if (!((filled = gemItem.drainWill(type, stack, filled, false)) > 0.0)) continue;
                        filled = gemItem.drainWill(type, stack, filled, true);
                        WorldDemonWillHandler.fillWillToMaximum(this.m_58904_(), this.f_58858_, type, filled, 100.0, true);
                    }
                } else if (stack.m_41720_() instanceof IDiscreteDemonWill) {
                    double filled;
                    double discreteAmount;
                    IDiscreteDemonWill willItem = (IDiscreteDemonWill)stack.m_41720_();
                    EnumDemonWillType type = willItem.getType(stack);
                    double currentAmount = WorldDemonWillHandler.getCurrentWill(this.m_58904_(), this.f_58858_, type);
                    double needed = 100.0 - currentAmount;
                    if (needed >= (discreteAmount = willItem.getDiscretization(stack)) && (filled = willItem.drainWill(stack, discreteAmount)) > 0.0) {
                        WorldDemonWillHandler.fillWillToMaximum(this.m_58904_(), this.f_58858_, type, filled, 100.0, true);
                        if (stack.m_41613_() <= 0) {
                            this.m_6836_(0, ItemStack.f_41583_);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void deserialize(CompoundTag tag) {
        super.deserialize(tag);
        this.willMap.clear();
        for (EnumDemonWillType type : EnumDemonWillType.values()) {
            double amount = tag.m_128459_("EnumWill" + type.name());
            if (!(amount > 0.0)) continue;
            this.willMap.put(type, amount);
        }
    }

    @Override
    public CompoundTag serialize(CompoundTag tag) {
        super.serialize(tag);
        for (Map.Entry<EnumDemonWillType, Double> entry : this.willMap.entrySet()) {
            tag.m_128347_("EnumWill" + entry.getKey().name(), entry.getValue().doubleValue());
        }
        return tag;
    }

    @Override
    public int getWeight() {
        return 10;
    }

    @Override
    public double fillDemonWill(EnumDemonWillType type, double amount, boolean doFill) {
        if (amount <= 0.0) {
            return 0.0;
        }
        if (!this.canFill(type)) {
            return 0.0;
        }
        if (!doFill) {
            if (!this.willMap.containsKey((Object)type)) {
                return Math.min(100.0, amount);
            }
            return Math.min(100.0 - this.willMap.get((Object)type), amount);
        }
        if (!this.willMap.containsKey((Object)type)) {
            double max = Math.min(100.0, amount);
            this.willMap.put(type, max);
            return max;
        }
        double current = this.willMap.get((Object)type);
        double filled = 100.0 - current;
        if (amount < filled) {
            this.willMap.put(type, current + amount);
            filled = amount;
        } else {
            this.willMap.put(type, 100.0);
        }
        return filled;
    }

    @Override
    public double drainDemonWill(EnumDemonWillType type, double amount, boolean doDrain) {
        if (!this.willMap.containsKey((Object)type)) {
            return 0.0;
        }
        double drained = amount;
        double current = this.willMap.get((Object)type);
        if (current < drained) {
            drained = current;
        }
        if (doDrain) {
            if ((current -= drained) <= 0.0) {
                this.willMap.remove((Object)type);
            } else {
                this.willMap.put(type, current);
            }
        }
        return drained;
    }

    @Override
    public boolean canFill(EnumDemonWillType type) {
        return true;
    }

    @Override
    public boolean canDrain(EnumDemonWillType type) {
        return true;
    }

    @Override
    public double getCurrentWill(EnumDemonWillType type) {
        return this.willMap.containsKey((Object)type) ? this.willMap.get((Object)type) : 0.0;
    }

    public int[] m_7071_(Direction side) {
        return new int[]{0};
    }

    public boolean m_7155_(int index, ItemStack stack, Direction direction) {
        return !stack.m_41619_() && ((ItemStack)this.inventory.get(0)).m_41619_() && (stack.m_41720_() instanceof IDemonWillGem || stack.m_41720_() instanceof IDiscreteDemonWill);
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return true;
    }
}

