/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.meteor;

import com.google.gson.JsonObject;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import wayoftime.bloodmagic.common.meteor.FluidBlockContainer;
import wayoftime.bloodmagic.common.meteor.RandomBlockTagContainer;
import wayoftime.bloodmagic.common.meteor.StaticBlockContainer;

public abstract class RandomBlockContainer {
    public abstract Block getRandomBlock(RandomSource var1, Level var2);

    public static RandomBlockContainer parseEntry(String str) {
        if (str.startsWith("#")) {
            String[] splitStr = str.split("#");
            int index = -1;
            String tagName = splitStr[1];
            TagKey tag = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation(tagName));
            if (splitStr.length > 2) {
                try {
                    index = Integer.parseInt(splitStr[2]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return new RandomBlockTagContainer((TagKey<Block>)tag, index);
        }
        if (str.startsWith(";")) {
            String[] splitStr = str.split(";");
            String fluidName = splitStr[1];
            return RandomBlockContainer.parseFluidEntry(fluidName);
        }
        return RandomBlockContainer.parseBlockEntry(str);
    }

    public abstract JsonObject serialize(int var1);

    public abstract JsonObject serialize();

    public static Pair<RandomBlockContainer, Integer> deserializeWeightedPair(JsonObject obj) {
        if (obj.has("tag")) {
            String entry = GsonHelper.m_13906_((JsonObject)obj, (String)"tag");
            int weight = GsonHelper.m_13927_((JsonObject)obj, (String)"weight");
            if (obj.has("index")) {
                int tagIndex = GsonHelper.m_13927_((JsonObject)obj, (String)"index");
                RandomBlockContainer container = RandomBlockContainer.parseTagEntry(entry, tagIndex);
                if (container != null) {
                    return Pair.of((Object)container, (Object)weight);
                }
            } else {
                RandomBlockContainer container = RandomBlockContainer.parseEntry(entry);
                if (container != null) {
                    return Pair.of((Object)container, (Object)weight);
                }
            }
        } else if (obj.has("fluid")) {
            String entry = GsonHelper.m_13906_((JsonObject)obj, (String)"fluid");
            int weight = GsonHelper.m_13927_((JsonObject)obj, (String)"weight");
            RandomBlockContainer container = RandomBlockContainer.parseFluidEntry(entry);
            if (container != null) {
                return Pair.of((Object)container, (Object)weight);
            }
        } else if (obj.has("block")) {
            String entry = GsonHelper.m_13906_((JsonObject)obj, (String)"block");
            int weight = GsonHelper.m_13927_((JsonObject)obj, (String)"weight");
            RandomBlockContainer container = RandomBlockContainer.parseBlockEntry(entry);
            if (container != null) {
                return Pair.of((Object)container, (Object)weight);
            }
        }
        return null;
    }

    public static RandomBlockContainer deserializeContainer(JsonObject obj) {
        String entry;
        RandomBlockContainer container;
        if (obj.has("tag")) {
            String entry2 = GsonHelper.m_13906_((JsonObject)obj, (String)"tag");
            if (obj.has("index")) {
                int tagIndex = GsonHelper.m_13927_((JsonObject)obj, (String)"index");
                RandomBlockContainer container2 = RandomBlockContainer.parseTagEntry(entry2, tagIndex);
                if (container2 != null) {
                    return container2;
                }
            } else {
                RandomBlockContainer container3 = RandomBlockContainer.parseEntry(entry2);
                if (container3 != null) {
                    return container3;
                }
            }
        } else if (obj.has("fluid")) {
            String entry3 = GsonHelper.m_13906_((JsonObject)obj, (String)"fluid");
            RandomBlockContainer container4 = RandomBlockContainer.parseFluidEntry(entry3);
            if (container4 != null) {
                return container4;
            }
        } else if (obj.has("block") && (container = RandomBlockContainer.parseBlockEntry(entry = GsonHelper.m_13906_((JsonObject)obj, (String)"block"))) != null) {
            return container;
        }
        return null;
    }

    public static RandomBlockContainer parseTagEntry(String str, int index) {
        TagKey tag = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation(str));
        return new RandomBlockTagContainer((TagKey<Block>)tag, index);
    }

    public static RandomBlockContainer parseBlockEntry(String str) {
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(str));
        if (block == null) {
            return null;
        }
        return new StaticBlockContainer(block);
    }

    public static RandomBlockContainer parseFluidEntry(String str) {
        String fluidName = str;
        Optional holderOptional = ForgeRegistries.FLUIDS.getHolder(new ResourceLocation(fluidName));
        if (holderOptional.isPresent()) {
            Fluid fluid = (Fluid)((Holder)holderOptional.get()).m_203334_();
            return new FluidBlockContainer(fluid);
        }
        return null;
    }

    public abstract String getEntry();
}

