/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item.routing;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import wayoftime.bloodmagic.common.item.inventory.InventoryFilter;
import wayoftime.bloodmagic.common.item.routing.BasicFilterKey;
import wayoftime.bloodmagic.common.item.routing.IFilterKey;
import wayoftime.bloodmagic.common.item.routing.ItemCompositeFilter;
import wayoftime.bloodmagic.util.GhostItemHelper;

public class ItemStandardFilter
extends ItemCompositeFilter {
    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (hand == InteractionHand.OFF_HAND) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (!world.f_46443_ && player instanceof ServerPlayer) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)this, buf -> {
                buf.writeBoolean(this.hasTagButton());
                buf.writeBoolean(this.hasEnchantButtons());
            });
        }
        return new InteractionResultHolder(InteractionResult.m_19078_((boolean)world.f_46443_), (Object)stack);
    }

    @Override
    public Component m_5446_() {
        return Component.m_237115_((String)"gui.bloodmagic.filter.standard");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack filterStack, Level world, List<Component> tooltip, TooltipFlag flag) {
        int whitelistState;
        boolean isWhitelist;
        tooltip.add((Component)Component.m_237115_((String)"tooltip.bloodmagic.basicfilter.desc").m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GRAY));
        if (filterStack.m_41783_() == null) {
            return;
        }
        List<ItemStack> nestedFilters = this.getNestedFilters(filterStack);
        if (nestedFilters.size() > 0) {
            boolean sneaking = Screen.m_96638_();
            if (!sneaking) {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.bloodmagic.extraInfo").m_130940_(ChatFormatting.BLUE));
            } else {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.bloodmagic.contained_filters").m_130940_(ChatFormatting.BLUE));
                for (ItemStack nestedStack : nestedFilters) {
                    tooltip.add(nestedStack.m_41786_());
                }
            }
        }
        boolean bl = isWhitelist = (whitelistState = this.getCurrentButtonState(filterStack, "blackwhitelist", 0)) == 0;
        if (isWhitelist) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.bloodmagic.filter.whitelist").m_130940_(ChatFormatting.GRAY));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.bloodmagic.filter.blacklist").m_130940_(ChatFormatting.GRAY));
        }
        InventoryFilter inv = ItemStandardFilter.getInv(filterStack);
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            if (isWhitelist) {
                int amount = GhostItemHelper.getItemGhostAmount(stack);
                if (amount > 0) {
                    tooltip.add((Component)Component.m_237110_((String)"tooltip.bloodmagic.filter.count", (Object[])new Object[]{amount, stack.m_41786_()}));
                    continue;
                }
                tooltip.add((Component)Component.m_237110_((String)"tooltip.bloodmagic.filter.all", (Object[])new Object[]{stack.m_41786_()}));
                continue;
            }
            tooltip.add(stack.m_41786_());
        }
    }

    @Override
    public IFilterKey getFilterKey(ItemStack filterStack, int slot, ItemStack ghostStack, int amount) {
        return new BasicFilterKey(ghostStack, amount);
    }
}

