/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item.routing;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.components.Button;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkHooks;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import wayoftime.bloodmagic.client.button.FilterButtonTogglePress;
import wayoftime.bloodmagic.common.container.item.ContainerFilter;
import wayoftime.bloodmagic.common.item.inventory.DataFilter;
import wayoftime.bloodmagic.common.item.inventory.InventoryFilter;
import wayoftime.bloodmagic.common.item.routing.BasicFilterKey;
import wayoftime.bloodmagic.common.item.routing.IFilterKey;
import wayoftime.bloodmagic.common.item.routing.IItemFilterProvider;
import wayoftime.bloodmagic.common.routing.BasicItemFilter;
import wayoftime.bloodmagic.common.routing.BlacklistItemFilter;
import wayoftime.bloodmagic.common.routing.IItemFilter;
import wayoftime.bloodmagic.util.BMLog;
import wayoftime.bloodmagic.util.GhostItemHelper;

public class ItemRouterFilter
extends Item
implements MenuProvider,
IItemFilterProvider {
    public static final int inventorySize = 9;
    public static final int maxUpgrades = 9;
    public static final String FILTER_INV = "filterInventory";
    public static final int DATA_SLOT = 0;
    public static final int DATA_BWLIST = 1;
    public static final int DATA_TAG = 2;
    public static final int DATA_ENCHANT = 11;
    public static final int DATA_ENCHANT_LVL = 20;
    public static final int BUTTON_BWLIST = 0;
    public static final int BUTTON_TAG = 1;
    public static final int BUTTON_ENCHANT_KIND = 2;
    public static final int BUTTON_ENCHANT_LEVEL = 3;

    public ItemRouterFilter() {
        super(new Item.Properties().m_41487_(16));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (hand == InteractionHand.OFF_HAND) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (!world.f_46443_ && player instanceof ServerPlayer) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)this, buf -> {
                buf.writeBoolean(this.hasTagButton());
                buf.writeBoolean(this.hasEnchantButtons());
            });
        }
        return new InteractionResultHolder(InteractionResult.m_19078_((boolean)world.f_46443_), (Object)stack);
    }

    public boolean hasTagButton() {
        return false;
    }

    public boolean hasEnchantButtons() {
        return false;
    }

    public AbstractContainerMenu m_7208_(int containerId, Inventory playerInv, Player player) {
        assert (player.m_20193_() != null);
        final ItemStack stack = player.m_21205_();
        ArrayList<Integer> content = new ArrayList<Integer>(29);
        for (int i = 0; i < 29; ++i) {
            content.add(0);
        }
        final CompoundTag tag = stack.m_41784_();
        final InventoryFilter filterInv = new InventoryFilter(9){

            @Override
            public boolean isItemValid(int slot, @NotNull ItemStack stack2) {
                return !(stack2.m_41720_() instanceof ItemRouterFilter);
            }

            public void setStackInSlot(int slot, @NotNull ItemStack contentStack) {
                super.setStackInSlot(slot, contentStack);
                tag.m_128365_("itemInventory", (Tag)this.serializeNBT());
                stack.m_41751_(tag);
            }
        };
        filterInv.deserializeNBT(tag.m_128469_("itemInventory"));
        if (tag.m_128441_("selected_slot")) {
            content.set(0, tag.m_128451_("selected_slot"));
        } else {
            content.set(0, -1);
        }
        content.set(1, tag.m_128451_("button:blackwhitelist"));
        for (int i = 0; i < 9; ++i) {
            content.set(2 + i, tag.m_128451_("button:itemtag"));
            content.set(11 + i, tag.m_128451_("button:enchant"));
            content.set(20 + i, tag.m_128451_("button:enchant_fuzzy"));
        }
        DataFilter data = new DataFilter(content){

            @Override
            public void save(int index) {
                if (index == 0) {
                    tag.m_128405_("selected_slot", ((Integer)this.content.get(index)).intValue());
                    stack.m_41751_(tag);
                    return;
                }
                if (index == 1) {
                    tag.m_128405_("button:blackwhitelist", ((Integer)this.content.get(index)).intValue());
                    stack.m_41751_(tag);
                    return;
                }
                String nbt = "";
                int offset = -1;
                if (index >= 20) {
                    nbt = "button:enchant_fuzzy";
                    offset = index - 20;
                } else if (index >= 11) {
                    nbt = "button:enchant";
                    offset = index - 11;
                } else if (index >= 2) {
                    nbt = "button:itemtag";
                    offset = index - 2;
                    if ((Integer)this.content.get(index) != 0) {
                        CompoundTag ghostTag = filterInv.getStackInSlot(offset).m_41784_();
                        tag.m_128359_("tag" + offset, ghostTag.m_128461_("tag"));
                    } else {
                        tag.m_128473_("tag" + offset);
                    }
                }
                if (nbt.equalsIgnoreCase("") || offset == -1) {
                    BMLog.DEFAULT.warn("Trying to save index {} but its unknown", index);
                    return;
                }
                tag.m_128405_(nbt + offset, ((Integer)this.content.get(index)).intValue());
                stack.m_41751_(tag);
            }
        };
        return new ContainerFilter(containerId, player, playerInv, filterInv, data, this.hasTagButton(), this.hasEnchantButtons());
    }

    public Component m_5446_() {
        return Component.m_237113_((String)"Whoops, forgot to override getDisplayName here I guess");
    }

    @Override
    public ItemStack getContainedStackForItem(ItemStack filterStack, ItemStack keyStack) {
        ItemStack copyStack = keyStack.m_41777_();
        GhostItemHelper.setItemGhostAmount(copyStack, 0);
        copyStack.m_41764_(1);
        return copyStack;
    }

    protected IItemFilter getFilterTypeFromConfig(ItemStack filterStack) {
        int state = this.getCurrentButtonState(filterStack, "blackwhitelist", 0);
        if (state == 1) {
            return new BlacklistItemFilter();
        }
        return new BasicItemFilter();
    }

    @Override
    public IFilterKey getFilterKey(ItemStack filterStack, int slot, ItemStack ghostStack, int amount) {
        return new BasicFilterKey(ghostStack, amount);
    }

    public static InventoryFilter getInv(ItemStack filterStack) {
        InventoryFilter ret = new InventoryFilter(9);
        ret.deserializeNBT(filterStack.m_41784_().m_128469_("itemInventory"));
        return ret;
    }

    @Override
    public IItemFilter getInputItemFilter(ItemStack filterStack, BlockEntity tile, IItemHandler handler) {
        IItemFilter testFilter = this.getFilterTypeFromConfig(filterStack);
        ArrayList<IFilterKey> filteredList = new ArrayList<IFilterKey>();
        InventoryFilter inv = ItemRouterFilter.getInv(filterStack);
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            int amount = GhostItemHelper.getItemGhostAmount(stack);
            ItemStack ghostStack = GhostItemHelper.getSingleStackFromGhost(stack);
            IFilterKey key = this.getFilterKey(filterStack, i, ghostStack, amount);
            filteredList.add(key);
        }
        testFilter.initializeFilter(filteredList, tile, handler, false);
        return testFilter;
    }

    @Override
    public IItemFilter getOutputItemFilter(ItemStack filterStack, BlockEntity tile, IItemHandler handler) {
        IItemFilter testFilter = this.getFilterTypeFromConfig(filterStack);
        ArrayList<IFilterKey> filteredList = new ArrayList<IFilterKey>();
        InventoryFilter inv = ItemRouterFilter.getInv(filterStack);
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            int amount = GhostItemHelper.getItemGhostAmount(stack);
            ItemStack ghostStack = GhostItemHelper.getSingleStackFromGhost(stack);
            if (amount == 0) {
                amount = Integer.MAX_VALUE;
            }
            IFilterKey key = this.getFilterKey(filterStack, i, ghostStack, amount);
            filteredList.add(key);
        }
        testFilter.initializeFilter(filteredList, tile, handler, true);
        return testFilter;
    }

    @Override
    public void setGhostItemAmount(ItemStack filterStack, int ghostItemSlot, int amount) {
        InventoryFilter inv = ItemRouterFilter.getInv(filterStack);
        ItemStack stack = inv.getStackInSlot(ghostItemSlot);
        if (!stack.m_41619_()) {
            GhostItemHelper.setItemGhostAmount(stack, amount);
            CompoundTag tag = filterStack.m_41783_();
            tag.m_128365_("itemInventory", (Tag)inv.serializeNBT());
            filterStack.m_41751_(tag);
        }
    }

    @Override
    public int receiveButtonPress(ItemStack filterStack, String buttonKey, int ghostItemSlot, int currentButtonState) {
        CompoundTag tag = filterStack.m_41783_();
        if (tag == null) {
            filterStack.m_41751_(new CompoundTag());
            tag = filterStack.m_41783_();
        }
        if (buttonKey.equals("blackwhitelist")) {
            int nextState = 0;
            switch (currentButtonState) {
                case 0: {
                    nextState = 1;
                    break;
                }
                default: {
                    nextState = 0;
                }
            }
            tag.m_128405_("button:blackwhitelist", nextState);
            return nextState;
        }
        return -1;
    }

    @Override
    public int getCurrentButtonState(ItemStack filterStack, String buttonKey, int ghostItemSlot) {
        CompoundTag tag = filterStack.m_41783_();
        if (tag != null && buttonKey.equals("blackwhitelist")) {
            int state = tag.m_128451_("button:blackwhitelist");
            return state;
        }
        return -1;
    }

    @Override
    public List<Component> getTextForHoverItem(ItemStack filterStack, String buttonKey, int ghostItemSlot) {
        ArrayList<Component> componentList = new ArrayList<Component>();
        int currentState = this.getCurrentButtonState(filterStack, buttonKey, ghostItemSlot);
        if (buttonKey.equals("blackwhitelist")) {
            switch (currentState) {
                case 1: {
                    componentList.add((Component)Component.m_237115_((String)"filter.bloodmagic.blacklist"));
                    break;
                }
                default: {
                    componentList.add((Component)Component.m_237115_((String)"filter.bloodmagic.whitelist"));
                }
            }
        }
        return componentList;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Pair<String, Button.OnPress>> getButtonAction(ContainerFilter container) {
        ArrayList<Pair<String, Button.OnPress>> buttonList = new ArrayList<Pair<String, Button.OnPress>>();
        buttonList.add(Pair.of((Object)"blackwhitelist", (Object)new FilterButtonTogglePress("blackwhitelist", container)));
        return buttonList;
    }

    @Override
    public Pair<Integer, Integer> getTexturePositionForState(ItemStack filterStack, String buttonKey, int currentButtonState) {
        if (buttonKey.equals("blackwhitelist")) {
            switch (currentButtonState) {
                case 1: {
                    return Pair.of((Object)176, (Object)20);
                }
            }
            return Pair.of((Object)176, (Object)0);
        }
        return Pair.of((Object)0, (Object)0);
    }

    @Override
    public boolean isButtonGlobal(ItemStack filterStack, String buttonKey) {
        return buttonKey.equals("blackwhitelist");
    }

    @Override
    public IItemFilter getUninitializedItemFilter(ItemStack filterStack) {
        IItemFilter testFilter = this.getFilterTypeFromConfig(filterStack);
        ArrayList<IFilterKey> filteredList = new ArrayList<IFilterKey>();
        InventoryFilter inv = ItemRouterFilter.getInv(filterStack);
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            int amount = GhostItemHelper.getItemGhostAmount(stack);
            ItemStack ghostStack = GhostItemHelper.getSingleStackFromGhost(stack);
            IFilterKey key = this.getFilterKey(filterStack, i, ghostStack, amount);
            filteredList.add(key);
        }
        testFilter.initializeFilter(filteredList);
        return testFilter;
    }
}

