/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item.routing;

import java.util.Map;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import wayoftime.bloodmagic.common.item.routing.IFilterKey;

public class EnchantFilterKey
implements IFilterKey {
    private Enchantment enchantment;
    private int enchantLevel;
    private boolean isFuzzy;
    private int count;

    public EnchantFilterKey(Enchantment enchantment, int enchantLevel, boolean isFuzzy, int count) {
        this.enchantment = enchantment;
        this.enchantLevel = enchantLevel;
        this.isFuzzy = isFuzzy;
        this.count = count;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean doesStackMatch(ItemStack testStack) {
        int level = 0;
        if (testStack.m_41720_() == Items.f_42690_) {
            Map enchants = EnchantmentHelper.m_44831_((ItemStack)testStack);
            if (!enchants.containsKey(this.enchantment)) return false;
            level = (Integer)enchants.get(this.enchantment);
        } else {
            level = EnchantmentHelper.m_44843_((Enchantment)this.enchantment, (ItemStack)testStack);
        }
        if (this.isFuzzy) {
            if (level <= 0) return false;
            return true;
        }
        if (level != this.enchantLevel) return false;
        return true;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public void setCount(int count) {
        this.count = count;
    }

    @Override
    public void shrink(int changeAmount) {
        this.count -= changeAmount;
    }

    @Override
    public void grow(int changeAmount) {
        this.count += changeAmount;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }
}

